/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.ide.common.util.AssetUtil;
import com.android.resources.Density;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.adtui.validation.validators.FalseValidator;
import com.android.tools.idea.npw.assetstudio.AdaptiveIconGenerator;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGenerator;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.CategoryIconMap;
import com.android.tools.idea.npw.assetstudio.wizard.CheckeredBackgroundPanel;
import com.android.tools.idea.npw.assetstudio.wizard.GenerateIconsModel;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.expressions.value.AsValueExpression;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.ui.FileTreeCellRenderer;
import com.android.tools.idea.ui.FileTreeModel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.utils.XmlUtils;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfirmGenerateImagesStep
extends ModelWizardStep<GenerateIconsModel> {
    private static final DefaultTreeModel EMPTY_MODEL = new DefaultTreeModel(null);
    private final ValidatorPanel myValidatorPanel;
    private final ListenerManager myListeners;
    private final JBLabel myPreviewIcon;
    private JPanel myRootPanel;
    private JComboBox<AndroidSourceSet> myPathsComboBox;
    private Tree myOutputPreviewTree;
    private CheckeredBackgroundPanel myPreviewPanel;
    private JTextField mySizeDpTextField;
    private JTextField myDensityTextField;
    private JTextField myFileTypeTextField;
    private JTextField mySizePxTextField;
    private JSplitPane mySplitPane;
    private Map<FileTreeModel.Node, GeneratedIcon> myNodeToPreviewImage;
    private JPanel myLeftPanel;
    private JPanel myRightPanel;
    private JPanel myPreviewFillPanel;
    private TitledSeparator myDetailsHeaderPanel;
    private JPanel myDetailsGridContainer;
    private JPanel myDensityRow;
    private JPanel mySizeDetailsRow;
    private JPanel mySizePxRow;
    private JPanel myDetailsPanel;
    private JPanel myImagePreviewPanel;
    private JPanel myXmlPreviewPanel;
    private JTextPane myXmlTextPane;
    private EditorEx myFilePreviewEditor;
    private EditorFactory myEditorFactory;
    private Document myXmlPreviewDocument;
    private ObservableValue<AndroidSourceSet> mySelectedSourceSet;
    private BoolProperty myFilesAlreadyExist;

    public ConfirmGenerateImagesStep(@NotNull GenerateIconsModel model, @NotNull List<AndroidSourceSet> sourceSets) {
        if (model == null) {
            ConfirmGenerateImagesStep.$$$reportNull$$$0(0);
        }
        if (sourceSets == null) {
            ConfirmGenerateImagesStep.$$$reportNull$$$0(1);
        }
        super(model, "Confirm Icon Path");
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myNodeToPreviewImage = new HashMap<FileTreeModel.Node, GeneratedIcon>();
        this.myFilesAlreadyExist = new BoolValueProperty();
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myRootPanel);
        DefaultComboBoxModel<AndroidSourceSet> sourceSetsModel = new DefaultComboBoxModel<AndroidSourceSet>();
        for (AndroidSourceSet sourceSet : sourceSets) {
            sourceSetsModel.addElement(sourceSet);
        }
        this.myPathsComboBox.setRenderer((ListCellRenderer<AndroidSourceSet>)new ListCellRendererWrapper<AndroidSourceSet>(){

            public void customize(JList list, AndroidSourceSet sourceSet, int index, boolean selected, boolean hasFocus) {
                this.setText(sourceSet.getName());
            }
        });
        this.myPathsComboBox.setModel(sourceSetsModel);
        this.myOutputPreviewTree.setModel((TreeModel)EMPTY_MODEL);
        this.myOutputPreviewTree.setCellRenderer((TreeCellRenderer)((Object)new FileTreeCellRenderer()));
        this.myOutputPreviewTree.setBorder(BorderFactory.createLineBorder(UIUtil.getBoundsColor()));
        this.myOutputPreviewTree.setRowHeight(-1);
        this.myOutputPreviewTree.getEmptyText().setText("No resource folder defined in project");
        this.myOutputPreviewTree.addTreeSelectionListener(e -> {
            TreePath newPath = e.getNewLeadSelectionPath();
            this.showSelectedNodeDetails(newPath);
        });
        String alreadyExistsError = WizardUtils.toHtmlString("Some existing files will be overwritten by this operation.<br>Files which replace existing files are marked red in the preview above.");
        this.myValidatorPanel.registerValidator((ObservableValue)this.myFilesAlreadyExist, (Validator)new FalseValidator(Validator.Severity.WARNING, alreadyExistsError));
        this.myPreviewIcon = new JBLabel();
        this.myPreviewIcon.setVisible(false);
        this.myPreviewIcon.setHorizontalAlignment(0);
        this.myPreviewIcon.setVerticalAlignment(0);
        this.myPreviewPanel.setLayout(new BorderLayout());
        this.myPreviewPanel.add((Component)this.myPreviewIcon, "Center");
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.mySplitPane);
    }

    private void showSelectedNodeDetails(TreePath newPath) {
        if (newPath != null && newPath.getLastPathComponent() instanceof FileTreeModel.Node) {
            FileTreeModel.Node node = (FileTreeModel.Node)newPath.getLastPathComponent();
            GeneratedIcon generatedIcon = this.myNodeToPreviewImage.get(node);
            if (generatedIcon instanceof GeneratedImageIcon) {
                GeneratedImageIcon generatedImageIcon = (GeneratedImageIcon)generatedIcon;
                BufferedImage image = generatedImageIcon.getImage();
                ImageIcon icon = new ImageIcon(image);
                this.myPreviewIcon.setIcon((Icon)icon);
                this.myPreviewIcon.setVisible(true);
                String extension = FileUtilRt.getExtension((String)node.name).toUpperCase();
                if (StringUtil.isEmpty((String)extension)) {
                    this.myFileTypeTextField.setText("N/A");
                } else {
                    this.myFileTypeTextField.setText(String.format("%s File", extension));
                }
                this.mySizePxTextField.setText(String.format("%dx%d", icon.getIconWidth(), icon.getIconHeight()));
                Density density = generatedImageIcon.getDensity();
                this.myDensityTextField.setText(density.getResourceValue());
                float scaleFactor = GraphicGenerator.getMdpiScaleFactor(density);
                this.mySizeDpTextField.setText(String.format("%dx%d", Math.round((float)icon.getIconWidth() / scaleFactor), Math.round((float)icon.getIconHeight() / scaleFactor)));
                this.mySizeDetailsRow.setVisible(true);
                this.mySizePxRow.setVisible(true);
                this.myImagePreviewPanel.setVisible(true);
                this.myXmlPreviewPanel.setVisible(false);
                return;
            }
            if (generatedIcon instanceof GeneratedXmlResource) {
                GeneratedXmlResource xml = (GeneratedXmlResource)generatedIcon;
                String xmlText = xml.getXmlText();
                BufferedImage image = this.getPreviewImage(xml);
                if (image == null) {
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (this.myEditorFactory == null) {
                            this.myEditorFactory = EditorFactory.getInstance();
                        }
                        if (this.myXmlPreviewDocument == null) {
                            this.myXmlPreviewDocument = this.myEditorFactory.createDocument((CharSequence)"");
                        }
                        this.myXmlPreviewDocument.setReadOnly(false);
                        this.myXmlPreviewDocument.setText((CharSequence)xmlText);
                        this.myXmlPreviewDocument.setReadOnly(true);
                        if (this.myFilePreviewEditor == null) {
                            this.myFilePreviewEditor = (EditorEx)this.myEditorFactory.createViewer(this.myXmlPreviewDocument);
                            this.myFilePreviewEditor.setCaretVisible(false);
                            this.myFilePreviewEditor.getSettings().setLineNumbersShown(false);
                            this.myFilePreviewEditor.getSettings().setLineMarkerAreaShown(false);
                            this.myFilePreviewEditor.getSettings().setFoldingOutlineShown(false);
                            this.myFilePreviewEditor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(null, (FileType)StdFileTypes.XML));
                            this.myXmlPreviewPanel.removeAll();
                            this.myXmlPreviewPanel.add(this.myFilePreviewEditor.getComponent());
                        }
                    });
                    this.myImagePreviewPanel.setVisible(false);
                    this.myXmlPreviewPanel.setVisible(true);
                } else {
                    ImageIcon icon = new ImageIcon(image);
                    this.myPreviewIcon.setIcon((Icon)icon);
                    String drawableType = ConfirmGenerateImagesStep.getDrawableType(xmlText);
                    this.myFileTypeTextField.setText(drawableType);
                    this.myPreviewIcon.setVisible(true);
                    this.myDensityTextField.setText(Density.ANYDPI.getShortDisplayValue());
                    Dimension dpSize = ConfirmGenerateImagesStep.getDpSize(xml);
                    if (dpSize == null) {
                        this.mySizeDetailsRow.setVisible(false);
                    } else {
                        this.mySizeDpTextField.setText(String.format("%dx%d", dpSize.width, dpSize.height));
                        this.mySizeDetailsRow.setVisible(true);
                    }
                    this.mySizePxRow.setVisible(false);
                    this.myImagePreviewPanel.setVisible(true);
                    this.myXmlPreviewPanel.setVisible(false);
                }
                return;
            }
        }
        this.myPreviewIcon.setVisible(false);
        this.myPreviewIcon.setIcon(null);
        this.myFileTypeTextField.setText("");
        this.mySizeDpTextField.setText("");
        this.mySizePxTextField.setText("");
        this.myDensityTextField.setText("");
        this.myImagePreviewPanel.setVisible(true);
        this.myXmlPreviewPanel.setVisible(false);
    }

    @NotNull
    private static String getDrawableType(@NotNull String xmlText) {
        String tagName;
        if (xmlText == null) {
            ConfirmGenerateImagesStep.$$$reportNull$$$0(2);
        }
        if ((tagName = XmlUtils.getRootTagName((String)xmlText)) != null) {
            switch (tagName) {
                case "vector": {
                    if ("Vector Drawable" == null) {
                        ConfirmGenerateImagesStep.$$$reportNull$$$0(3);
                    }
                    return "Vector Drawable";
                }
                case "shape": {
                    if ("Shape Drawable" == null) {
                        ConfirmGenerateImagesStep.$$$reportNull$$$0(4);
                    }
                    return "Shape Drawable";
                }
                case "bitmap": {
                    if ("Bitmap Drawable" == null) {
                        ConfirmGenerateImagesStep.$$$reportNull$$$0(5);
                    }
                    return "Bitmap Drawable";
                }
                case "layer-list": {
                    if ("Layer List" == null) {
                        ConfirmGenerateImagesStep.$$$reportNull$$$0(6);
                    }
                    return "Layer List";
                }
            }
        }
        if ("Drawable" == null) {
            ConfirmGenerateImagesStep.$$$reportNull$$$0(7);
        }
        return "Drawable";
    }

    @Nullable
    private static Dimension getDpSize(@NotNull GeneratedXmlResource xml) {
        IconCategory xmlCategory;
        if (xml == null) {
            ConfirmGenerateImagesStep.$$$reportNull$$$0(8);
        }
        if ((xmlCategory = xml.getCategory()) == IconCategory.ADAPTIVE_BACKGROUND_LAYER || xmlCategory == IconCategory.ADAPTIVE_FOREGROUND_LAYER) {
            return AdaptiveIconGenerator.SIZE_FULL_BLEED_DP;
        }
        return null;
    }

    @Nullable
    private BufferedImage getPreviewImage(@NotNull GeneratedXmlResource xml) {
        if (xml == null) {
            ConfirmGenerateImagesStep.$$$reportNull$$$0(9);
        }
        String xmlText = xml.getXmlText();
        AndroidIconGenerator generator = ((GenerateIconsModel)this.getModel()).getIconGenerator();
        IconCategory xmlCategory = xml.getCategory();
        if (generator != null && (xmlCategory == IconCategory.ADAPTIVE_BACKGROUND_LAYER || xmlCategory == IconCategory.ADAPTIVE_FOREGROUND_LAYER)) {
            GraphicGeneratorContext generatorContext = generator.getGraphicGeneratorContext();
            Rectangle rectangle = AssetUtil.scaleRectangle((Rectangle)AdaptiveIconGenerator.IMAGE_SIZE_FULL_BLEED_DP, (float)(GraphicGenerator.getMdpiScaleFactor(Density.XHIGH) * 0.8f));
            ListenableFuture<BufferedImage> imageFuture = generatorContext.renderDrawable(xmlText, rectangle.getSize());
            try {
                return (BufferedImage)imageFuture.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        ValidatorPanel validatorPanel = this.myValidatorPanel;
        if (validatorPanel == null) {
            ConfirmGenerateImagesStep.$$$reportNull$$$0(10);
        }
        return validatorPanel;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            ConfirmGenerateImagesStep.$$$reportNull$$$0(11);
        }
        this.mySelectedSourceSet = new AsValueExpression<AndroidSourceSet>(new SelectedItemProperty(this.myPathsComboBox));
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            ConfirmGenerateImagesStep.$$$reportNull$$$0(12);
        }
        return observableBool;
    }

    @Override
    protected void onProceeding() {
        ((GenerateIconsModel)this.getModel()).setPaths(this.mySelectedSourceSet.get().getPaths());
    }

    @Override
    protected void onEntering() {
        this.myListeners.release(this.mySelectedSourceSet);
        this.myListeners.receiveAndFire(this.mySelectedSourceSet, sourceSet -> {
            int i;
            AndroidIconGenerator iconGenerator = ((GenerateIconsModel)this.getModel()).getIconGenerator();
            File resDir = sourceSet.getPaths().getResDirectory();
            if (iconGenerator == null || resDir == null || resDir.getParentFile() == null) {
                return;
            }
            this.myNodeToPreviewImage.clear();
            Map<File, GeneratedIcon> pathIconMap = iconGenerator.generateIntoIconMap(sourceSet.getPaths());
            this.myFilesAlreadyExist.set(false);
            FileTreeModel treeModel = new FileTreeModel(resDir.getParentFile(), true);
            for (Map.Entry<File, GeneratedIcon> entry : pathIconMap.entrySet()) {
                File path = entry.getKey();
                GeneratedIcon icon = entry.getValue();
                if (path.exists()) {
                    this.myFilesAlreadyExist.set(true);
                }
                FileTreeModel.Node newNode = treeModel.forceAddFile(path, null);
                this.myNodeToPreviewImage.put(newNode, icon);
            }
            Set<File> outputDirectories = pathIconMap.keySet().stream().flatMap(x -> {
                File root = resDir.getParentFile();
                ArrayList<File> directories = new ArrayList<File>();
                for (x = x.getParentFile(); x != null && !Objects.equals(x, root); x = x.getParentFile()) {
                    directories.add((File)x);
                }
                return directories.stream();
            }).distinct().collect(Collectors.toSet());
            treeModel.sort(ConfirmGenerateImagesStep.getFileComparator(outputDirectories));
            this.myOutputPreviewTree.setModel((TreeModel)treeModel);
            for (i = 0; i < this.myOutputPreviewTree.getRowCount(); ++i) {
                this.myOutputPreviewTree.expandRow(i);
            }
            for (i = 0; i < this.myOutputPreviewTree.getRowCount(); ++i) {
                TreePath rowPath = this.myOutputPreviewTree.getPathForRow(i);
                if (rowPath == null || !treeModel.isLeaf(rowPath.getLastPathComponent())) continue;
                this.myOutputPreviewTree.setSelectionRow(i);
                break;
            }
        });
    }

    @NotNull
    private static Comparator<File> getFileComparator(Set<File> outputDirectories) {
        Comparator comparator = (file1, file2) -> {
            boolean isDirectory2;
            boolean isDirectory1 = outputDirectories.contains(file1);
            if (isDirectory1 == (isDirectory2 = outputDirectories.contains(file2))) {
                String path1 = file1.getAbsolutePath();
                String path2 = file2.getAbsolutePath();
                Density density1 = CategoryIconMap.pathToDensity(path1 + File.separator);
                Density density2 = CategoryIconMap.pathToDensity(path2 + File.separator);
                if (density1 != null && density2 != null && density1 != density2) {
                    return Ints.compare((int)density2.ordinal(), (int)density1.ordinal());
                }
                return path1.compareTo(path2);
            }
            if (isDirectory1) {
                return -1;
            }
            return 1;
        };
        if (comparator == null) {
            ConfirmGenerateImagesStep.$$$reportNull$$$0(13);
        }
        return comparator;
    }

    @Override
    public void dispose() {
        if (this.myEditorFactory != null && this.myFilePreviewEditor != null) {
            this.myEditorFactory.releaseEditor((Editor)this.myFilePreviewEditor);
        }
        this.myListeners.releaseAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlText";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/wizard/ConfirmGenerateImagesStep";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/wizard/ConfirmGenerateImagesStep";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDrawableType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDrawableType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDpSize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewImage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TitledSeparator titledSeparator;
        JTextPane jTextPane;
        JPanel jPanel;
        CheckeredBackgroundPanel checkeredBackgroundPanel;
        JPanel jPanel2;
        JTextField jTextField;
        JPanel jPanel3;
        JTextField jTextField2;
        JPanel jPanel4;
        JTextField jTextField3;
        JPanel jPanel5;
        JTextField jTextField4;
        JPanel jPanel6;
        JPanel jPanel7;
        JPanel jPanel8;
        JPanel jPanel9;
        Tree tree;
        JPanel jPanel10;
        JSplitPane jSplitPane;
        JPanel jPanel11;
        this.myRootPanel = jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySplitPane = jSplitPane = new JSplitPane();
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerLocation(500);
        jPanel11.add((Component)jSplitPane, new GridConstraints(0, 0, 2, 3, 0, 3, 3, 3, null, null, null));
        this.myLeftPanel = jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel10);
        JLabel jLabel = new JLabel();
        jLabel.setText("Res Directory:");
        jPanel10.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Output Directories:");
        jPanel10.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myPathsComboBox = jComboBox;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel10.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel10.add((Component)jBScrollPane, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myOutputPreviewTree = tree = new Tree();
        tree.setOpaque(false);
        tree.setToolTipText("A preview rendering of the output tree");
        jBScrollPane.setViewportView((Component)tree);
        this.myRightPanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel9);
        this.myDetailsPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel8, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myImagePreviewPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDetailsGridContainer = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel12, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myFileTypeTextField = jTextField4 = new JTextField();
        jTextField4.setEditable(false);
        jPanel12.add((Component)jTextField4, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("File Type:");
        jPanel12.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDensityRow = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myDensityTextField = jTextField3 = new JTextField();
        jTextField3.setEditable(false);
        jPanel5.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Density:");
        jPanel5.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySizeDetailsRow = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel4, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.mySizeDpTextField = jTextField2 = new JTextField();
        jTextField2.setEditable(false);
        jPanel4.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Size (dp):");
        jPanel4.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySizePxRow = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.mySizePxTextField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Size (px):");
        jPanel3.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel7.add((Component)jBScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myPreviewFillPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane2.setViewportView(jPanel2);
        this.myPreviewPanel = checkeredBackgroundPanel = new CheckeredBackgroundPanel();
        jPanel2.add((Component)checkeredBackgroundPanel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myXmlPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myXmlTextPane = jTextPane = new JTextPane();
        jTextPane.setText("<xml></xml>");
        jPanel.add((Component)jTextPane, "Center");
        this.myDetailsHeaderPanel = titledSeparator = new TitledSeparator();
        titledSeparator.setText("Output File");
        jPanel9.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

