/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.profilers.LegacyCpuTraceProfiler;
import com.android.tools.profiler.proto.CpuProfiler;
import com.google.protobuf3jarjar.ByteString;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class StudioLegacyCpuTraceProfiler
implements LegacyCpuTraceProfiler {
    @NotNull
    private IDevice myDevice;
    @NotNull
    private final Object myLegacyProfilingLock;
    @NotNull
    private final Map<Integer, LegacyProfilingRecord> myLegacyProfilingRecord;

    private static Logger getLogger() {
        return Logger.getInstance(StudioLegacyCpuTraceProfiler.class);
    }

    public StudioLegacyCpuTraceProfiler(@NotNull IDevice device) {
        if (device == null) {
            StudioLegacyCpuTraceProfiler.$$$reportNull$$$0(0);
        }
        this.myLegacyProfilingLock = new Object();
        this.myLegacyProfilingRecord = new HashMap<Integer, LegacyProfilingRecord>();
        this.myDevice = device;
        LegacyProfilingHandler profilingHandler = LegacyProfilingHandler.getInstance();
        ClientData.setMethodProfilingHandler((ClientData.IMethodProfilingHandler)profilingHandler);
        profilingHandler.addProfilingRecords(this.myDevice, this.myLegacyProfilingRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CpuProfiler.CpuProfilingAppStartResponse startProfilingApp(CpuProfiler.CpuProfilingAppStartRequest request) {
        Client client;
        CpuProfiler.CpuProfilingAppStartResponse.Builder responseBuilder = CpuProfiler.CpuProfilingAppStartResponse.newBuilder();
        String appPkgName = this.myDevice.getClientName(request.getProcessId());
        Client client2 = client = appPkgName != null ? this.myDevice.getClient(appPkgName) : null;
        if (client == null) {
            return responseBuilder.setStatus(CpuProfiler.CpuProfilingAppStartResponse.Status.FAILURE).setErrorMessage("App is not running.").build();
        }
        Object object = this.myLegacyProfilingLock;
        synchronized (object) {
            LegacyProfilingRecord record = this.myLegacyProfilingRecord.get(request.getProcessId());
            if (record != null && client.getClientData().getMethodProfilingStatus() != ClientData.MethodProfilingStatus.OFF) {
                return responseBuilder.setStatus(CpuProfiler.CpuProfilingAppStartResponse.Status.FAILURE).setErrorMessage("Start request ignored. The app has an on-going profiling session.").build();
            }
            DdmPreferences.setProfilerBufferSizeMb((int)request.getBufferSizeInMb());
            long nowNs = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
            record = new LegacyProfilingRecord(request, nowNs, responseBuilder);
            this.myLegacyProfilingRecord.put(request.getProcessId(), record);
            try {
                if (request.getMode() == CpuProfiler.CpuProfilingAppStartRequest.Mode.SAMPLED) {
                    client.startSamplingProfiler(request.getSamplingIntervalUs(), TimeUnit.MICROSECONDS);
                } else {
                    client.startMethodTracer();
                }
                record.myStartLatch.await(100L, TimeUnit.MILLISECONDS);
                if (record.myStartFailed) {
                    this.myLegacyProfilingRecord.remove(request.getProcessId());
                } else {
                    responseBuilder.setStatus(CpuProfiler.CpuProfilingAppStartResponse.Status.SUCCESS);
                }
            }
            catch (IOException | InterruptedException e) {
                responseBuilder.setStatus(CpuProfiler.CpuProfilingAppStartResponse.Status.FAILURE);
                responseBuilder.setErrorMessage("Failed: " + e);
                StudioLegacyCpuTraceProfiler.getLogger().error("Exception while CpuServiceProxy startProfilingAppDdms: " + e);
            }
        }
        return responseBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CpuProfiler.CpuProfilingAppStopResponse stopProfilingApp(CpuProfiler.CpuProfilingAppStopRequest request) {
        CpuProfiler.CpuProfilingAppStopResponse.Builder responseBuilder = CpuProfiler.CpuProfilingAppStopResponse.newBuilder();
        String appPkgName = this.myDevice.getClientName(request.getProcessId());
        Client client = appPkgName != null ? this.myDevice.getClient(appPkgName) : null;
        Object object = this.myLegacyProfilingLock;
        synchronized (object) {
            if (client == null) {
                this.myLegacyProfilingRecord.remove(request.getProcessId());
                return responseBuilder.setStatus(CpuProfiler.CpuProfilingAppStopResponse.Status.FAILURE).setErrorMessage("App is not running.").build();
            }
            LegacyProfilingRecord record = this.myLegacyProfilingRecord.get(request.getProcessId());
            if (record == null || client.getClientData().getMethodProfilingStatus() == ClientData.MethodProfilingStatus.OFF) {
                return responseBuilder.setStatus(CpuProfiler.CpuProfilingAppStopResponse.Status.FAILURE).setErrorMessage("The app is not being profiled.").build();
            }
            record.setStopResponseBuilder(responseBuilder);
            try {
                if (record.myStartRequest.getMode() == CpuProfiler.CpuProfilingAppStartRequest.Mode.SAMPLED) {
                    client.stopSamplingProfiler();
                } else {
                    client.stopMethodTracer();
                }
                record.myStopLatch.await();
            }
            catch (IOException | InterruptedException e) {
                responseBuilder.setStatus(CpuProfiler.CpuProfilingAppStopResponse.Status.FAILURE);
                responseBuilder.setErrorMessage("Failed: " + e);
                StudioLegacyCpuTraceProfiler.getLogger().error("Exception while CpuServiceProxy stopProfilingApp: " + e);
            }
            this.myLegacyProfilingRecord.remove(request.getProcessId());
        }
        return responseBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CpuProfiler.ProfilingStateResponse checkAppProfilingState(CpuProfiler.ProfilingStateRequest request) {
        Client client;
        long nowNs = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
        CpuProfiler.ProfilingStateResponse.Builder responseBuilder = CpuProfiler.ProfilingStateResponse.newBuilder();
        String appPkgName = this.myDevice.getClientName(request.getProcessId());
        Client client2 = client = appPkgName != null ? this.myDevice.getClient(appPkgName) : null;
        if (client == null) {
            return responseBuilder.setBeingProfiled(false).build();
        }
        Object object = this.myLegacyProfilingLock;
        synchronized (object) {
            LegacyProfilingRecord record = this.myLegacyProfilingRecord.get(request.getProcessId());
            if (record == null || client.getClientData().getMethodProfilingStatus() == ClientData.MethodProfilingStatus.OFF) {
                return responseBuilder.setBeingProfiled(false).build();
            }
            return responseBuilder.setBeingProfiled(true).setStartRequest(record.myStartRequest).setStartTimestamp(record.myStartRequestTimestamp).setCheckTimestamp(nowNs).build();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/profilers/StudioLegacyCpuTraceProfiler", "<init>"));
    }

    private static class LegacyProfilingRecord {
        @NotNull
        final CpuProfiler.CpuProfilingAppStartRequest myStartRequest;
        long myStartRequestTimestamp;
        @NotNull
        CpuProfiler.CpuProfilingAppStartResponse.Builder myStartResponseBuilder;
        @NotNull
        CountDownLatch myStartLatch;
        @NotNull
        CountDownLatch myStopLatch;
        boolean myStartFailed;
        CpuProfiler.CpuProfilingAppStopResponse.Builder myStopResponseBuilder;

        /*
         * WARNING - void declaration
         */
        public LegacyProfilingRecord(@NotNull CpuProfiler.CpuProfilingAppStartRequest request, long timestamp, @NotNull CpuProfiler.CpuProfilingAppStartResponse.Builder builder) {
            void startResponseBuilder;
            if (request == null) {
                LegacyProfilingRecord.$$$reportNull$$$0(0);
            }
            if (builder == null) {
                LegacyProfilingRecord.$$$reportNull$$$0(1);
            }
            this.myStartLatch = new CountDownLatch(1);
            this.myStopLatch = new CountDownLatch(1);
            this.myStartFailed = false;
            this.myStartRequest = request;
            this.myStartRequestTimestamp = timestamp;
            this.myStartResponseBuilder = startResponseBuilder;
        }

        public void setStopResponseBuilder(@NotNull CpuProfiler.CpuProfilingAppStopResponse.Builder builder) {
            if (builder == null) {
                LegacyProfilingRecord.$$$reportNull$$$0(2);
            }
            this.myStopResponseBuilder = builder;
        }

        public CpuProfiler.CpuProfilingAppStopResponse.Builder getStopResponseBuilder() {
            return this.myStopResponseBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startResponseBuilder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/profilers/StudioLegacyCpuTraceProfiler$LegacyProfilingRecord";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setStopResponseBuilder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LegacyProfilingHandler
    implements ClientData.IMethodProfilingHandler {
        @NotNull
        private final Map<IDevice, Map<Integer, LegacyProfilingRecord>> myProfilingRecords = new HashMap<IDevice, Map<Integer, LegacyProfilingRecord>>();
        private static LegacyProfilingHandler ourInstance;

        private LegacyProfilingHandler() {
        }

        public static synchronized LegacyProfilingHandler getInstance() {
            if (ourInstance == null) {
                ourInstance = new LegacyProfilingHandler();
            }
            return ourInstance;
        }

        public void onSuccess(String remoteFilePath, Client client) {
            LegacyProfilingRecord record = this.myProfilingRecords.get(client.getDevice()).get(client.getClientData().getPid());
            if (record != null) {
                CpuProfiler.CpuProfilingAppStopResponse.Builder stopResponseBuilder = record.getStopResponseBuilder();
                assert (stopResponseBuilder != null);
                stopResponseBuilder.setStatus(CpuProfiler.CpuProfilingAppStopResponse.Status.FAILURE);
                stopResponseBuilder.setErrorMessage("Method profiling: Older devices (API level < 10) are not supported. Please use DDMS.");
                record.myStopLatch.countDown();
            }
        }

        public void onSuccess(byte[] data, Client client) {
            LegacyProfilingRecord record = this.myProfilingRecords.get(client.getDevice()).get(client.getClientData().getPid());
            if (record != null) {
                CpuProfiler.CpuProfilingAppStopResponse.Builder stopResponseBuilder = record.getStopResponseBuilder();
                assert (stopResponseBuilder != null);
                stopResponseBuilder.setStatus(CpuProfiler.CpuProfilingAppStopResponse.Status.SUCCESS);
                stopResponseBuilder.setTrace(ByteString.copyFrom((byte[])data));
                stopResponseBuilder.setTraceId((int)(Math.random() * 2.147483647E9));
                record.myStopLatch.countDown();
            }
        }

        public void onStartFailure(Client client, String message) {
        }

        public void onEndFailure(Client client, String message) {
            LegacyProfilingRecord record = this.myProfilingRecords.get(client.getDevice()).get(client.getClientData().getPid());
            if (record != null) {
                CpuProfiler.CpuProfilingAppStopResponse.Builder stopResponseBuilder = record.getStopResponseBuilder();
                if (stopResponseBuilder != null) {
                    stopResponseBuilder.setStatus(CpuProfiler.CpuProfilingAppStopResponse.Status.FAILURE);
                    stopResponseBuilder.setErrorMessage("Failed to stop profiling: " + message);
                    record.myStopLatch.countDown();
                } else {
                    record.myStartFailed = true;
                    record.myStartResponseBuilder.setStatus(CpuProfiler.CpuProfilingAppStartResponse.Status.FAILURE);
                    record.myStartResponseBuilder.setErrorMessage("Failed to start profiling: " + message);
                    record.myStartLatch.countDown();
                }
            }
        }

        public void addProfilingRecords(@NotNull IDevice device, @NotNull Map<Integer, LegacyProfilingRecord> record) {
            if (device == null) {
                LegacyProfilingHandler.$$$reportNull$$$0(0);
            }
            if (record == null) {
                LegacyProfilingHandler.$$$reportNull$$$0(1);
            }
            this.myProfilingRecords.put(device, record);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "device";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "record";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/profilers/StudioLegacyCpuTraceProfiler$LegacyProfilingHandler";
            objectArray[2] = "addProfilingRecords";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

