/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project.messages;

import com.android.tools.idea.gradle.notification.QuickFixNotificationListener;
import com.android.tools.idea.gradle.util.PositionInFile;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.SyncMessage;
import com.intellij.ide.errorTreeView.NewEditableErrorTreeViewPanel;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.MessageView;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSyncMessages
implements Disposable {
    private static final NotificationSource NOTIFICATION_SOURCE = NotificationSource.PROJECT_SYNC;
    private Project myProject;
    @NotNull
    private final ExternalSystemNotificationManager myNotificationManager;

    protected AbstractSyncMessages(@NotNull Project project, @NotNull ExternalSystemNotificationManager manager) {
        if (project == null) {
            AbstractSyncMessages.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            AbstractSyncMessages.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myNotificationManager = manager;
    }

    public int getErrorCount() {
        return this.getMessageCount(NotificationCategory.ERROR);
    }

    public int getMessageCount(@NotNull String groupName) {
        if (groupName == null) {
            AbstractSyncMessages.$$$reportNull$$$0(2);
        }
        return this.myNotificationManager.getMessageCount(groupName, NOTIFICATION_SOURCE, null, this.getProjectSystemId());
    }

    public boolean isEmpty() {
        return this.getMessageCount((NotificationCategory)null) == 0;
    }

    private int getMessageCount(@Nullable NotificationCategory category) {
        return this.myNotificationManager.getMessageCount(NOTIFICATION_SOURCE, category, this.getProjectSystemId());
    }

    public void removeMessages(String ... groupNames) {
        if (groupNames == null) {
            AbstractSyncMessages.$$$reportNull$$$0(3);
        }
        for (String groupName : groupNames) {
            this.myNotificationManager.clearNotifications(groupName, NOTIFICATION_SOURCE, this.getProjectSystemId());
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
        if (toolWindow != null) {
            MessageView messageView = (MessageView)ServiceManager.getService((Project)this.myProject, MessageView.class);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                NewEditableErrorTreeViewPanel messagesView = this.findMessagesView(messageView);
                if (messagesView != null) {
                    messagesView.updateTree();
                }
            });
        }
    }

    @Nullable
    private NewEditableErrorTreeViewPanel findMessagesView(@NotNull MessageView messageView) {
        if (messageView == null) {
            AbstractSyncMessages.$$$reportNull$$$0(4);
        }
        NewEditableErrorTreeViewPanel messagesView = null;
        for (Content content : messageView.getContentManager().getContents()) {
            JComponent component2;
            String displayName;
            if (content.isPinned() || (displayName = content.getDisplayName()) == null || !displayName.startsWith(this.getProjectSystemId().getReadableName()) || !((component2 = content.getComponent()) instanceof NewEditableErrorTreeViewPanel)) continue;
            messagesView = (NewEditableErrorTreeViewPanel)component2;
            break;
        }
        return messagesView;
    }

    public void report(@NotNull SyncMessage message) {
        if (message == null) {
            AbstractSyncMessages.$$$reportNull$$$0(5);
        }
        String title = message.getGroup();
        String text = StringUtil.join((String[])message.getText(), (String)"\n");
        NotificationCategory category = message.getType().convertToCategory();
        PositionInFile position = message.getPosition();
        NotificationData notification = this.createNotification(title, text, category, position);
        Navigatable navigatable = message.getNavigatable();
        notification.setNavigatable(navigatable);
        List<NotificationHyperlink> quickFixes = message.getQuickFixes();
        if (!quickFixes.isEmpty()) {
            this.updateNotification(notification, text, quickFixes);
        }
        this.report(notification);
    }

    @NotNull
    public NotificationData createNotification(@NotNull String title, @NotNull String text, @NotNull NotificationCategory category, @Nullable PositionInFile position) {
        if (title == null) {
            AbstractSyncMessages.$$$reportNull$$$0(6);
        }
        if (text == null) {
            AbstractSyncMessages.$$$reportNull$$$0(7);
        }
        if (category == null) {
            AbstractSyncMessages.$$$reportNull$$$0(8);
        }
        NotificationSource source = NotificationSource.PROJECT_SYNC;
        if (position != null) {
            String filePath = VfsUtilCore.virtualToIoFile((VirtualFile)position.file).getPath();
            NotificationData notificationData = new NotificationData(title, text, category, source, filePath, position.line, position.column, false);
            if (notificationData == null) {
                AbstractSyncMessages.$$$reportNull$$$0(9);
            }
            return notificationData;
        }
        NotificationData notificationData = new NotificationData(title, text, category, source);
        if (notificationData == null) {
            AbstractSyncMessages.$$$reportNull$$$0(10);
        }
        return notificationData;
    }

    public void updateNotification(@NotNull NotificationData notification, @NotNull String text, @NotNull List<NotificationHyperlink> quickFixes) {
        if (notification == null) {
            AbstractSyncMessages.$$$reportNull$$$0(11);
        }
        if (text == null) {
            AbstractSyncMessages.$$$reportNull$$$0(12);
        }
        if (quickFixes == null) {
            AbstractSyncMessages.$$$reportNull$$$0(13);
        }
        String message = text;
        int hyperlinkCount = quickFixes.size();
        if (hyperlinkCount > 0) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < hyperlinkCount; ++i) {
                b.append(quickFixes.get(i).toHtml());
                if (i >= hyperlinkCount - 1) continue;
                b.append("<br>");
            }
            message = message + '\n' + b.toString();
        }
        notification.setMessage(message);
        this.addNotificationListener(notification, quickFixes);
    }

    public void addNotificationListener(@NotNull NotificationData notification, @NotNull List<NotificationHyperlink> quickFixes) {
        if (notification == null) {
            AbstractSyncMessages.$$$reportNull$$$0(14);
        }
        if (quickFixes == null) {
            AbstractSyncMessages.$$$reportNull$$$0(15);
        }
        for (NotificationHyperlink quickFix : quickFixes) {
            notification.setListener(quickFix.getUrl(), (NotificationListener)new QuickFixNotificationListener(this.myProject, quickFix));
        }
    }

    public void report(@NotNull NotificationData notification) {
        if (notification == null) {
            AbstractSyncMessages.$$$reportNull$$$0(16);
        }
        this.myNotificationManager.showNotification(this.getProjectSystemId(), notification);
    }

    @NotNull
    protected abstract ProjectSystemId getProjectSystemId();

    @NotNull
    protected Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractSyncMessages.$$$reportNull$$$0(17);
        }
        return project;
    }

    public void dispose() {
        this.myProject = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 9: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/project/messages/AbstractSyncMessages";
                break;
            }
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/project/messages/AbstractSyncMessages";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMessageCount";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeMessages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findMessagesView";
                break;
            }
            case 5: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 9: 
            case 10: 
            case 17: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateNotification";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addNotificationListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

