/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.errors.ui;

import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.HtmlBuilder;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Objects;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderErrorModel {
    public static final RenderErrorModel STILL_BUILDING_ERROR_MODEL = new RenderErrorModel((Collection<Issue>)ImmutableList.of((Object)Issue.builder().setSeverity(HighlightSeverity.INFORMATION).setSummary("The project is still building").setHtmlContent(new HtmlBuilder().add("The project is still building and the current preview might be inaccurate.").newline().add("The preview will automatically refresh once the build finishes.")).build()));
    private ImmutableList<Issue> myIssues;

    public RenderErrorModel(@NotNull Collection<Issue> issues) {
        if (issues == null) {
            RenderErrorModel.$$$reportNull$$$0(0);
        }
        this.myIssues = ImmutableList.of();
        this.myIssues = ImmutableList.copyOf(issues);
    }

    @NotNull
    public ImmutableList<Issue> getIssues() {
        ImmutableList<Issue> immutableList = this.myIssues;
        if (immutableList == null) {
            RenderErrorModel.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderErrorModel that = (RenderErrorModel)o;
        return Objects.equals(this.myIssues, that.myIssues);
    }

    public int hashCode() {
        return Objects.hash(this.myIssues);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issues";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/errors/ui/RenderErrorModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/errors/ui/RenderErrorModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Issue
    implements Comparable<Issue> {
        private HighlightSeverity mySeverity = HighlightSeverity.INFORMATION;
        private String mySummary;
        private String myHtmlContent;
        private HyperlinkListener myHyperlinkListener;
        private String myCachedPlainContent;

        private Issue() {
        }

        @NotNull
        public static Builder builder() {
            Builder builder = new Builder();
            if (builder == null) {
                Issue.$$$reportNull$$$0(0);
            }
            return builder;
        }

        @NotNull
        public HighlightSeverity getSeverity() {
            HighlightSeverity highlightSeverity = this.mySeverity;
            if (highlightSeverity == null) {
                Issue.$$$reportNull$$$0(1);
            }
            return highlightSeverity;
        }

        @NotNull
        public String getSummary() {
            String string = StringUtil.notNullize((String)this.mySummary);
            if (string == null) {
                Issue.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getHtmlContent() {
            String string = StringUtil.notNullize((String)this.myHtmlContent);
            if (string == null) {
                Issue.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        private String getPlainContent() {
            if (this.myCachedPlainContent == null) {
                this.myCachedPlainContent = TextFormat.HTML.toText(this.myHtmlContent);
            }
            String string = this.myCachedPlainContent;
            if (string == null) {
                Issue.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        public HyperlinkListener getHyperlinkListener() {
            return this.myHyperlinkListener;
        }

        @Override
        public int compareTo(@NotNull Issue o) {
            if (o == null) {
                Issue.$$$reportNull$$$0(5);
            }
            return ComparisonChain.start().compare((Comparable)o.getSeverity(), (Comparable)this.getSeverity()).compare((Comparable)((Object)this.mySummary), (Comparable)((Object)o.mySummary)).result();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Issue issue2 = (Issue)o;
            return Objects.equals(this.mySeverity, issue2.mySeverity) && Objects.equals(this.mySummary, issue2.mySummary) && Objects.equals(this.getPlainContent(), issue2.getPlainContent());
        }

        public int hashCode() {
            return Objects.hash(this.mySeverity, this.mySummary, this.myHtmlContent);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("severity", (Object)this.mySeverity).add("summary", (Object)this.mySummary).add("htmlContent", (Object)this.myHtmlContent).add("hasHyperlinkListener", this.myHyperlinkListener != null).toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeverity";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSummary";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHtmlContent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPlainContent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static class Builder {
            private final Issue myIssue = new Issue();

            @NotNull
            private Builder setHtmlContent(@NotNull String htmlContent) {
                if (htmlContent == null) {
                    Builder.$$$reportNull$$$0(0);
                }
                this.myIssue.myHtmlContent = htmlContent;
                this.myIssue.myCachedPlainContent = null;
                Builder builder = this;
                if (builder == null) {
                    Builder.$$$reportNull$$$0(1);
                }
                return builder;
            }

            @NotNull
            public Builder setHtmlContent(@NotNull HtmlBuilder htmlBuilder) {
                if (htmlBuilder == null) {
                    Builder.$$$reportNull$$$0(2);
                }
                Builder builder = this.setHtmlContent(htmlBuilder.getStringBuilder().toString());
                if (builder == null) {
                    Builder.$$$reportNull$$$0(3);
                }
                return builder;
            }

            @NotNull
            public Builder setSeverity(@NotNull HighlightSeverity severity) {
                if (severity == null) {
                    Builder.$$$reportNull$$$0(4);
                }
                this.myIssue.mySeverity = severity;
                Builder builder = this;
                if (builder == null) {
                    Builder.$$$reportNull$$$0(5);
                }
                return builder;
            }

            @NotNull
            public Builder setSeverity(@NotNull HighlightSeverity severity, int priority) {
                if (severity == null) {
                    Builder.$$$reportNull$$$0(6);
                }
                this.myIssue.mySeverity = new HighlightSeverity(severity.myName, severity.myVal + priority);
                Builder builder = this;
                if (builder == null) {
                    Builder.$$$reportNull$$$0(7);
                }
                return builder;
            }

            @NotNull
            public Builder setSummary(@NotNull String summary) {
                if (summary == null) {
                    Builder.$$$reportNull$$$0(8);
                }
                this.myIssue.mySummary = summary;
                Builder builder = this;
                if (builder == null) {
                    Builder.$$$reportNull$$$0(9);
                }
                return builder;
            }

            @NotNull
            public Builder setLinkHandler(@NotNull HyperlinkListener listener) {
                if (listener == null) {
                    Builder.$$$reportNull$$$0(10);
                }
                this.myIssue.myHyperlinkListener = listener;
                Builder builder = this;
                if (builder == null) {
                    Builder.$$$reportNull$$$0(11);
                }
                return builder;
            }

            @NotNull
            public Issue build() {
                if (this.myIssue.mySummary == null) {
                    this.myIssue.mySummary = "";
                }
                if (this.myIssue.mySeverity == null) {
                    this.myIssue.mySeverity = HighlightSeverity.INFORMATION;
                }
                if (this.myIssue.myHtmlContent == null) {
                    this.myIssue.myHtmlContent = "";
                }
                Issue issue2 = this.myIssue;
                if (issue2 == null) {
                    Builder.$$$reportNull$$$0(12);
                }
                return issue2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "htmlContent";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue$Builder";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "htmlBuilder";
                        break;
                    }
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "severity";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "summary";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "listener";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue$Builder";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "setHtmlContent";
                        break;
                    }
                    case 5: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "setSeverity";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "setSummary";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "setLinkHandler";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "build";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "setHtmlContent";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    case 4: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "setSeverity";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "setSummary";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "setLinkHandler";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

