/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.webp;

import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.rendering.webp.WebpConversionSettings;
import com.android.tools.idea.rendering.webp.WebpImageWriterSpi;
import com.android.utils.SdkUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class WebpConvertedFile {
    public final VirtualFile sourceFile;
    public final long sourceFileSize;
    public byte[] encoded;
    public long saved;

    public WebpConvertedFile(@NotNull VirtualFile sourceFile, long sourceFileSize) {
        if (sourceFile == null) {
            WebpConvertedFile.$$$reportNull$$$0(0);
        }
        this.sourceFile = sourceFile;
        this.sourceFileSize = sourceFileSize;
    }

    public void apply(@Nullable Object requestor) throws IOException {
        VirtualFile folder = this.sourceFile.getParent();
        VirtualFile output = folder.createChildData(requestor, this.sourceFile.getNameWithoutExtension() + ".webp");
        try (BufferedOutputStream fos = new BufferedOutputStream(output.getOutputStream(requestor));){
            ((OutputStream)fos).write(this.encoded);
        }
        this.sourceFile.delete(requestor);
    }

    public boolean convert(@NotNull WebpConversionSettings settings) {
        if (settings == null) {
            WebpConvertedFile.$$$reportNull$$$0(1);
        }
        try {
            BufferedInputStream stream = new BufferedInputStream(this.sourceFile.getInputStream());
            BufferedImage image = ImageIO.read(stream);
            ((InputStream)stream).close();
            return this.convert(image, settings);
        }
        catch (IOException e) {
            Logger.getInstance(WebpConvertedFile.class).error("Can't convert " + this.sourceFile.getPath(), (Throwable)e);
            return false;
        }
    }

    public boolean convert(@NotNull BufferedImage image, @NotNull WebpConversionSettings settings) {
        if (image == null) {
            WebpConvertedFile.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            WebpConvertedFile.$$$reportNull$$$0(3);
        }
        try {
            String name;
            if (settings.skipTransparentImages && ((name = this.sourceFile.getName()).endsWith(".png") || name.endsWith(".gif")) && ImageUtils.isNonOpaque((BufferedImage)image)) {
                return false;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)this.sourceFileSize);
            ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(image);
            if (!WebpImageWriterSpi.canWriteImage(type)) {
                return false;
            }
            WebpImageWriterSpi.writeImage(image, byteArrayOutputStream, settings.lossless, settings.quality);
            this.encoded = byteArrayOutputStream.toByteArray();
            this.saved = this.sourceFileSize - (long)this.encoded.length;
            return true;
        }
        catch (IOException e) {
            Logger.getInstance(WebpConvertedFile.class).error("Can't convert " + this.sourceFile.getPath(), (Throwable)e);
            return false;
        }
    }

    @Nullable
    public static WebpConvertedFile create(@NotNull VirtualFile pngFile, @NotNull WebpConversionSettings settings) {
        if (pngFile == null) {
            WebpConvertedFile.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            WebpConvertedFile.$$$reportNull$$$0(5);
        }
        try {
            BufferedInputStream stream = new BufferedInputStream(pngFile.getInputStream());
            long size = pngFile.getLength();
            BufferedImage image = ImageIO.read(stream);
            ((InputStream)stream).close();
            if (image == null) {
                Logger.getInstance(WebpConvertedFile.class).warn("Can't read image: " + pngFile.getPath());
                return null;
            }
            String fileName = pngFile.getName();
            if (settings.skipNinePatches && SdkUtils.endsWithIgnoreCase((String)fileName, (String)".9.png")) {
                return null;
            }
            if (settings.skipTransparentImages && (SdkUtils.endsWithIgnoreCase((String)fileName, (String)".png") || SdkUtils.endsWithIgnoreCase((String)fileName, (String)".gif")) && ImageUtils.isNonOpaque((BufferedImage)image)) {
                return null;
            }
            return new WebpConvertedFile(pngFile, size);
        }
        catch (IOException e) {
            Logger.getInstance(WebpConvertedFile.class).error("Can't convert " + pngFile.getPath(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public BufferedImage getSourceImage() throws IOException {
        InputStream pngStream = this.sourceFile.getInputStream();
        return ImageIO.read(pngStream);
    }

    @Nullable
    public BufferedImage getEncodedImage() throws IOException {
        if (this.encoded != null) {
            ByteArrayInputStream webpStream = new ByteArrayInputStream(this.encoded);
            return ImageIO.read(webpStream);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pngFile";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/rendering/webp/WebpConvertedFile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "convert";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

