/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.repository.io.FileOpUtils;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.PropertiesFiles;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SystemInfoStatsMonitor;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.sdk.install.patch.PatchInstallingRestarter;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.wizard.AndroidStudioWelcomeScreenProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkInitializer
implements Runnable {
    private static final Logger LOG = Logger.getInstance(AndroidSdkInitializer.class);
    @NonNls
    private static final String ANDROID_SDK_FOLDER_NAME = "sdk";
    private static final String[] ANDROID_SDK_RELATIVE_PATHS = new String[]{"sdk", File.separator + ".." + File.separator + "sdk"};

    @Override
    public void run() {
        if (!AndroidSdkUtils.isAndroidSdkManagerEnabled()) {
            return;
        }
        if (AndroidPlugin.isGuiTestingMode()) {
            return;
        }
        IdeSdks ideSdks = IdeSdks.getInstance();
        File androidSdkPath = ideSdks.getAndroidSdkPath();
        if (androidSdkPath == null) {
            try {
                AndroidSdkInitializer.setUpSdks();
                androidSdkPath = ideSdks.getAndroidSdkPath();
            }
            catch (Exception e) {
                LOG.error("Unexpected error while setting up SDKs: ", (Throwable)e);
            }
        }
        if (androidSdkPath != null) {
            AndroidSdkHandler handler = AndroidSdkHandler.getInstance((File)androidSdkPath);
            new PatchInstallingRestarter(handler, FileOpUtils.create()).restartAndInstallIfNecessary();
            new SystemInfoStatsMonitor().start();
        }
    }

    private static void setUpSdks() {
        Sdk sdk = AndroidSdkInitializer.findFirstCompatibleAndroidSdk();
        if (sdk != null) {
            String sdkHomePath = sdk.getHomePath();
            assert (sdkHomePath != null);
            IdeSdks.getInstance().createAndroidSdkPerAndroidTarget(FilePaths.toSystemDependentPath(sdkHomePath));
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            File androidSdkPath = AndroidSdkInitializer.findOrGetAndroidSdkPath();
            if (androidSdkPath == null) {
                return;
            }
            FirstRunWizardMode wizardMode = AndroidStudioWelcomeScreenProvider.getWizardMode();
            boolean promptSdkSelection = wizardMode == null;
            Sdk newSdk = AndroidSdkUtils.createNewAndroidPlatform(androidSdkPath.getPath(), promptSdkSelection);
            if (newSdk != null) {
                String sdkNamePrefix = "Android ";
                if (newSdk.getName().startsWith(sdkNamePrefix)) {
                    Sdk jdk;
                    SdkModificator sdkModificator = newSdk.getSdkModificator();
                    sdkModificator.setName(sdkNamePrefix + newSdk.getName().substring(sdkNamePrefix.length()));
                    sdkModificator.commitChanges();
                    AndroidSdkAdditionalData additionalData = AndroidSdks.getInstance().getAndroidSdkAdditionalData(newSdk);
                    if (additionalData != null && (jdk = additionalData.getJavaSdk()) != null) {
                        sdkModificator = jdk.getSdkModificator();
                        sdkModificator.setName("JDK");
                        sdkModificator.commitChanges();
                    }
                    IdeSdks.getInstance().createAndroidSdkPerAndroidTarget(androidSdkPath);
                }
            }
        });
    }

    @Nullable
    private static Sdk findFirstCompatibleAndroidSdk() {
        List<Sdk> sdks = AndroidSdks.getInstance().getAllAndroidSdks();
        for (Sdk sdk : sdks) {
            String sdkPath = sdk.getHomePath();
            if (!VersionCheck.isCompatibleVersion(sdkPath)) continue;
            return sdk;
        }
        return !sdks.isEmpty() ? sdks.get(0) : null;
    }

    @Nullable
    private static File findOrGetAndroidSdkPath() {
        String studioHome = PathManager.getHomePath();
        if (StringUtil.isEmpty((String)studioHome)) {
            LOG.info("Unable to find Studio home directory");
        } else {
            LOG.info(String.format("Found Studio home directory at: '%1$s'", studioHome));
            for (String path : ANDROID_SDK_RELATIVE_PATHS) {
                File dir = new File(studioHome, path);
                String absolutePath = FileUtil.toCanonicalPath((String)dir.getAbsolutePath());
                LOG.info(String.format("Looking for Android SDK at '%1$s'", absolutePath));
                if (!AndroidSdkType.getInstance().isValidSdkHome(absolutePath)) continue;
                LOG.info(String.format("Found Android SDK at '%1$s'", absolutePath));
                return new File(absolutePath);
            }
        }
        LOG.info("Unable to locate SDK within the Android studio installation.");
        String androidHomeValue = System.getenv("ANDROID_HOME");
        String msg = String.format("Checking if ANDROID_HOME is set: '%1$s' is '%2$s'", "ANDROID_HOME", androidHomeValue);
        LOG.info(msg);
        if (!StringUtil.isEmpty((String)androidHomeValue) && AndroidSdkType.getInstance().isValidSdkHome(androidHomeValue)) {
            LOG.info("Using Android SDK specified by the environment variable.");
            return FilePaths.toSystemDependentPath(androidHomeValue);
        }
        String sdkPath = AndroidSdkInitializer.getLastSdkPathUsedByAndroidTools();
        msg = !StringUtil.isEmpty((String)sdkPath) && AndroidSdkType.getInstance().isValidSdkHome(sdkPath) ? String.format("Last SDK used by Android tools: '%1$s'", sdkPath) : "Unable to locate last SDK used by Android tools";
        LOG.info(msg);
        return sdkPath != null ? FilePaths.toSystemDependentPath(sdkPath) : null;
    }

    @Nullable
    private static String getLastSdkPathUsedByAndroidTools() {
        String userHome = SystemProperties.getUserHome();
        if (userHome == null) {
            return null;
        }
        File file = new File(new File(userHome, ".android"), "ddms.cfg");
        if (!file.exists()) {
            return null;
        }
        try {
            Properties properties = PropertiesFiles.getProperties(file);
            return properties.getProperty("lastSdkPath");
        }
        catch (IOException e) {
            return null;
        }
    }
}

