/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.templates.GradleFileMergers;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.base.CharMatcher;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

public class GradleFilePsiMerger {
    public static String mergeGradleFiles(@NotNull String source, @NotNull String dest, @Nullable Project project, final @Nullable String supportLibVersionFilter) {
        Project project2;
        if (source == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(0);
        }
        if (dest == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(1);
        }
        source = source.replace("\r", "");
        dest = dest.replace("\r", "");
        boolean projectNeedsCleanup = false;
        if (project != null && !project.isDefault()) {
            project2 = project;
        } else {
            project2 = ((ProjectManagerImpl)ProjectManager.getInstance()).newProject("MergingOnly", "", false, true);
            assert (project2 != null);
            ((StartupManagerImpl)StartupManager.getInstance((Project)project2)).runStartupActivities();
            projectNeedsCleanup = true;
        }
        final GroovyFile templateBuildFile = (GroovyFile)PsiFileFactory.getInstance((Project)project2).createFileFromText("build.gradle", (FileType)GroovyFileType.GROOVY_FILE_TYPE, (CharSequence)source);
        final GroovyFile existingBuildFile = (GroovyFile)PsiFileFactory.getInstance((Project)project2).createFileFromText("build.gradle", (FileType)GroovyFileType.GROOVY_FILE_TYPE, (CharSequence)dest);
        String result = (String)new WriteCommandAction<String>(project2, "Merge Gradle Files", new PsiFile[]{existingBuildFile}){

            protected void run(@NotNull Result<String> result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                GradleFilePsiMerger.mergePsi((PsiElement)templateBuildFile, (PsiElement)existingBuildFile, project2, supportLibVersionFilter);
                PsiElement formatted = CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)existingBuildFile);
                result.setResult((Object)formatted.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/templates/GradleFilePsiMerger$1", "run"));
            }
        }.execute().getResultObject();
        if (projectNeedsCleanup) {
            ApplicationManager.getApplication().runWriteAction(() -> Disposer.dispose((Disposable)project2));
        }
        return result;
    }

    private static void mergePsi(@NotNull PsiElement fromRoot, @NotNull PsiElement toRoot, @NotNull Project project, @Nullable String supportLibVersionFilter) {
        if (fromRoot == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(2);
        }
        if (toRoot == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(4);
        }
        HashSet<PsiElement> destinationChildren = new HashSet<PsiElement>();
        destinationChildren.addAll(Arrays.asList(toRoot.getChildren()));
        if (toRoot instanceof GrCallExpression && fromRoot instanceof GrCallExpression) {
            PsiElement[] fromArguments = fromRoot.getLastChild().getChildren();
            PsiElement[] toArguments = toRoot.getLastChild().getChildren();
            if (toArguments.length == 1 && fromArguments.length == 1 && toArguments[0] instanceof GrLiteral && fromArguments[0] instanceof GrLiteral) {
                toArguments[0].replace(fromArguments[0]);
                return;
            }
        }
        for (PsiElement child : fromRoot.getChildren()) {
            PsiElement destination = GradleFilePsiMerger.findEquivalentElement(destinationChildren, child);
            if (destination == null) {
                if (destinationChildren.isEmpty()) {
                    toRoot.add(child);
                    continue;
                }
                if (child instanceof GrAssignmentExpression && child.getChildren().length == 2 && child.getChildren()[1] instanceof GrLiteral && child.getText().startsWith("ext.")) {
                    toRoot.addAfter(child, toRoot.getFirstChild());
                    continue;
                }
                toRoot.addBefore(child, toRoot.getLastChild());
                continue;
            }
            if (child.getFirstChild() != null && child.getFirstChild().getText().equalsIgnoreCase("dependencies") && destination.getFirstChild() != null && destination.getFirstChild().getText().equalsIgnoreCase("dependencies")) {
                GradleFilePsiMerger.mergeDependencies(child.getLastChild(), destination.getLastChild(), project, supportLibVersionFilter);
                continue;
            }
            GradleFilePsiMerger.mergePsi(child, destination, project, supportLibVersionFilter);
        }
    }

    private static void mergeDependencies(@NotNull PsiElement fromRoot, @NotNull PsiElement toRoot, @NotNull Project project, @Nullable String supportLibVersionFilter) {
        if (fromRoot == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(5);
        }
        if (toRoot == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(6);
        }
        if (project == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(7);
        }
        TreeMap<String, Multimap<String, GradleCoordinate>> dependencies2 = new TreeMap<String, Multimap<String, GradleCoordinate>>((Comparator<String>)GradleFileMergers.CONFIGURATION_ORDERING);
        ArrayList unparsedDependencies = Lists.newArrayList();
        HashMap originalDependencies = Maps.newHashMap();
        ArrayList originalUnparsedDependencies = Lists.newArrayList();
        GradleFilePsiMerger.pullDependenciesIntoMap(toRoot, originalDependencies, originalUnparsedDependencies);
        GradleFilePsiMerger.pullDependenciesIntoMap(fromRoot, dependencies2, unparsedDependencies);
        GradleFileMergers.removeExistingDependencies(dependencies2, originalDependencies);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        RepositoryUrlManager urlManager = RepositoryUrlManager.get();
        AndroidSdkData sdk = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (sdk != null) {
            dependencies2.forEach((configurationName, unresolvedDependencies) -> {
                if (toRoot == null) {
                    GradleFilePsiMerger.$$$reportNull$$$0(15);
                }
                List<GradleCoordinate> resolved = urlManager.resolveDynamicSdkDependencies((Multimap<String, GradleCoordinate>)unresolvedDependencies, supportLibVersionFilter, sdk, FileOpUtils.create());
                PsiElement nextElement = GradleFilePsiMerger.findInsertionPoint(toRoot, configurationName);
                for (GradleCoordinate dependency : resolved) {
                    GrStatement dependencyElement = factory.createStatementFromText((CharSequence)String.format("%s '%s'\n", configurationName, dependency.toString()));
                    PsiElement newElement = toRoot.addBefore((PsiElement)dependencyElement, nextElement);
                    toRoot.addAfter(factory.createLineTerminator(1), newElement);
                }
            });
        }
        Set originalSet = originalUnparsedDependencies.stream().map(arg_0 -> ((CharMatcher)CharMatcher.WHITESPACE).removeFrom(arg_0)).collect(Collectors.toSet());
        for (String dependency : unparsedDependencies) {
            if (originalSet.contains(CharMatcher.WHITESPACE.removeFrom((CharSequence)dependency))) continue;
            GrStatement dependencyElement = factory.createStatementFromText((CharSequence)dependency);
            toRoot.addBefore((PsiElement)dependencyElement, toRoot.getLastChild());
        }
    }

    @NotNull
    private static PsiElement findInsertionPoint(@NotNull PsiElement root, String configurationName) {
        String currentConfigurationName;
        if (root == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(8);
        }
        GrMethodCall current = (GrMethodCall)PsiTreeUtil.getChildOfType((PsiElement)root, GrMethodCall.class);
        while (current != null && ((currentConfigurationName = GradleFilePsiMerger.getConfigurationName(current)) == null || GradleFileMergers.CONFIGURATION_ORDERING.compare((Object)currentConfigurationName, (Object)configurationName) <= 0)) {
            current = (GrMethodCall)PsiTreeUtil.getNextSiblingOfType((PsiElement)current, GrMethodCall.class);
        }
        Object object = current != null ? current : root.getLastChild();
        if (object == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(9);
        }
        return object;
    }

    @Nullable
    private static String getConfigurationName(@NotNull GrMethodCall element) {
        IElementType elementType;
        PsiElement referenceNameElement;
        GrExpression invokedExpression;
        if (element == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(10);
        }
        if ((invokedExpression = element.getInvokedExpression()) instanceof GrReferenceExpression && (referenceNameElement = ((GrReferenceExpression)invokedExpression).getReferenceNameElement()) instanceof LeafPsiElement && (elementType = ((LeafPsiElement)referenceNameElement).getElementType()) == GroovyTokenTypes.mIDENT) {
            return referenceNameElement.getText();
        }
        return null;
    }

    private static void pullDependenciesIntoMap(@NotNull PsiElement root, @NotNull Map<String, Multimap<String, GradleCoordinate>> allConfigurations, @Nullable List<String> unparsedDependencies) {
        if (root == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(11);
        }
        if (allConfigurations == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(12);
        }
        for (PsiElement existingElem : root.getChildren()) {
            String coordinateText;
            GradleCoordinate coordinate;
            Object value;
            PsiElement reference;
            if (!(existingElem instanceof GrCall) || !((reference = existingElem.getFirstChild()) instanceof GrReferenceExpression)) continue;
            String configurationName = reference.getText();
            boolean parsed = false;
            GrCall call = (GrCall)existingElem;
            GrArgumentList arguments = call.getArgumentList();
            if (arguments == null || call.getClosureArguments().length != 0) continue;
            GrExpression[] expressionArguments = arguments.getExpressionArguments();
            if (expressionArguments.length == 1 && expressionArguments[0] instanceof GrLiteral && (value = ((GrLiteral)expressionArguments[0]).getValue()) instanceof String && (coordinate = GradleCoordinate.parseCoordinateString((String)(coordinateText = (String)value))) != null) {
                parsed = true;
                Multimap map = allConfigurations.computeIfAbsent(configurationName, k -> LinkedListMultimap.create());
                if (!map.get((Object)coordinate.getId()).contains(coordinate)) {
                    map.put((Object)coordinate.getId(), (Object)coordinate);
                }
            }
            if (parsed || unparsedDependencies == null) continue;
            unparsedDependencies.add(existingElem.getText());
        }
    }

    @Nullable
    private static PsiElement findEquivalentElement(@NotNull Collection<PsiElement> collection, @NotNull PsiElement element) {
        if (collection == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(13);
        }
        if (element == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(14);
        }
        ArrayList matchingItems = Lists.newArrayListWithExpectedSize((int)1);
        for (PsiElement item : collection) {
            if (item.getText() != null && item.getText().equals(element.getText())) {
                return item;
            }
            if (item.getFirstChild() == null || element.getFirstChild() == null || !item.getFirstChild().getText().equals(element.getFirstChild().getText())) continue;
            matchingItems.add(item);
        }
        if (matchingItems.size() == 1) {
            return (PsiElement)matchingItems.get(0);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromRoot";
                break;
            }
            case 3: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRoot";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/templates/GradleFilePsiMerger";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allConfigurations";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/templates/GradleFilePsiMerger";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findInsertionPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mergeGradleFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mergePsi";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mergeDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findInsertionPoint";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "pullDependenciesIntoMap";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findEquivalentElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$mergeDependencies$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

