/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.MavenRepositories;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleLocalCache;
import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.templates.GoogleMavenVersionLookup;
import com.android.tools.idea.templates.SupportLibrary;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryUrlManager {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.templates.RepositoryUrlManager");
    private static final String TAG_VERSION = "version";
    public static final String REVISION_ANY = "0.0.+";
    private static final Ordering<GradleCoordinate> GRADLE_COORDINATE_ORDERING = Ordering.from((Comparator)GradleCoordinate.COMPARE_PLUS_LOWER);
    private final boolean myForceRepositoryChecksInTests;

    public static RepositoryUrlManager get() {
        return (RepositoryUrlManager)ServiceManager.getService(RepositoryUrlManager.class);
    }

    RepositoryUrlManager() {
        this(false);
    }

    RepositoryUrlManager(boolean forceRepositoryChecks) {
        this.myForceRepositoryChecksInTests = forceRepositoryChecks;
    }

    @Nullable
    public String getLibraryStringCoordinate(SupportLibrary library, boolean preview) {
        AndroidSdkData sdk = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (sdk == null) {
            return null;
        }
        String revision = this.getLibraryRevision(library.getGroupId(), library.getArtifactId(), null, preview, sdk.getLocation(), FileOpUtils.create());
        if (revision == null) {
            return null;
        }
        return library.getGradleCoordinate(revision).toString();
    }

    @Nullable
    public String getLibraryRevision(@NotNull String groupId, @NotNull String artifactId, @Nullable Predicate<GradleVersion> filter, boolean includePreviews, @NotNull File sdkLocation, @NotNull FileOp fileOp) {
        GradleCoordinate versionInCombined;
        GradleVersion version;
        if (groupId == null) {
            RepositoryUrlManager.$$$reportNull$$$0(0);
        }
        if (artifactId == null) {
            RepositoryUrlManager.$$$reportNull$$$0(1);
        }
        if (sdkLocation == null) {
            RepositoryUrlManager.$$$reportNull$$$0(2);
        }
        if (fileOp == null) {
            RepositoryUrlManager.$$$reportNull$$$0(3);
        }
        if ((version = GoogleMavenVersionLookup.INSTANCE.findVersion(groupId, artifactId, filter, includePreviews)) != null) {
            return version.toString();
        }
        File combinedRepo = FileUtils.join((File)sdkLocation, (String[])new String[]{"extras", "m2repository"});
        if (fileOp.isDirectory(combinedRepo) && (versionInCombined = MavenRepositories.getHighestInstalledVersion((String)groupId, (String)artifactId, (File)combinedRepo, filter, (boolean)includePreviews, (FileOp)fileOp)) != null) {
            return versionInCombined.getRevision();
        }
        SdkMavenRepository repository = SdkMavenRepository.find((File)sdkLocation, (String)groupId, (String)artifactId, (FileOp)fileOp);
        if (repository == null) {
            List<File> paths = EmbeddedDistributionPaths.getInstance().findAndroidStudioLocalMavenRepoPaths();
            for (File path : paths) {
                GradleCoordinate versionInEmbedded;
                if (path == null || !path.isDirectory() || (versionInEmbedded = MavenRepositories.getHighestInstalledVersion((String)groupId, (String)artifactId, (File)path, filter, (boolean)includePreviews, (FileOp)fileOp)) == null) continue;
                return versionInEmbedded.getRevision();
            }
            return null;
        }
        File repositoryLocation = repository.getRepositoryLocation(sdkLocation, true, fileOp);
        if (repositoryLocation == null) {
            return null;
        }
        File mavenMetadataFile = MavenRepositories.getMavenMetadataFile((File)repositoryLocation, (String)groupId, (String)artifactId);
        if (fileOp.isFile(mavenMetadataFile)) {
            try {
                return RepositoryUrlManager.getLatestVersionFromMavenMetadata(mavenMetadataFile, filter, includePreviews, fileOp);
            }
            catch (IOException e) {
                return null;
            }
        }
        GradleCoordinate max = repository.getHighestInstalledVersion(sdkLocation, groupId, artifactId, filter, includePreviews, fileOp);
        if (max == null) {
            return null;
        }
        return max.getRevision();
    }

    @Nullable
    public File getArchiveForCoordinate(@NotNull GradleCoordinate gradleCoordinate, @NotNull File sdkLocation, @NotNull FileOp fileOp) {
        if (gradleCoordinate == null) {
            RepositoryUrlManager.$$$reportNull$$$0(4);
        }
        if (sdkLocation == null) {
            RepositoryUrlManager.$$$reportNull$$$0(5);
        }
        if (fileOp == null) {
            RepositoryUrlManager.$$$reportNull$$$0(6);
        }
        if (gradleCoordinate.getGroupId() == null || gradleCoordinate.getArtifactId() == null) {
            return null;
        }
        SdkMavenRepository repository = SdkMavenRepository.find((File)sdkLocation, (String)gradleCoordinate.getGroupId(), (String)gradleCoordinate.getArtifactId(), (FileOp)fileOp);
        if (repository == null) {
            return null;
        }
        File repositoryLocation = repository.getRepositoryLocation(sdkLocation, true, fileOp);
        if (repositoryLocation == null) {
            return null;
        }
        File artifactDirectory = MavenRepositories.getArtifactDirectory((File)repositoryLocation, (GradleCoordinate)gradleCoordinate);
        if (!fileOp.isDirectory(artifactDirectory)) {
            return null;
        }
        for (GradleCoordinate.ArtifactType artifactType : ImmutableList.of((Object)GradleCoordinate.ArtifactType.JAR, (Object)GradleCoordinate.ArtifactType.AAR)) {
            File archive = new File(artifactDirectory, String.format("%s-%s.%s", gradleCoordinate.getArtifactId(), gradleCoordinate.getRevision(), artifactType.toString()));
            if (!fileOp.isFile(archive)) continue;
            return archive;
        }
        return null;
    }

    @Nullable
    private static String getLatestVersionFromMavenMetadata(final @NotNull File metadataFile, final @Nullable Predicate<GradleVersion> filter, final boolean includePreviews, @NotNull FileOp fileOp) throws IOException {
        if (metadataFile == null) {
            RepositoryUrlManager.$$$reportNull$$$0(7);
        }
        if (fileOp == null) {
            RepositoryUrlManager.$$$reportNull$$$0(8);
        }
        String xml = fileOp.toString(metadataFile, StandardCharsets.UTF_8);
        final ArrayList versions = new ArrayList();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(IOUtils.toInputStream((String)xml), new DefaultHandler(){
                boolean inVersionTag = false;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equals(RepositoryUrlManager.TAG_VERSION)) {
                        this.inVersionTag = true;
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.inVersionTag) {
                        this.inVersionTag = false;
                        String revision = new String(ch, start, length);
                        if ((includePreviews || !"5.2.08".equals(revision) || !metadataFile.getPath().contains(SupportLibrary.PLAY_SERVICES.getArtifactId())) && RepositoryUrlManager.applyVersionPredicate(revision, filter)) {
                            versions.add(GradleCoordinate.parseVersionOnly((String)revision));
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        if (versions.isEmpty()) {
            return REVISION_ANY;
        }
        if (includePreviews) {
            return ((GradleCoordinate)GRADLE_COORDINATE_ORDERING.max(versions)).getRevision();
        }
        return versions.stream().filter(v -> !v.isPreview()).max((Comparator<GradleCoordinate>)GRADLE_COORDINATE_ORDERING).map(GradleCoordinate::getRevision).orElse(null);
    }

    private static boolean applyVersionPredicate(@NotNull String revision, @Nullable Predicate<GradleVersion> predicate) {
        if (revision == null) {
            RepositoryUrlManager.$$$reportNull$$$0(9);
        }
        if (predicate == null) {
            return true;
        }
        GradleVersion version = GradleVersion.tryParse((String)revision);
        return version != null && predicate.test(version);
    }

    @Nullable
    public GradleCoordinate resolveDynamicCoordinate(@NotNull GradleCoordinate coordinate, @Nullable Project project) {
        if (coordinate == null) {
            RepositoryUrlManager.$$$reportNull$$$0(10);
        }
        return this.resolveDynamicCoordinate(coordinate, project, AndroidSdks.getInstance().tryToChooseSdkHandler());
    }

    @Nullable
    public GradleCoordinate resolveDynamicCoordinate(@NotNull GradleCoordinate coordinate, @Nullable Project project, @NotNull AndroidSdkHandler sdkHandler) {
        List revisions;
        String version;
        if (coordinate == null) {
            RepositoryUrlManager.$$$reportNull$$$0(11);
        }
        if (sdkHandler == null) {
            RepositoryUrlManager.$$$reportNull$$$0(12);
        }
        if ((version = this.resolveDynamicCoordinateVersion(coordinate, project, sdkHandler)) != null && coordinate.getGroupId() != null && coordinate.getArtifactId() != null && !(revisions = GradleCoordinate.parseRevisionNumber((String)version)).isEmpty()) {
            return new GradleCoordinate(coordinate.getGroupId(), coordinate.getArtifactId(), revisions, coordinate.getArtifactType());
        }
        return null;
    }

    @Nullable
    public String resolveDynamicCoordinateVersion(@NotNull GradleCoordinate coordinate, @Nullable Project project) {
        if (coordinate == null) {
            RepositoryUrlManager.$$$reportNull$$$0(13);
        }
        return this.resolveDynamicCoordinateVersion(coordinate, project, AndroidSdks.getInstance().tryToChooseSdkHandler());
    }

    @Nullable
    String resolveDynamicCoordinateVersion(@NotNull GradleCoordinate coordinate, @Nullable Project project, @NotNull AndroidSdkHandler sdkHandler) {
        String latestString;
        LintIdeClient client;
        GradleVersion latest;
        GradleCoordinate found;
        GradleVersion versionFound;
        if (coordinate == null) {
            RepositoryUrlManager.$$$reportNull$$$0(14);
        }
        if (sdkHandler == null) {
            RepositoryUrlManager.$$$reportNull$$$0(15);
        }
        String groupId = coordinate.getGroupId();
        String artifactId = coordinate.getArtifactId();
        if (groupId == null || artifactId == null) {
            return null;
        }
        String revision = coordinate.getRevision();
        if (!revision.endsWith("+")) {
            return revision;
        }
        String versionPrefix = revision.substring(0, revision.length() - 1);
        Predicate<GradleVersion> filter = version -> version.toString().startsWith(versionPrefix);
        GradleVersion stable = GoogleMavenVersionLookup.INSTANCE.findVersion(groupId, artifactId, filter, false);
        if (stable != null) {
            return stable.toString();
        }
        GradleVersion version2 = GoogleMavenVersionLookup.INSTANCE.findVersion(groupId, artifactId, filter, true);
        if (version2 != null) {
            return version2.toString();
        }
        File sdkLocation = sdkHandler.getLocation();
        if (sdkLocation != null) {
            String libraryCoordinate = this.getLibraryRevision(groupId, artifactId, filter, false, sdkLocation, sdkHandler.getFileOp());
            if (libraryCoordinate != null) {
                return libraryCoordinate;
            }
            libraryCoordinate = this.getLibraryRevision(groupId, artifactId, filter, true, sdkLocation, sdkHandler.getFileOp());
            if (libraryCoordinate != null) {
                return libraryCoordinate;
            }
        }
        if ((versionFound = GradleLocalCache.getInstance().findLatestArtifactVersion(coordinate, project, revision)) != null) {
            return versionFound.toString();
        }
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        RemotePackage sdkPackage = SdkMavenRepository.findLatestRemoteVersion((GradleCoordinate)coordinate, (AndroidSdkHandler)sdkHandler, filter, (ProgressIndicator)progress);
        if (sdkPackage != null && (found = SdkMavenRepository.getCoordinateFromSdkPath((String)sdkPackage.getPath())) != null) {
            return found.getRevision();
        }
        if (project != null && (latest = GradleDetector.getLatestVersionFromRemoteRepo((LintClient)(client = new LintIdeClient(project)), (GradleCoordinate)coordinate, filter, (boolean)coordinate.isPreview())) != null && (latestString = latest.toString()).startsWith(revision)) {
            return latestString;
        }
        return null;
    }

    public List<GradleCoordinate> resolveDynamicSdkDependencies(@NotNull Multimap<String, GradleCoordinate> dependencies2, @Nullable String supportLibVersionFilter, @NotNull AndroidSdkData sdk, @NotNull FileOp fileOp) {
        if (dependencies2 == null) {
            RepositoryUrlManager.$$$reportNull$$$0(16);
        }
        if (sdk == null) {
            RepositoryUrlManager.$$$reportNull$$$0(17);
        }
        if (fileOp == null) {
            RepositoryUrlManager.$$$reportNull$$$0(18);
        }
        ArrayList<GradleCoordinate> result = new ArrayList<GradleCoordinate>(dependencies2.size());
        String supportFilter = RepositoryUrlManager.findExistingExplicitVersion(dependencies2.values());
        if (supportFilter == null) {
            supportFilter = supportLibVersionFilter;
        }
        for (String key : dependencies2.keySet()) {
            String revision;
            GradleCoordinate highest = (GradleCoordinate)Collections.max(dependencies2.get((Object)key), GradleCoordinate.COMPARE_PLUS_LOWER);
            if (highest.getGroupId() == null || highest.getArtifactId() == null) {
                return null;
            }
            if ((this.myForceRepositoryChecksInTests || !ApplicationManager.getApplication().isUnitTestMode()) && (revision = highest.getRevision()).endsWith("+")) {
                String libraryCoordinate;
                GradleCoordinate available;
                String prefix;
                revision = revision.length() > 1 ? revision.substring(0, revision.length() - 1) : null;
                boolean includePreviews = false;
                if ("com.android.support".equals(highest.getGroupId())) {
                    if (revision == null) {
                        revision = supportFilter;
                    }
                    includePreviews = true;
                }
                Predicate<GradleVersion> filter = (prefix = revision) != null ? version -> version.toString().startsWith(prefix) : null;
                String version2 = this.getLibraryRevision(highest.getGroupId(), highest.getArtifactId(), filter, includePreviews, sdk.getLocation(), fileOp);
                if (version2 == null && filter != null) {
                    version2 = this.getLibraryRevision(highest.getGroupId(), highest.getArtifactId(), null, includePreviews, sdk.getLocation(), fileOp);
                }
                if (version2 == null && !includePreviews) {
                    version2 = this.getLibraryRevision(highest.getGroupId(), highest.getArtifactId(), null, true, sdk.getLocation(), fileOp);
                }
                if (version2 != null && (available = GradleCoordinate.parseCoordinateString((String)(libraryCoordinate = highest.getId() + ":" + version2))) != null && GradleCoordinate.COMPARE_PLUS_LOWER.compare(available, highest) >= 0) {
                    highest = available;
                }
            }
            result.add(highest);
        }
        return result;
    }

    @Nullable
    private static String findExistingExplicitVersion(@NotNull Collection<GradleCoordinate> dependencies2) {
        Optional<GradleCoordinate> highest;
        if (dependencies2 == null) {
            RepositoryUrlManager.$$$reportNull$$$0(19);
        }
        if (!(highest = dependencies2.stream().filter(coordinate -> "com.android.support".equals(coordinate.getGroupId())).max(GradleCoordinate.COMPARE_PLUS_LOWER)).isPresent()) {
            return null;
        }
        String version = highest.get().getRevision();
        if (version.endsWith("+")) {
            return version.length() > 1 ? version.substring(0, version.length() - 1) : null;
        }
        return version;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkLocation";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOp";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleCoordinate";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadataFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinate";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHandler";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/templates/RepositoryUrlManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLibraryRevision";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getArchiveForCoordinate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getLatestVersionFromMavenMetadata";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "applyVersionPredicate";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveDynamicCoordinate";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveDynamicCoordinateVersion";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveDynamicSdkDependencies";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingExplicitVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

