/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.builder.model.JavaArtifact;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeJavaArtifact;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.testartifacts.scopes.FileRootSearchScope;
import com.android.tools.idea.testartifacts.scopes.TestArtifactSearchScopes;
import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathsList;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;

public class AndroidJunitPatcher
extends JUnitPatcher {
    public void patchJavaParameters(@Nullable Module module, @NotNull JavaParameters javaParameters) {
        if (javaParameters == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(0);
        }
        if (module == null || !GradleProjectInfo.getInstance(module.getProject()).isBuildWithGradle()) {
            return;
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        if (androidModel == null) {
            AndroidJunitPatcher.addFoldersToClasspath(module, null, javaParameters.getClassPath());
            return;
        }
        IdeJavaArtifact testArtifact = androidModel.getSelectedVariant().getUnitTestArtifact();
        if (testArtifact == null) {
            return;
        }
        PathsList classPath = javaParameters.getClassPath();
        TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.get(module);
        if (testScopes == null) {
            return;
        }
        FileRootSearchScope excludeScope = testScopes.getUnitTestExcludeScope();
        for (String path : classPath.getPathList()) {
            if (!excludeScope.accept(new File(path))) continue;
            classPath.remove(path);
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null) {
            return;
        }
        String originalClassPath = classPath.getPathsString();
        try {
            AndroidJunitPatcher.replaceAndroidJarWithMockableJar(classPath, platform, testArtifact);
            AndroidJunitPatcher.addFoldersToClasspath(module, testArtifact, classPath);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(String.format("Error patching the JUnit class path. Original class path:%n%s", originalClassPath), e);
        }
    }

    private static void replaceAndroidJarWithMockableJar(@NotNull PathsList classPath, @NotNull AndroidPlatform platform, @NotNull JavaArtifact artifact) {
        if (classPath == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(1);
        }
        if (platform == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(2);
        }
        if (artifact == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(3);
        }
        String androidJarPath = platform.getTarget().getPath(1);
        for (Object entry : classPath.getPathList()) {
            if (!FileUtil.pathsEqual((String)androidJarPath, (String)entry)) continue;
            classPath.remove((String)entry);
        }
        ArrayList<String> mockableJars = new ArrayList<String>();
        for (String path : classPath.getPathList()) {
            if (!FilePaths.toSystemDependentPath(path).getName().startsWith("mockable-")) continue;
            mockableJars.add(path);
        }
        for (String mockableJar : mockableJars) {
            classPath.remove(mockableJar);
        }
        File mockableJar = artifact.getMockablePlatformJar();
        if (mockableJar != null) {
            classPath.addTail(mockableJar.getPath());
        } else {
            for (String mockableJarPath : mockableJars) {
                if (!mockableJarPath.endsWith("-" + platform.getApiLevel() + ".jar")) continue;
                classPath.addTail(mockableJarPath);
                return;
            }
        }
    }

    private static void addFoldersToClasspath(@NotNull Module module, @Nullable JavaArtifact testArtifact, @NotNull PathsList classPath) {
        if (module == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(4);
        }
        if (classPath == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(5);
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)module.getProject());
        CompileScope scope = compilerManager.createModulesCompileScope(new Module[]{module}, true, true);
        if (testArtifact != null) {
            classPath.add(testArtifact.getJavaResourcesFolder());
            for (File additionalTestClasses : testArtifact.getAdditionalClassesFolders()) {
                classPath.add(additionalTestClasses);
            }
        }
        FileRootSearchScope excludeScope = null;
        TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.get(module);
        if (testScopes != null) {
            excludeScope = testScopes.getUnitTestExcludeScope();
        }
        for (Module affectedModule : scope.getAffectedModules()) {
            File kotlinClasses;
            File javaMainResources;
            File javaTestResources;
            JavaModuleModel javaModel;
            JavaFacet javaFacet;
            AndroidModuleModel affectedAndroidModel = AndroidModuleModel.get(affectedModule);
            if (affectedAndroidModel != null) {
                IdeAndroidArtifact mainArtifact = affectedAndroidModel.getMainArtifact();
                AndroidJunitPatcher.addToClasspath(mainArtifact.getJavaResourcesFolder(), classPath, excludeScope);
                for (File additionalClassesFolder : mainArtifact.getAdditionalClassesFolders()) {
                    AndroidJunitPatcher.addToClasspath(additionalClassesFolder, classPath, excludeScope);
                }
            }
            if ((javaFacet = JavaFacet.getInstance(affectedModule)) == null || (javaModel = javaFacet.getJavaModuleModel()) == null) continue;
            ExtIdeaCompilerOutput output = javaModel.getCompilerOutput();
            File file = javaTestResources = output == null ? null : output.getTestResourcesDir();
            if (javaTestResources != null) {
                AndroidJunitPatcher.addToClasspath(javaTestResources, classPath, excludeScope);
            }
            File file2 = javaMainResources = output == null ? null : output.getMainResourcesDir();
            if (javaMainResources != null) {
                AndroidJunitPatcher.addToClasspath(javaMainResources, classPath, excludeScope);
            }
            if (javaModel.getBuildFolderPath() == null || !(kotlinClasses = javaModel.getBuildFolderPath().toPath().resolve("classes").resolve("kotlin").toFile()).exists()) continue;
            AndroidJunitPatcher.addToClasspath(new File(kotlinClasses, "main"), classPath, excludeScope);
            AndroidJunitPatcher.addToClasspath(new File(kotlinClasses, "test"), classPath, excludeScope);
        }
    }

    private static void addToClasspath(@NotNull File folder, @NotNull PathsList classPath, @Nullable FileRootSearchScope excludeScope) {
        if (folder == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(6);
        }
        if (classPath == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(7);
        }
        if (excludeScope != null && excludeScope.accept(folder)) {
            return;
        }
        classPath.add(folder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParameters";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/testartifacts/scopes/AndroidJunitPatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "patchJavaParameters";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceAndroidJarWithMockableJar";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addFoldersToClasspath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addToClasspath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

