/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.tools.idea.uibuilder.util.JavaDocViewer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentHelpAction
extends AnAction {
    private final Project myProject;
    private final Supplier<String> myTagNameSupplier;

    public ComponentHelpAction(@NotNull Project project, @NotNull Supplier<String> tagNameSupplier) {
        if (project == null) {
            ComponentHelpAction.$$$reportNull$$$0(0);
        }
        if (tagNameSupplier == null) {
            ComponentHelpAction.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myTagNameSupplier = tagNameSupplier;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        String tagName;
        if (event == null) {
            ComponentHelpAction.$$$reportNull$$$0(2);
        }
        if ((tagName = this.myTagNameSupplier.get()) == null) {
            return;
        }
        PsiClass psiClass = this.findClassOfTagName(tagName);
        if (psiClass == null) {
            return;
        }
        JavaDocViewer.getInstance().showExternalJavaDoc(psiClass, event.getDataContext());
    }

    @Nullable
    private PsiClass findClassOfTagName(@NotNull String tagName) {
        if (tagName == null) {
            ComponentHelpAction.$$$reportNull$$$0(3);
        }
        if (tagName.indexOf(46) != -1) {
            return this.findClassByClassName(tagName);
        }
        PsiClass psiClass = this.findClassByClassName("android.widget." + tagName);
        if (psiClass != null) {
            return psiClass;
        }
        psiClass = this.findClassByClassName("android.view." + tagName);
        if (psiClass != null) {
            return psiClass;
        }
        return this.findClassByClassName("android.webkit." + tagName);
    }

    @Nullable
    private PsiClass findClassByClassName(@NotNull String fullyQualifiedClassName) {
        if (fullyQualifiedClassName == null) {
            ComponentHelpAction.$$$reportNull$$$0(4);
        }
        JavaPsiFacade javaFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        return javaFacade.findClass(fullyQualifiedClassName, GlobalSearchScope.allScope((Project)this.myProject));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagNameSupplier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullyQualifiedClassName";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/actions/ComponentHelpAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findClassOfTagName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findClassByClassName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

