/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.graphics;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import org.jetbrains.annotations.NotNull;

public class NlGraphics {
    private final SceneView myScene;
    private final Graphics2D myGraphics;
    @NotNull
    private NlDrawingStyle myStyle;
    private static final int MIN_LENGTH = 10;
    private static final int ARROW_SIZE = 5;

    public NlGraphics(@NotNull Graphics2D graphics, @NotNull SceneView scene) {
        if (graphics == null) {
            NlGraphics.$$$reportNull$$$0(0);
        }
        if (scene == null) {
            NlGraphics.$$$reportNull$$$0(1);
        }
        this.myStyle = NlDrawingStyle.INVALID;
        this.myGraphics = graphics;
        this.myScene = scene;
    }

    public void useStyle(@NotNull NlDrawingStyle style) {
        if (style == null) {
            NlGraphics.$$$reportNull$$$0(2);
        }
        this.myStyle = style;
    }

    public void fillRect(int x, int y, int width, int height) {
        Color fillColor = this.myStyle.getFillColor();
        if (fillColor != null) {
            NlGraphics.useFill(this.myStyle, this.myGraphics);
            x = Coordinates.getSwingX(this.myScene, x);
            y = Coordinates.getSwingY(this.myScene, y);
            width = Coordinates.getSwingDimension(this.myScene, width);
            height = Coordinates.getSwingDimension(this.myScene, height);
            NlGraphics.fillRect(this.myStyle, this.myGraphics, x, y, width, height);
        }
    }

    public void drawTop(@NotNull NlComponent component2) {
        if (component2 == null) {
            NlGraphics.$$$reportNull$$$0(3);
        }
        this.drawLine(NlComponentHelperKt.getX(component2), NlComponentHelperKt.getY(component2), NlComponentHelperKt.getX(component2) + NlComponentHelperKt.getW(component2), NlComponentHelperKt.getY(component2));
    }

    public void drawTop(@NotNull Rectangle rectangle) {
        if (rectangle == null) {
            NlGraphics.$$$reportNull$$$0(4);
        }
        this.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
    }

    public void drawTopDp(@NotNull Rectangle rectangle) {
        if (rectangle == null) {
            NlGraphics.$$$reportNull$$$0(5);
        }
        this.drawLine(Coordinates.dpToPx(this.myScene, rectangle.x), Coordinates.dpToPx(this.myScene, rectangle.y), Coordinates.dpToPx(this.myScene, rectangle.x + rectangle.width), Coordinates.dpToPx(this.myScene, rectangle.y));
    }

    public void drawLeft(@NotNull NlComponent component2) {
        if (component2 == null) {
            NlGraphics.$$$reportNull$$$0(6);
        }
        this.drawLine(NlComponentHelperKt.getX(component2), NlComponentHelperKt.getY(component2), NlComponentHelperKt.getX(component2), NlComponentHelperKt.getY(component2) + NlComponentHelperKt.getH(component2));
    }

    public void drawLeft(@NotNull Rectangle rectangle) {
        if (rectangle == null) {
            NlGraphics.$$$reportNull$$$0(7);
        }
        this.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
    }

    public void drawLeftDp(@NotNull Rectangle rectangle) {
        if (rectangle == null) {
            NlGraphics.$$$reportNull$$$0(8);
        }
        this.drawLine(Coordinates.dpToPx(this.myScene, rectangle.x), Coordinates.dpToPx(this.myScene, rectangle.y), Coordinates.dpToPx(this.myScene, rectangle.x), Coordinates.dpToPx(this.myScene, rectangle.y + rectangle.height));
    }

    public void drawRight(@NotNull NlComponent component2) {
        if (component2 == null) {
            NlGraphics.$$$reportNull$$$0(9);
        }
        this.drawLine(NlComponentHelperKt.getX(component2) + NlComponentHelperKt.getW(component2), NlComponentHelperKt.getY(component2), NlComponentHelperKt.getX(component2) + NlComponentHelperKt.getW(component2), NlComponentHelperKt.getY(component2) + NlComponentHelperKt.getH(component2));
    }

    public void drawRight(@NotNull Rectangle rectangle) {
        if (rectangle == null) {
            NlGraphics.$$$reportNull$$$0(10);
        }
        this.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public void drawRightDp(@NotNull Rectangle rectangle) {
        if (rectangle == null) {
            NlGraphics.$$$reportNull$$$0(11);
        }
        this.drawLine(Coordinates.dpToPx(this.myScene, rectangle.x + rectangle.width), Coordinates.dpToPx(this.myScene, rectangle.y), Coordinates.dpToPx(this.myScene, rectangle.x + rectangle.width), Coordinates.dpToPx(this.myScene, rectangle.y + rectangle.height));
    }

    public void drawBottom(@NotNull NlComponent component2) {
        if (component2 == null) {
            NlGraphics.$$$reportNull$$$0(12);
        }
        this.drawLine(NlComponentHelperKt.getX(component2), NlComponentHelperKt.getY(component2) + NlComponentHelperKt.getH(component2), NlComponentHelperKt.getX(component2) + NlComponentHelperKt.getW(component2), NlComponentHelperKt.getY(component2) + NlComponentHelperKt.getH(component2));
    }

    public void drawBottom(@NotNull Rectangle rectangle) {
        if (rectangle == null) {
            NlGraphics.$$$reportNull$$$0(13);
        }
        this.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public void drawBottomDp(@NotNull Rectangle rectangle) {
        if (rectangle == null) {
            NlGraphics.$$$reportNull$$$0(14);
        }
        this.drawLine(Coordinates.dpToPx(this.myScene, rectangle.x), Coordinates.dpToPx(this.myScene, rectangle.y + rectangle.height), Coordinates.dpToPx(this.myScene, rectangle.x + rectangle.width), Coordinates.dpToPx(this.myScene, rectangle.y + rectangle.height));
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        x1 = Coordinates.getSwingX(this.myScene, x1);
        x2 = Coordinates.getSwingX(this.myScene, x2);
        y1 = Coordinates.getSwingY(this.myScene, y1);
        y2 = Coordinates.getSwingY(this.myScene, y2);
        NlGraphics.drawLine(this.myStyle, this.myGraphics, x1, y1, x2, y2);
    }

    public void drawLineDp(int x1, int y1, int x2, int y2) {
        x1 = Coordinates.getSwingXDip(this.myScene, x1);
        x2 = Coordinates.getSwingXDip(this.myScene, x2);
        y1 = Coordinates.getSwingYDip(this.myScene, y1);
        y2 = Coordinates.getSwingYDip(this.myScene, y2);
        NlGraphics.drawLine(this.myStyle, this.myGraphics, x1, y1, x2, y2);
    }

    public void drawRect(int x, int y, int width, int height) {
        x = Coordinates.getSwingX(this.myScene, x);
        y = Coordinates.getSwingY(this.myScene, y);
        width = Coordinates.getSwingDimension(this.myScene, width);
        height = Coordinates.getSwingDimension(this.myScene, height);
        NlGraphics.drawRect(this.myStyle, this.myGraphics, x, y, width, height);
    }

    public void drawRectDp(int x, int y, int width, int height) {
        x = Coordinates.getSwingXDip(this.myScene, x);
        y = Coordinates.getSwingYDip(this.myScene, y);
        width = Coordinates.getSwingDimensionDip(this.myScene, width);
        height = Coordinates.getSwingDimensionDip(this.myScene, height);
        NlGraphics.drawRect(this.myStyle, this.myGraphics, x, y, width, height);
    }

    public void drawArrow(int x1, int y1, int x2, int y2) {
        x1 = Coordinates.getSwingX(this.myScene, x1);
        x2 = Coordinates.getSwingX(this.myScene, x2);
        y1 = Coordinates.getSwingY(this.myScene, y1);
        y2 = Coordinates.getSwingY(this.myScene, y2);
        NlGraphics.drawArrow(this.myStyle, this.myGraphics, x1, y1, x2, y2);
    }

    public void drawCross(int radius) {
        radius = Coordinates.getSwingDimension(this.myScene, radius);
        NlGraphics.drawCross(this.myStyle, this.myGraphics, radius);
    }

    public static void fillRect(@NotNull NlDrawingStyle style, @NotNull Graphics gc, int x, int y, int width, int height) {
        Color fillColor;
        if (style == null) {
            NlGraphics.$$$reportNull$$$0(15);
        }
        if (gc == null) {
            NlGraphics.$$$reportNull$$$0(16);
        }
        if ((fillColor = style.getFillColor()) != null) {
            NlGraphics.useFill(style, gc);
            gc.fillRect(x + 1, y + 1, width - 1, height - 1);
        }
    }

    public static void drawFilledRect(@NotNull NlDrawingStyle style, @NotNull Graphics gc, int x, int y, int width, int height) {
        Color fillColor;
        if (style == null) {
            NlGraphics.$$$reportNull$$$0(17);
        }
        if (gc == null) {
            NlGraphics.$$$reportNull$$$0(18);
        }
        if ((fillColor = style.getFillColor()) != null) {
            NlGraphics.useFill(style, gc);
            gc.setColor(fillColor);
            gc.fillRect(x + 1, y + 1, width - 2, height - 2);
        }
        NlGraphics.useStroke(style, gc);
        if (style.getStrokeColor() != null) {
            gc.drawRect(x, y, width - 1, height - 1);
        }
    }

    public static void drawStrokeFilledRect(@NotNull NlDrawingStyle style, @NotNull Graphics gc, int x, int y, int width, int height) {
        if (style == null) {
            NlGraphics.$$$reportNull$$$0(19);
        }
        if (gc == null) {
            NlGraphics.$$$reportNull$$$0(20);
        }
        NlGraphics.useStroke(style, gc);
        if (style.getStrokeColor() != null) {
            gc.fillRect(x, y, width, height);
        }
    }

    public static void drawRect(@NotNull NlDrawingStyle style, @NotNull Graphics gc, int x, int y, int width, int height) {
        if (style == null) {
            NlGraphics.$$$reportNull$$$0(21);
        }
        if (gc == null) {
            NlGraphics.$$$reportNull$$$0(22);
        }
        NlGraphics.useStroke(style, gc);
        gc.drawRect(x, y, width - 1, height - 1);
    }

    public static void drawLine(@NotNull NlDrawingStyle style, @NotNull Graphics gc, int x1, int y1, int x2, int y2) {
        if (style == null) {
            NlGraphics.$$$reportNull$$$0(23);
        }
        if (gc == null) {
            NlGraphics.$$$reportNull$$$0(24);
        }
        NlGraphics.useStroke(style, gc);
        gc.drawLine(x1, y1, x2, y2);
    }

    public static void drawArrow(@NotNull NlDrawingStyle style, @NotNull Graphics graphics, int x1, int y1, int x2, int y2) {
        int delta;
        Color strokeColor;
        if (style == null) {
            NlGraphics.$$$reportNull$$$0(25);
        }
        if (graphics == null) {
            NlGraphics.$$$reportNull$$$0(26);
        }
        if ((strokeColor = style.getStrokeColor()) != graphics.getColor()) {
            graphics.setColor(strokeColor);
        }
        if (graphics instanceof Graphics2D) {
            Graphics2D gc2 = (Graphics2D)graphics;
            Stroke stroke = style.getStroke();
            if (gc2.getStroke() != stroke) {
                gc2.setStroke(stroke);
            }
        }
        int arrowWidth = 5;
        int arrowHeight = 5;
        if (x1 == x2 && Math.abs(y1 - y2) < 10) {
            delta = (10 - Math.abs(y1 - y2)) / 2;
            if (y1 < y2) {
                y1 -= delta;
                y2 += delta;
            } else {
                y1 += delta;
                y2 -= delta;
            }
        } else if (y1 == y2 && Math.abs(x1 - x2) < 10) {
            delta = (10 - Math.abs(x1 - x2)) / 2;
            if (x1 < x2) {
                x1 -= delta;
                x2 += delta;
            } else {
                x1 += delta;
                x2 -= delta;
            }
        }
        graphics.drawLine(x1, y1, x2, y2);
        if (x1 == x2) {
            if (y2 > y1) {
                graphics.drawLine(x2 - arrowWidth, y2 - arrowHeight, x2, y2);
                graphics.drawLine(x2 + arrowWidth, y2 - arrowHeight, x2, y2);
            } else {
                graphics.drawLine(x2 - arrowWidth, y2 + arrowHeight, x2, y2);
                graphics.drawLine(x2 + arrowWidth, y2 + arrowHeight, x2, y2);
            }
        } else if (y1 == y2) {
            if (x2 > x1) {
                graphics.drawLine(x2 - arrowHeight, y2 - arrowWidth, x2, y2);
                graphics.drawLine(x2 - arrowHeight, y2 + arrowWidth, x2, y2);
            } else {
                graphics.drawLine(x2 + arrowHeight, y2 - arrowWidth, x2, y2);
                graphics.drawLine(x2 + arrowHeight, y2 + arrowWidth, x2, y2);
            }
        } else {
            int dy = y2 - y1;
            int dx = x2 - x1;
            double angle = Math.atan2(dy, dx);
            double lineLength = Math.sqrt(dy * dy + dx * dx);
            double ax = (double)x1 + lineLength - (double)arrowHeight;
            double ay = y1 - arrowWidth;
            int rx = (int)(Math.cos(angle) * (ax - (double)x1) - Math.sin(angle) * (ay - (double)y1) + (double)x1);
            int ry = (int)(Math.sin(angle) * (ax - (double)x1) + Math.cos(angle) * (ay - (double)y1) + (double)y1);
            graphics.drawLine(x2, y2, rx, ry);
            ay = y1 + arrowWidth;
            rx = (int)(Math.cos(angle) * (ax - (double)x1) - Math.sin(angle) * (ay - (double)y1) + (double)x1);
            ry = (int)(Math.sin(angle) * (ax - (double)x1) + Math.cos(angle) * (ay - (double)y1) + (double)y1);
            graphics.drawLine(x2, y2, rx, ry);
        }
    }

    public static void drawCross(@NotNull NlDrawingStyle style, @NotNull Graphics g, int radius) {
        if (style == null) {
            NlGraphics.$$$reportNull$$$0(27);
        }
        if (g == null) {
            NlGraphics.$$$reportNull$$$0(28);
        }
        int size2 = (radius - 3) / 2;
        Color fillColor = style.getFillColor();
        if (fillColor != null) {
            NlGraphics.fillRect(style, g, 0, size2, radius, 3);
            NlGraphics.fillRect(style, g, size2, 0, 3, radius);
        } else {
            NlGraphics.drawLine(style, g, 0, size2 + 1, radius, size2 + 1);
            NlGraphics.drawLine(style, g, size2 + 1, 0, size2 + 1, radius);
        }
    }

    public static void useStroke(@NotNull NlDrawingStyle style, @NotNull Graphics gc) {
        Color strokeColor;
        if (style == null) {
            NlGraphics.$$$reportNull$$$0(29);
        }
        if (gc == null) {
            NlGraphics.$$$reportNull$$$0(30);
        }
        if ((strokeColor = style.getStrokeColor()) != gc.getColor()) {
            gc.setColor(strokeColor);
        }
        if (gc instanceof Graphics2D) {
            Graphics2D gc2 = (Graphics2D)gc;
            Stroke stroke = style.getStroke();
            if (gc2.getStroke() != stroke) {
                gc2.setStroke(stroke);
            }
        }
    }

    public static void useFill(@NotNull NlDrawingStyle style, @NotNull Graphics gc) {
        Color fillColor;
        if (style == null) {
            NlGraphics.$$$reportNull$$$0(31);
        }
        if (gc == null) {
            NlGraphics.$$$reportNull$$$0(32);
        }
        if ((fillColor = style.getFillColor()) != null && fillColor != gc.getColor()) {
            gc.setColor(fillColor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scene";
                break;
            }
            case 2: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectangle";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gc";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/graphics/NlGraphics";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "useStyle";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "drawTop";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "drawTopDp";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "drawLeft";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "drawLeftDp";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "drawRight";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "drawRightDp";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "drawBottom";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "drawBottomDp";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "fillRect";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "drawFilledRect";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "drawStrokeFilledRect";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "drawRect";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "drawLine";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "drawArrow";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "drawCross";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "useStroke";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "useFill";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

