/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearDragTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LinearDragHandler
extends DragHandler {
    private final SceneComponent myComponent;
    private final LinearDragTarget myDragTarget;
    private static final List<Target> ourEmptyTargetList = ImmutableList.of();

    public LinearDragHandler(@NotNull ViewEditor editor, @NotNull LinearLayoutHandler handler, @NotNull SceneComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor == null) {
            LinearDragHandler.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            LinearDragHandler.$$$reportNull$$$0(1);
        }
        if (layout == null) {
            LinearDragHandler.$$$reportNull$$$0(2);
        }
        if (components == null) {
            LinearDragHandler.$$$reportNull$$$0(3);
        }
        if (type == null) {
            LinearDragHandler.$$$reportNull$$$0(4);
        }
        super(editor, handler, layout, components, type);
        assert (!components.isEmpty());
        NlComponent dragged = components.get(0);
        this.myComponent = new TemporarySceneComponent(layout.getScene(), components.get(0));
        this.myDragTarget = new LinearDragTarget(handler, type.equals((Object)DragType.CREATE));
        this.myComponent.setSize(editor.pxToDp(NlComponentHelperKt.getW(dragged)), editor.pxToDp(NlComponentHelperKt.getH(dragged)), false);
        this.myComponent.setTargetProvider((sceneComponent, isParent) -> ImmutableList.of((Object)this.myDragTarget), false);
        this.myComponent.setDrawState(SceneComponent.DrawState.DRAG);
        layout.addChild(this.myComponent);
    }

    @Override
    public void start(int x, int y, int modifiers) {
        super.start(x, y, modifiers);
        this.myDragTarget.mouseDown(x, y);
    }

    @Override
    public void cancel() {
        Scene scene = ((ViewEditorImpl)this.editor).getSceneView().getScene();
        scene.removeComponent(this.myComponent);
        this.myDragTarget.cancel();
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers) {
        String result = super.update(x, y, modifiers);
        int dx = x + this.startX - this.myComponent.getDrawWidth() / 2;
        int dy = y + this.startY - this.myComponent.getDrawHeight() / 2;
        this.myDragTarget.mouseDrag(dx, dy, ourEmptyTargetList);
        return result;
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        if (insertType == null) {
            LinearDragHandler.$$$reportNull$$$0(5);
        }
        Scene scene = ((ViewEditorImpl)this.editor).getSceneView().getScene();
        if (this.myComponent != null) {
            int dx = this.editor.pxToDp(x) - this.myComponent.getDrawWidth() / 2;
            int dy = this.editor.pxToDp(y) - this.myComponent.getDrawHeight() / 2;
            this.myDragTarget.mouseRelease(dx, dy, ourEmptyTargetList);
            scene.removeComponent(this.myComponent);
            if (!this.myDragTarget.isDragHandled()) {
                super.commit(x, y, modifiers, insertType);
            }
            scene.checkRequestLayoutStatus();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/linear/LinearDragHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "commit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

