/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneInteraction;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionSeparator;
import com.android.tools.idea.uibuilder.handlers.linear.LinearDragHandler;
import com.android.tools.idea.uibuilder.handlers.linear.actions.BaselineAction;
import com.android.tools.idea.uibuilder.handlers.linear.actions.ClearWeightsAction;
import com.android.tools.idea.uibuilder.handlers.linear.actions.DistributeWeightsAction;
import com.android.tools.idea.uibuilder.handlers.linear.actions.ToggleOrientationAction;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearDragTarget;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearResizeTarget;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearSeparatorTarget;
import com.android.tools.idea.uibuilder.model.FillPolicy;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableList;
import icons.AndroidIcons;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearLayoutHandler
extends ViewGroupHandler {
    final HashMap<SceneComponent, SceneComponent> myDraggingComponents = new HashMap();

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component2) {
        if (component2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(0);
        }
        if (!component2.getTagName().equals("LinearLayout")) {
            String string = super.getTitleAttributes(component2);
            if (string == null) {
                LinearLayoutHandler.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = this.isVertical(component2) ? "(vertical)" : "(horizontal)";
        if (string == null) {
            LinearLayoutHandler.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component2) {
        if (component2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(3);
        }
        if (!component2.getTagName().equals("LinearLayout")) {
            Icon icon = super.getIcon(component2);
            if (icon == null) {
                LinearLayoutHandler.$$$reportNull$$$0(4);
            }
            return icon;
        }
        Icon icon = this.isVertical(component2) ? AndroidIcons.Views.VerticalLinearLayout : AndroidIcons.Views.LinearLayout;
        if (icon == null) {
            LinearLayoutHandler.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"orientation", (Object)"gravity");
        if (immutableList == null) {
            LinearLayoutHandler.$$$reportNull$$$0(6);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public List<String> getLayoutInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"layout_weight");
        if (immutableList == null) {
            LinearLayoutHandler.$$$reportNull$$$0(7);
        }
        return immutableList;
    }

    public boolean isVertical(@NotNull NlComponent component2) {
        if (component2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(8);
        }
        return "vertical".equals(component2.resolveAttribute("http://schemas.android.com/apk/res/android", "orientation"));
    }

    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull SceneComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor == null) {
            LinearLayoutHandler.$$$reportNull$$$0(9);
        }
        if (layout == null) {
            LinearLayoutHandler.$$$reportNull$$$0(10);
        }
        if (components == null) {
            LinearLayoutHandler.$$$reportNull$$$0(11);
        }
        if (type == null) {
            LinearLayoutHandler.$$$reportNull$$$0(12);
        }
        if (layout.getDrawWidth() == 0 || layout.getDrawHeight() == 0) {
            return null;
        }
        return new LinearDragHandler(editor, this, layout, components, type);
    }

    @Override
    public void onChildInserted(@NotNull ViewEditor editor, @NotNull NlComponent layout, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (editor == null) {
            LinearLayoutHandler.$$$reportNull$$$0(13);
        }
        if (layout == null) {
            LinearLayoutHandler.$$$reportNull$$$0(14);
        }
        if (newChild == null) {
            LinearLayoutHandler.$$$reportNull$$$0(15);
        }
        if (insertType == null) {
            LinearLayoutHandler.$$$reportNull$$$0(16);
        }
        if (insertType == InsertType.MOVE_WITHIN) {
            return;
        }
        ViewHandler viewHandler = NlComponentHelperKt.getViewHandler(newChild);
        if (viewHandler != null) {
            boolean vertical = this.isVertical(layout);
            FillPolicy fill2 = viewHandler.getFillPolicy();
            String fillParent = "match_parent";
            if (fill2.fillHorizontally(vertical)) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", fillParent);
            } else if (!vertical && fill2 == FillPolicy.WIDTH_IN_VERTICAL) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", "1");
            }
            if (fill2.fillVertically(vertical)) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", fillParent);
            }
        }
        boolean duplicateWeight = true;
        boolean duplicate0dip = true;
        String sameWeight = null;
        String sizeAttribute = this.isVertical(layout) ? "layout_height" : "layout_width";
        for (NlComponent target : layout.getChildren()) {
            String size;
            if (target == newChild) continue;
            String weight = target.getAttribute("http://schemas.android.com/apk/res/android", "layout_weight");
            if (weight == null || weight.isEmpty()) {
                duplicateWeight = false;
                break;
            }
            if (sameWeight != null && !sameWeight.equals(weight)) {
                duplicateWeight = false;
            } else {
                sameWeight = weight;
            }
            if ((size = target.getAttribute("http://schemas.android.com/apk/res/android", sizeAttribute)) == null || size.startsWith("0")) continue;
            duplicate0dip = false;
            break;
        }
        if (duplicateWeight && sameWeight != null) {
            newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", sameWeight);
            if (duplicate0dip) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "0dp");
            }
        }
    }

    static float getWeight(@NotNull NlComponent linearLayoutChild) {
        String weight;
        if (linearLayoutChild == null) {
            LinearLayoutHandler.$$$reportNull$$$0(17);
        }
        if ((weight = linearLayoutChild.getAttribute("http://schemas.android.com/apk/res/android", "layout_weight")) != null && !weight.isEmpty()) {
            try {
                return Float.parseFloat(weight);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    static float getWeightSum(@NotNull NlComponent linearLayout) {
        String weightSum;
        if (linearLayout == null) {
            LinearLayoutHandler.$$$reportNull$$$0(18);
        }
        if ((weightSum = linearLayout.getAttribute("http://schemas.android.com/apk/res/android", "weightSum")) != null) {
            try {
                float sum = Float.parseFloat(weightSum);
                return sum;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return LinearLayoutHandler.getSumOfWeights(linearLayout);
    }

    private static float getSumOfWeights(@NotNull NlComponent linearLayout) {
        if (linearLayout == null) {
            LinearLayoutHandler.$$$reportNull$$$0(19);
        }
        float sum = 0.0f;
        for (NlComponent child : linearLayout.getChildren()) {
            sum += LinearLayoutHandler.getWeight(child);
        }
        return sum;
    }

    public void clearWeights(@NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren) {
        if (component2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(20);
        }
        if (selectedChildren == null) {
            LinearLayoutHandler.$$$reportNull$$$0(21);
        }
        String sizeAttribute = this.isVertical(component2) ? "layout_height" : "layout_width";
        for (NlComponent selected : selectedChildren) {
            selected.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", null);
            String size = selected.getAttribute("http://schemas.android.com/apk/res/android", sizeAttribute);
            if (size == null || !size.startsWith("0")) continue;
            selected.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "wrap_content");
        }
    }

    public void distributeWeights(@NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren) {
        if (component2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(22);
        }
        if (selectedChildren == null) {
            LinearLayoutHandler.$$$reportNull$$$0(23);
        }
        if (selectedChildren.isEmpty()) {
            return;
        }
        String weightSum = component2.getAttribute("http://schemas.android.com/apk/res/android", "weightSum");
        double sum = -1.0;
        if (weightSum != null && !weightSum.isEmpty()) {
            try {
                sum = Double.parseDouble(weightSum);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int numTargets = selectedChildren.size();
        double share = sum <= 0.0 ? 1.0 : sum / (double)numTargets;
        String value = XmlUtils.formatFloatAttribute((double)((float)share));
        String sizeAttribute = this.isVertical(component2) ? "layout_height" : "layout_width";
        for (NlComponent selected : selectedChildren) {
            selected.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", value);
            if (!"wrap_content".equals(selected.getAttribute("http://schemas.android.com/apk/res/android", sizeAttribute))) continue;
            selected.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "0dp");
        }
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions) {
        if (actions == null) {
            LinearLayoutHandler.$$$reportNull$$$0(24);
        }
        int rank = 0;
        actions.add(new ToggleOrientationAction().setRank(rank += 20));
        actions.add(new BaselineAction().setRank(rank += 20));
        actions.add(new DistributeWeightsAction().setRank(rank += 20));
        actions.add(new ClearWeightsAction().setRank(rank += 20));
        actions.add(new ViewActionSeparator().setRank(rank += 20));
        this.addDefaultViewActions(actions, rank);
    }

    @Override
    public void addPopupMenuActions(@NotNull List<ViewAction> actions) {
        if (actions == null) {
            LinearLayoutHandler.$$$reportNull$$$0(25);
        }
        this.addToolbarActionsToMenu("LinearLayout", actions);
    }

    @Override
    @Nullable
    public Interaction createInteraction(@NotNull ScreenView sceneView, @NotNull NlComponent layout) {
        if (sceneView == null) {
            LinearLayoutHandler.$$$reportNull$$$0(26);
        }
        if (layout == null) {
            LinearLayoutHandler.$$$reportNull$$$0(27);
        }
        return new SceneInteraction(sceneView);
    }

    @Override
    public boolean handlesPainting() {
        return true;
    }

    @Override
    @NotNull
    public List<Target> createTargets(@NotNull SceneComponent sceneComponent, boolean isParent) {
        if (sceneComponent == null) {
            LinearLayoutHandler.$$$reportNull$$$0(28);
        }
        if (isParent) {
            List<Target> list = super.createTargets(sceneComponent, true);
            if (list == null) {
                LinearLayoutHandler.$$$reportNull$$$0(29);
            }
            return list;
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add((Object)new LinearDragTarget(this));
        LinearLayoutHandler.createResizeTarget(sceneComponent, (ImmutableList.Builder<Target>)listBuilder);
        this.createSeparatorTargets(sceneComponent, (ImmutableList.Builder<Target>)listBuilder);
        ImmutableList immutableList = listBuilder.build();
        if (immutableList == null) {
            LinearLayoutHandler.$$$reportNull$$$0(30);
        }
        return immutableList;
    }

    private void createSeparatorTargets(@NotNull SceneComponent sceneComponent, @NotNull ImmutableList.Builder<Target> listBuilder) {
        if (sceneComponent == null) {
            LinearLayoutHandler.$$$reportNull$$$0(31);
        }
        if (listBuilder == null) {
            LinearLayoutHandler.$$$reportNull$$$0(32);
        }
        SceneComponent parent = sceneComponent.getParent();
        assert (parent != null);
        SceneComponent draggingComponent = this.myDraggingComponents.get(parent);
        if (draggingComponent != null && draggingComponent != sceneComponent) {
            boolean isLayoutOrientationVertical = this.isVertical(parent.getNlComponent());
            if (LinearLayoutHandler.canReceiveBefore(parent, sceneComponent, draggingComponent)) {
                listBuilder.add((Object)new LinearSeparatorTarget(isLayoutOrientationVertical, false));
            }
            if (LinearLayoutHandler.isLastChild(parent, sceneComponent)) {
                listBuilder.add((Object)new LinearSeparatorTarget(isLayoutOrientationVertical, true));
            }
        }
    }

    private static void createResizeTarget(@NotNull SceneComponent sceneComponent, @NotNull ImmutableList.Builder<Target> listBuilder) {
        if (sceneComponent == null) {
            LinearLayoutHandler.$$$reportNull$$$0(33);
        }
        if (listBuilder == null) {
            LinearLayoutHandler.$$$reportNull$$$0(34);
        }
        SceneComponent parent = sceneComponent.getParent();
        assert (parent != null);
        String orientation = parent.getNlComponent().getAttribute("http://schemas.android.com/apk/res/android", "orientation");
        boolean showLeft = true;
        boolean showTop = true;
        boolean showBottom = true;
        boolean showRight = true;
        String gravityAttribute = sceneComponent.getNlComponent().getAttribute("http://schemas.android.com/apk/res/android", "layout_gravity");
        if (gravityAttribute == null || gravityAttribute.contains("fill")) {
            showLeft = false;
            showTop = false;
        } else {
            String[] gravities;
            String[] stringArray = gravities = gravityAttribute.split("\\|");
            int n = stringArray.length;
            block18: for (int i = 0; i < n; ++i) {
                String gravity;
                switch (gravity = stringArray[i]) {
                    case "left": 
                    case "start": {
                        showLeft = false;
                        continue block18;
                    }
                    case "top": {
                        showTop = false;
                        continue block18;
                    }
                    case "bottom": {
                        showBottom = false;
                        continue block18;
                    }
                    case "right": 
                    case "end": {
                        showRight = false;
                        continue block18;
                    }
                    case "center_horizontal": {
                        if (!"vertical".equals(orientation)) continue block18;
                        showTop = false;
                        continue block18;
                    }
                    case "center_vertical": {
                        if (!"horizontal".equals(orientation)) continue block18;
                        showLeft = false;
                    }
                }
            }
        }
        if (showLeft) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.LEFT));
        }
        if (showTop) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.TOP));
        }
        if (showBottom) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.BOTTOM));
        }
        if (showRight) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.RIGHT));
        }
        if (showLeft && showTop) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.LEFT_TOP));
        }
        if (showLeft && showBottom) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.LEFT_BOTTOM));
        }
        if (showRight && showTop) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.RIGHT_TOP));
        }
        if (showRight && showBottom) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.RIGHT_BOTTOM));
        }
    }

    private static boolean canReceiveBefore(@NotNull SceneComponent parent, @NotNull SceneComponent nextSibling, @NotNull SceneComponent draggingComponent) {
        List<NlComponent> children;
        int i;
        if (parent == null) {
            LinearLayoutHandler.$$$reportNull$$$0(35);
        }
        if (nextSibling == null) {
            LinearLayoutHandler.$$$reportNull$$$0(36);
        }
        if (draggingComponent == null) {
            LinearLayoutHandler.$$$reportNull$$$0(37);
        }
        return (i = (children = parent.getNlComponent().getChildren()).indexOf(nextSibling.getNlComponent())) > -1 && (i == 0 || children.get(i - 1) != draggingComponent.getNlComponent());
    }

    private static boolean isLastChild(@NotNull SceneComponent linearLayoutComponent, @NotNull SceneComponent child) {
        NlComponent nlComponent;
        if (linearLayoutComponent == null) {
            LinearLayoutHandler.$$$reportNull$$$0(38);
        }
        if (child == null) {
            LinearLayoutHandler.$$$reportNull$$$0(39);
        }
        return (nlComponent = linearLayoutComponent.getNlComponent()).getChild(nlComponent.getChildCount() - 1) == child.getNlComponent();
    }

    public static boolean insertComponentAtTarget(@NotNull SceneComponent component2, @NotNull LinearSeparatorTarget separatorTarget, boolean isDragFromPalette) {
        SceneComponent sceneParent;
        if (component2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(40);
        }
        if (separatorTarget == null) {
            LinearLayoutHandler.$$$reportNull$$$0(41);
        }
        if ((sceneParent = component2.getParent()) == null) {
            return false;
        }
        NlComponent parent = sceneParent.getNlComponent();
        String id = component2.getNlComponent().getId();
        String name = (isDragFromPalette ? "Insert" : "Move") + ' ' + (id != null ? id : component2.getNlComponent().getTagName());
        NlWriteCommandAction.run(component2.getNlComponent(), name, () -> {
            if (component2 == null) {
                LinearLayoutHandler.$$$reportNull$$$0(43);
            }
            if (separatorTarget == null) {
                LinearLayoutHandler.$$$reportNull$$$0(44);
            }
            ImmutableList nlComponentImmutableList = ImmutableList.of((Object)component2.getNlComponent());
            parent.getModel().addComponents((List<NlComponent>)nlComponentImmutableList, parent, !separatorTarget.isAtEnd() ? separatorTarget.getComponent().getNlComponent() : null, isDragFromPalette ? InsertType.CREATE : InsertType.MOVE_WITHIN);
        });
        return true;
    }

    public void setDragging(@NotNull SceneComponent draggedComponent, boolean isDragging) {
        if (draggedComponent == null) {
            LinearLayoutHandler.$$$reportNull$$$0(42);
        }
        if (isDragging && !this.myDraggingComponents.containsKey(draggedComponent.getParent())) {
            this.myDraggingComponents.put(draggedComponent.getParent(), draggedComponent);
        } else if (!isDragging && this.myDraggingComponents.containsKey(draggedComponent.getParent())) {
            this.myDraggingComponents.remove(draggedComponent.getParent());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/linear/LinearLayoutHandler";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: 
            case 14: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linearLayoutChild";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linearLayout";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedChildren";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
            case 28: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneComponent";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listBuilder";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextSibling";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "draggingComponent";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linearLayoutComponent";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separatorTarget";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "draggedComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/linear/LinearLayoutHandler";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleAttributes";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorProperties";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutInspectorProperties";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTitleAttributes";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 29: 
            case 30: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isVertical";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDragHandler";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onChildInserted";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getWeight";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getWeightSum";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSumOfWeights";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "clearWeights";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "distributeWeights";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addToolbarActions";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addPopupMenuActions";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createInteraction";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createTargets";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createSeparatorTargets";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createResizeTarget";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "canReceiveBefore";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isLastChild";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "insertComponentAtTarget";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setDragging";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$insertComponentAtTarget$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

