/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.backgroundremove.RemoveBackgroundPanel;
import com.android.tools.idea.uibuilder.mockup.editor.creators.ResourcesUtil;
import com.android.tools.idea.uibuilder.mockup.editor.creators.SimpleViewCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.forms.ExtractBackgroundForm;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageViewCreator
extends SimpleViewCreator {
    public static final Logger LOGGER = Logger.getInstance(ImageViewCreator.class);
    public static final String DRAWABLE_TYPE = "png";
    private final Rectangle mySelection;
    private RemoveBackgroundPanel myRemoveBackgroundPanel;
    private ExtractBackgroundForm myExtractBackgroundForm;
    @Nullable
    private String myDrawableName;

    public ImageViewCreator(@NotNull Mockup mockup, @NotNull NlModel model, @NotNull ScreenView screenView, @NotNull Rectangle selection) {
        if (mockup == null) {
            ImageViewCreator.$$$reportNull$$$0(0);
        }
        if (model == null) {
            ImageViewCreator.$$$reportNull$$$0(1);
        }
        if (screenView == null) {
            ImageViewCreator.$$$reportNull$$$0(2);
        }
        if (selection == null) {
            ImageViewCreator.$$$reportNull$$$0(3);
        }
        super(mockup, model, screenView, selection);
        this.mySelection = selection;
        this.myRemoveBackgroundPanel = new RemoveBackgroundPanel();
        this.myExtractBackgroundForm = new ExtractBackgroundForm(this.myRemoveBackgroundPanel);
    }

    @Override
    @NotNull
    public String getAndroidViewTag() {
        if ("ImageView" == null) {
            ImageViewCreator.$$$reportNull$$$0(4);
        }
        return "ImageView";
    }

    @Override
    public boolean hasOptionsComponent() {
        return true;
    }

    @Override
    @Nullable
    public JComponent getOptionsComponent(@NotNull WidgetCreator.DoneCallback doneCallback) {
        Mockup mockup;
        BufferedImage image;
        if (doneCallback == null) {
            ImageViewCreator.$$$reportNull$$$0(5);
        }
        if ((image = (mockup = this.getMockup()).getImage()) == null) {
            return null;
        }
        this.myExtractBackgroundForm.setOKListener(actionEvent -> {
            BufferedImage extractedImage;
            if (doneCallback == null) {
                ImageViewCreator.$$$reportNull$$$0(7);
            }
            if ((extractedImage = this.myRemoveBackgroundPanel.getImage()) == null) {
                doneCallback.done(0);
                return;
            }
            this.myDrawableName = this.myExtractBackgroundForm.getDrawableName();
            if (ResourcesUtil.checkDrawableExist(this.myDrawableName, DRAWABLE_TYPE, this.getModel().getFacet())) {
                this.myExtractBackgroundForm.setErrorText(String.format("A drawable resource named <i>%s</i> already exists and will be overwritten.", this.myDrawableName));
                return;
            }
            ResourcesUtil.createDrawable(this.myDrawableName, DRAWABLE_TYPE, doneCallback, this.getModel(), extractedImage, this);
        });
        Rectangle realCropping = mockup.getComputedCropping();
        BufferedImage subimage = image.getSubimage(realCropping.x + this.mySelection.x, realCropping.y + this.mySelection.y, this.mySelection.width, this.mySelection.height);
        this.myRemoveBackgroundPanel.setImage(subimage);
        this.myRemoveBackgroundPanel.setPreferredSize(new Dimension(300, 300));
        return this.myExtractBackgroundForm.getComponent();
    }

    @Override
    protected void addAttributes(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            ImageViewCreator.$$$reportNull$$$0(6);
        }
        super.addAttributes(transaction);
        if (this.getDrawableName() != null) {
            transaction.setAttribute(null, "android:src", "@drawable/" + this.getDrawableName());
        }
    }

    @Nullable
    public String getDrawableName() {
        return this.myDrawableName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/mockup/editor/creators/ImageViewCreator";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doneCallback";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/creators/ImageViewCreator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidViewTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAttributes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOptionsComponent$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

