/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.analytics.NlUsageTrackerManager;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.rendering.LayoutPullParsers;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.TagSnapshot;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.NlSceneDecoratorFactory;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.util.PropertiesMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorRenderResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutlibSceneManager
extends SceneManager {
    private static final SceneDecoratorFactory DECORATOR_FACTORY = new NlSceneDecoratorFactory();
    private int myDpi;
    private final SelectionChangeListener mySelectionChangeListener;
    private final ModelChangeListener myModelChangeListener;
    private final ConfigurationListener myConfigurationChangeListener;
    private boolean myAreListenersRegistered;
    private static final Object PROGRESS_LOCK = new Object();
    private AndroidPreviewProgressIndicator myCurrentIndicator;
    private final Object myRenderingQueueLock;
    private MergingUpdateQueue myRenderingQueue;
    private static final int RENDER_DELAY_MS = 10;
    private RenderTask myRenderTask;
    private static final Object RENDERING_LOCK = new Object();
    private ResourceNotificationManager.ResourceVersion myRenderedVersion;
    private final ReentrantReadWriteLock myRenderResultLock;
    @GuardedBy(value="myRenderResultLock")
    private RenderResult myRenderResult;
    private String myPreviousDeviceName;
    private Locale myPreviousLocale;
    private String myPreviousVersion;
    private String myPreviousTheme;
    private static final int VISUAL_EMPTY_COMPONENT_SIZE = 1;
    private long myElapsedFrameTimeMs;
    private final LinkedList<Runnable> myRenderCallbacks;
    private static boolean ourRenderViewPort;

    protected static LayoutEditorRenderResult.Trigger getTriggerFromChangeType(@Nullable NlModel.ChangeType changeType) {
        if (changeType == null) {
            return null;
        }
        switch (changeType) {
            case RESOURCE_EDIT: 
            case RESOURCE_CHANGED: {
                return LayoutEditorRenderResult.Trigger.RESOURCE_CHANGE;
            }
            case EDIT: 
            case ADD_COMPONENTS: 
            case DELETE: 
            case DND_COMMIT: 
            case DND_END: 
            case DROP: 
            case RESIZE_END: 
            case RESIZE_COMMIT: {
                return LayoutEditorRenderResult.Trigger.EDIT;
            }
            case BUILD: {
                return LayoutEditorRenderResult.Trigger.BUILD;
            }
        }
        return null;
    }

    public LayoutlibSceneManager(@NotNull NlModel model, @NotNull DesignSurface designSurface) {
        if (model == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(0);
        }
        if (designSurface == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(1);
        }
        super(model, designSurface);
        this.myDpi = 0;
        this.mySelectionChangeListener = new SelectionChangeListener();
        this.myModelChangeListener = new ModelChangeListener();
        this.myConfigurationChangeListener = new ConfigurationChangeListener();
        this.myAreListenersRegistered = false;
        this.myRenderingQueueLock = new Object();
        this.myRenderResultLock = new ReentrantReadWriteLock();
        this.myElapsedFrameTimeMs = -1L;
        this.myRenderCallbacks = new LinkedList();
        this.updateTrackingConfiguration();
    }

    @Override
    @NotNull
    public SceneDecoratorFactory getSceneDecoratorFactory() {
        SceneDecoratorFactory sceneDecoratorFactory = DECORATOR_FACTORY;
        if (sceneDecoratorFactory == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(2);
        }
        return sceneDecoratorFactory;
    }

    @Override
    @NotNull
    public Scene build() {
        Scene scene = super.build();
        this.getDesignSurface().getSelectionModel().addListener(this.mySelectionChangeListener);
        NlModel model = this.getModel();
        model.getConfiguration().addListener(this.myConfigurationChangeListener);
        ImmutableList<NlComponent> components = model.getComponents();
        if (!components.isEmpty()) {
            NlComponent rootComponent = ((NlComponent)components.get(0)).getRoot();
            boolean previous = this.getScene().isAnimated();
            scene.setAnimated(false);
            SceneComponent root = this.createHierarchy(rootComponent);
            this.updateFromComponent(root, new HashSet<SceneComponent>());
            scene.setRoot(root);
            this.addTargets(root);
            scene.setAnimated(previous);
        }
        model.addListener(this.myModelChangeListener);
        this.myAreListenersRegistered = true;
        scene.selectionChanged(this.getDesignSurface().getSelectionModel(), (List<NlComponent>)this.getDesignSurface().getSelectionModel().getSelection());
        Scene scene2 = scene;
        if (scene2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(3);
        }
        return scene2;
    }

    @Override
    public void dispose() {
        if (this.myAreListenersRegistered) {
            NlModel model = this.getModel();
            this.getDesignSurface().getSelectionModel().removeListener(this.mySelectionChangeListener);
            model.getConfiguration().removeListener(this.myConfigurationChangeListener);
            model.removeListener(this.myModelChangeListener);
        }
        super.dispose();
        ApplicationManager.getApplication().invokeLater(() -> {
            Object object = RENDERING_LOCK;
            synchronized (object) {
                if (this.myRenderTask != null) {
                    this.myRenderTask.dispose();
                    this.myRenderTask = null;
                }
            }
            this.myRenderResultLock.writeLock().lock();
            try {
                this.myRenderResult = null;
            }
            finally {
                this.myRenderResultLock.writeLock().unlock();
            }
        });
    }

    @Override
    protected void updateFromComponent(SceneComponent sceneComponent) {
        super.updateFromComponent(sceneComponent);
        NlComponent component2 = sceneComponent.getNlComponent();
        if (this.getScene().isAnimated()) {
            long time2 = System.currentTimeMillis();
            sceneComponent.setPositionTarget(Coordinates.pxToDp(component2.getModel(), NlComponentHelperKt.getX(component2)), Coordinates.pxToDp(component2.getModel(), NlComponentHelperKt.getY(component2)), time2, true);
            sceneComponent.setSizeTarget(Coordinates.pxToDp(component2.getModel(), NlComponentHelperKt.getW(component2)), Coordinates.pxToDp(component2.getModel(), NlComponentHelperKt.getH(component2)), time2, true);
        } else {
            sceneComponent.setPosition(Coordinates.pxToDp(component2.getModel(), NlComponentHelperKt.getX(component2)), Coordinates.pxToDp(component2.getModel(), NlComponentHelperKt.getY(component2)), true);
            sceneComponent.setSize(Coordinates.pxToDp(component2.getModel(), NlComponentHelperKt.getW(component2)), Coordinates.pxToDp(component2.getModel(), NlComponentHelperKt.getH(component2)), true);
        }
    }

    @Override
    public void update() {
        super.update();
        SelectionModel selectionModel = this.getDesignSurface().getSelectionModel();
        if (this.getScene().getRoot() != null && selectionModel.isEmpty()) {
            this.addTargets(this.getScene().getRoot());
        }
    }

    public void addTargets(@NotNull SceneComponent component2) {
        SceneComponent parent;
        ViewHandler handler;
        if (component2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(4);
        }
        if ((handler = NlComponentHelperKt.getViewHandler((component2 = (parent = component2.getParent()) != null ? parent : this.getScene().getRoot()).getNlComponent())) instanceof ViewGroupHandler) {
            ViewGroupHandler viewGroupHandler = (ViewGroupHandler)handler;
            component2.setTargetProvider(viewGroupHandler, true);
            for (SceneComponent child : component2.getChildren()) {
                child.setTargetProvider(viewGroupHandler, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestRender(@Nullable Runnable callback, final @Nullable LayoutEditorRenderResult.Trigger trigger) {
        if (callback != null) {
            LinkedList<Runnable> linkedList = this.myRenderCallbacks;
            synchronized (linkedList) {
                this.myRenderCallbacks.add(callback);
            }
        }
        this.getRenderingQueue().queue(new Update("model.render", 999){

            public void run() {
                LayoutlibSceneManager.this.render(trigger);
            }

            public boolean canEat(Update update) {
                return this.equals(update);
            }
        });
    }

    @Override
    public void requestRender() {
        this.requestRender(null, LayoutlibSceneManager.getTriggerFromChangeType(this.getModel().getLastChangeType()));
    }

    public void requestUserInitatedRender() {
        this.requestRender(null, LayoutEditorRenderResult.Trigger.USER);
    }

    public void requestLayoutAndRender(boolean animate) {
        this.requestRender(() -> this.getModel().notifyListenersModelLayoutComplete(animate), LayoutlibSceneManager.getTriggerFromChangeType(this.getModel().getLastChangeType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestModelUpdate() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = PROGRESS_LOCK;
        synchronized (object) {
            if (this.myCurrentIndicator == null) {
                this.myCurrentIndicator = new AndroidPreviewProgressIndicator();
                this.myCurrentIndicator.start();
            }
        }
        this.getRenderingQueue().queue(new Update("model.update", 10){

            public void run() {
                NlModel model = LayoutlibSceneManager.this.getModel();
                Project project = model.getModule().getProject();
                if (!project.isOpen()) {
                    return;
                }
                DumbService.getInstance((Project)project).runWhenSmart(() -> {
                    if (model.getFile().isValid() && !model.getFacet().isDisposed()) {
                        try {
                            LayoutlibSceneManager.this.updateModel();
                        }
                        catch (Throwable e) {
                            Logger.getInstance(NlModel.class).error(e);
                        }
                    }
                    Object object = PROGRESS_LOCK;
                    synchronized (object) {
                        if (LayoutlibSceneManager.this.myCurrentIndicator != null) {
                            LayoutlibSceneManager.this.myCurrentIndicator.stop();
                            LayoutlibSceneManager.this.myCurrentIndicator = null;
                        }
                    }
                });
            }

            public boolean canEat(Update update) {
                return this.equals(update);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public MergingUpdateQueue getRenderingQueue() {
        Object object = this.myRenderingQueueLock;
        // MONITORENTER : object
        if (this.myRenderingQueue == null) {
            this.myRenderingQueue = new MergingUpdateQueue("android.layout.rendering", 10, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
            this.myRenderingQueue.setRestartTimerOnAdd(true);
        }
        MergingUpdateQueue mergingUpdateQueue = this.myRenderingQueue;
        // MONITOREXIT : object
        if (mergingUpdateQueue != null) return mergingUpdateQueue;
        LayoutlibSceneManager.$$$reportNull$$$0(5);
        return mergingUpdateQueue;
    }

    public static void setRenderViewPort(boolean state) {
        ourRenderViewPort = state;
    }

    public static boolean isRenderViewPort() {
        return ourRenderViewPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layout(boolean animate) {
        if (this.myRenderTask != null) {
            Object object = RENDERING_LOCK;
            synchronized (object) {
                RenderResult result = null;
                try {
                    result = (RenderResult)this.myRenderTask.layout().get();
                }
                catch (InterruptedException | ExecutionException e) {
                    Logger.getInstance(NlModel.class).warn("Unable to run layout()", (Throwable)e);
                }
                if (result != null) {
                    this.updateHierarchy(result);
                    this.getModel().notifyListenersModelLayoutComplete(animate);
                }
            }
        }
    }

    @Nullable
    public RenderResult getRenderResult() {
        this.myRenderResultLock.readLock().lock();
        try {
            RenderResult renderResult = this.myRenderResult;
            return renderResult;
        }
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Map<Object, PropertiesMap> getDefaultProperties() {
        this.myRenderResultLock.readLock().lock();
        if (this.myRenderResult == null) {
            Map<Object, PropertiesMap> map = Collections.emptyMap();
            Map<Object, PropertiesMap> map2 = map;
            if (map2 == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(6);
            }
            return map2;
        }
        Map<Object, PropertiesMap> map = this.myRenderResult.getDefaultProperties();
        Map<Object, PropertiesMap> map3 = map;
        if (map3 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(7);
        }
        return map3;
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    private void updateHierarchy(@Nullable RenderResult result) {
        if (result == null || !result.getRenderResult().isSuccess()) {
            LayoutlibSceneManager.updateHierarchy(Collections.emptyList(), this.getModel());
        } else {
            LayoutlibSceneManager.updateHierarchy(this.getRootViews(result), this.getModel());
        }
        this.getModel().checkStructure();
    }

    @NotNull
    private List<ViewInfo> getRootViews(@NotNull RenderResult result) {
        if (result == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(8);
        }
        List<ViewInfo> list = this.getModel().getType() == NlLayoutType.MENU ? result.getSystemRootViews() : result.getRootViews();
        if (list == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(9);
        }
        return list;
    }

    @VisibleForTesting
    public static void updateHierarchy(@NotNull XmlTag rootTag, @NotNull List<ViewInfo> rootViews, @NotNull NlModel model) {
        if (rootTag == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(10);
        }
        if (rootViews == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(11);
        }
        if (model == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(12);
        }
        model.syncWithPsi(rootTag, rootViews.stream().map(ViewInfoTagSnapshotNode::new).collect(Collectors.toList()));
        LayoutlibSceneManager.updateBounds(rootViews, model);
    }

    @VisibleForTesting
    public static void updateHierarchy(@NotNull List<ViewInfo> rootViews, @NotNull NlModel model) {
        if (rootViews == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(13);
        }
        if (model == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(14);
        }
        LayoutlibSceneManager.updateHierarchy(AndroidPsiUtils.getRootTagSafely(model.getFile()), rootViews, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inflate(boolean force) {
        Configuration configuration = this.getModel().getConfiguration();
        Project project = this.getModel().getProject();
        if (project.isDisposed()) {
            return false;
        }
        ResourceNotificationManager resourceNotificationManager = ResourceNotificationManager.getInstance(project);
        LayoutPullParsers.saveFileIfNecessary((PsiFile)this.getModel().getFile());
        RenderResult result = null;
        Object object = RENDERING_LOCK;
        synchronized (object) {
            if (this.myRenderTask != null && !force) {
                return false;
            }
            this.myRenderedVersion = resourceNotificationManager.getCurrentVersion(this.getModel().getFacet(), (PsiFile)this.getModel().getFile(), configuration);
            RenderService renderService = RenderService.getInstance(this.getModel().getFacet());
            RenderLogger logger = renderService.createLogger();
            if (this.myRenderTask != null && !this.myRenderTask.isDisposed()) {
                this.myRenderTask.dispose();
            }
            this.myRenderTask = renderService.createTask((PsiFile)this.getModel().getFile(), configuration, logger, this.getDesignSurface());
            this.setupRenderTask(this.myRenderTask);
            if (this.myRenderTask != null) {
                this.myRenderTask.getLayoutlibCallback().setAdaptiveIconMaskPath(((NlDesignSurface)this.getDesignSurface()).getAdaptiveIconShape().getPathDescription());
                if (!LayoutlibSceneManager.isRenderViewPort()) {
                    this.myRenderTask.useDesignMode((PsiFile)this.getModel().getFile());
                }
                if ((result = this.myRenderTask.inflate()) == null || !result.getRenderResult().isSuccess()) {
                    this.myRenderTask.dispose();
                    this.myRenderTask = null;
                    if (result == null) {
                        result = RenderResult.createBlank((PsiFile)this.getModel().getFile());
                    }
                }
            }
            this.updateHierarchy(result);
            this.myRenderResultLock.writeLock().lock();
            try {
                this.myRenderResult = result;
            }
            finally {
                this.myRenderResultLock.writeLock().unlock();
            }
            return this.myRenderTask != null;
        }
    }

    @VisibleForTesting
    protected void setupRenderTask(@Nullable RenderTask task) {
    }

    protected void updateModel() {
        this.inflate(true);
        this.getModel().notifyListenersModelUpdateComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void render(@Nullable LayoutEditorRenderResult.Trigger trigger) {
        try {
            this.renderImpl(trigger);
        }
        catch (Throwable e) {
            if (!this.getModel().getFacet().isDisposed()) {
                throw e;
            }
        }
        finally {
            ImmutableList callbacks;
            LinkedList<Runnable> linkedList = this.myRenderCallbacks;
            synchronized (linkedList) {
                callbacks = ImmutableList.copyOf(this.myRenderCallbacks);
                this.myRenderCallbacks.clear();
            }
            callbacks.forEach(Runnable::run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderImpl(@Nullable LayoutEditorRenderResult.Trigger trigger) {
        Configuration configuration = this.getModel().getConfiguration();
        DesignSurface surface = this.getDesignSurface();
        if (this.getModel().getConfigurationModificationCount() != configuration.getModificationCount()) {
            if (!StringUtil.equals((CharSequence)configuration.getTheme(), (CharSequence)this.myPreviousTheme)) {
                this.myPreviousTheme = configuration.getTheme();
                NlUsageTrackerManager.getInstance(surface).logAction(LayoutEditorEvent.LayoutEditorEventType.THEME_CHANGE);
            } else if (configuration.getTarget() != null && !StringUtil.equals((CharSequence)configuration.getTarget().getVersionName(), (CharSequence)this.myPreviousVersion)) {
                this.myPreviousVersion = configuration.getTarget().getVersionName();
                NlUsageTrackerManager.getInstance(surface).logAction(LayoutEditorEvent.LayoutEditorEventType.API_LEVEL_CHANGE);
            } else if (!configuration.getLocale().equals(this.myPreviousLocale)) {
                this.myPreviousLocale = configuration.getLocale();
                NlUsageTrackerManager.getInstance(surface).logAction(LayoutEditorEvent.LayoutEditorEventType.LANGUAGE_CHANGE);
            } else if (configuration.getDevice() != null && !StringUtil.equals((CharSequence)configuration.getDevice().getDisplayName(), (CharSequence)this.myPreviousDeviceName)) {
                this.myPreviousDeviceName = configuration.getDevice().getDisplayName();
                NlUsageTrackerManager.getInstance(surface).logAction(LayoutEditorEvent.LayoutEditorEventType.DEVICE_CHANGE);
            }
        }
        NlModel.ChangeType changeType = this.getModel().getLastChangeType();
        this.getModel().resetLastChange();
        long renderStartTimeMs = System.currentTimeMillis();
        boolean inflated = this.inflate(false);
        Object object = RENDERING_LOCK;
        synchronized (object) {
            if (this.myRenderTask != null) {
                RenderResult result;
                if (this.myElapsedFrameTimeMs != -1L) {
                    this.myRenderTask.setElapsedFrameTimeNanos(TimeUnit.MILLISECONDS.toNanos(this.myElapsedFrameTimeMs));
                }
                if ((result = (RenderResult)Futures.getUnchecked(this.myRenderTask.render())) != null && !inflated) {
                    this.updateHierarchy(result);
                }
                this.myRenderResultLock.writeLock().lock();
                try {
                    this.myRenderResult = result;
                    this.myRenderResultLock.readLock().lock();
                }
                finally {
                    this.myRenderResultLock.writeLock().unlock();
                }
                try {
                    NlUsageTrackerManager.getInstance(surface).logRenderResult(trigger, this.myRenderResult, System.currentTimeMillis() - renderStartTimeMs);
                }
                finally {
                    this.myRenderResultLock.readLock().unlock();
                }
            }
        }
        this.getModel().notifyListenersRenderComplete();
    }

    public void setElapsedFrameTimeMs(long ms) {
        this.myElapsedFrameTimeMs = ms;
    }

    private void updateTrackingConfiguration() {
        Configuration configuration = this.getModel().getConfiguration();
        this.myPreviousDeviceName = configuration.getDevice() != null ? configuration.getDevice().getDisplayName() : null;
        this.myPreviousVersion = configuration.getTarget() != null ? configuration.getTarget().getVersionName() : null;
        this.myPreviousLocale = configuration.getLocale();
        this.myPreviousTheme = configuration.getTheme();
    }

    private static void clearDerivedData(@NotNull NlComponent component2) {
        if (component2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(15);
        }
        NlComponentHelperKt.setBounds(component2, 0, 0, -1, -1);
        NlComponentHelperKt.setViewInfo(component2, null);
    }

    private static void updateBounds(@NotNull List<ViewInfo> rootViews, @NotNull NlModel model) {
        if (rootViews == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(16);
        }
        if (model == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(17);
        }
        model.flattenComponents().forEach(LayoutlibSceneManager::clearDerivedData);
        Map<TagSnapshot, NlComponent> snapshotToComponent = model.flattenComponents().collect(Collectors.toMap(NlComponent::getSnapshot, Function.identity(), (n1, n2) -> n1));
        Map<XmlTag, NlComponent> tagToComponent = model.flattenComponents().collect(Collectors.toMap(NlComponent::getTag, Function.identity()));
        for (ViewInfo view : rootViews) {
            LayoutlibSceneManager.updateBounds(view, 0, 0, snapshotToComponent, tagToComponent);
        }
        if (!rootViews.isEmpty()) {
            LayoutlibSceneManager.fixBounds((NlComponent)model.getComponents().get(0));
        }
    }

    private static void fixBounds(@NotNull NlComponent root) {
        List<NlComponent> children;
        if (root == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(18);
        }
        boolean computeBounds = false;
        if (NlComponentHelperKt.getW(root) == -1 && NlComponentHelperKt.getH(root) == -1) {
            computeBounds = true;
            NlComponent parent = root.getParent();
            if (parent != null && NlComponentHelperKt.getW(parent) >= 0) {
                NlComponentHelperKt.setBounds(root, NlComponentHelperKt.getX(parent), NlComponentHelperKt.getY(parent), 0, 0);
            }
        }
        if ((children = root.children) != null && !children.isEmpty()) {
            for (NlComponent child : children) {
                LayoutlibSceneManager.fixBounds(child);
            }
            if (computeBounds) {
                Rectangle rectangle = new Rectangle(NlComponentHelperKt.getX(root), NlComponentHelperKt.getY(root), NlComponentHelperKt.getW(root), NlComponentHelperKt.getH(root));
                for (NlComponent child : children) {
                    rectangle = rectangle.union(new Rectangle(NlComponentHelperKt.getX(child), NlComponentHelperKt.getY(child), NlComponentHelperKt.getW(child), NlComponentHelperKt.getH(child)));
                }
                NlComponentHelperKt.setBounds(root, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    private static void updateBounds(@NotNull ViewInfo view, int parentX, int parentY, Map<TagSnapshot, NlComponent> snapshotToComponent, Map<XmlTag, NlComponent> tagToComponent) {
        if (view == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(19);
        }
        ViewInfo bounds = RenderService.getSafeBounds(view);
        Object cookie = view.getCookie();
        if (cookie != null && cookie instanceof TagSnapshot) {
            TagSnapshot snapshot = (TagSnapshot)cookie;
            NlComponent component2 = snapshotToComponent.get(snapshot);
            if (component2 == null) {
                component2 = tagToComponent.get(snapshot.tag);
            }
            if (component2 != null && NlComponentHelperKt.getViewInfo(component2) == null) {
                NlComponentHelperKt.setViewInfo(component2, view);
                int left = parentX + bounds.getLeft();
                int top = parentY + bounds.getTop();
                int width = bounds.getRight() - bounds.getLeft();
                int height = bounds.getBottom() - bounds.getTop();
                NlComponentHelperKt.setBounds(component2, left, top, Math.max(width, 1), Math.max(height, 1));
            }
        }
        parentX += bounds.getLeft();
        parentY += bounds.getTop();
        for (ViewInfo child : view.getChildren()) {
            LayoutlibSceneManager.updateBounds(child, parentX, parentY, snapshotToComponent, tagToComponent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designSurface";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTag";
                break;
            }
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootViews";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneDecoratorFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderingQueue";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProperties";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootViews";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTargets";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRootViews";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateHierarchy";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "clearDerivedData";
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateBounds";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fixBounds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ViewInfoTagSnapshotNode
    implements NlModel.TagSnapshotTreeNode {
        private final ViewInfo myViewInfo;

        public ViewInfoTagSnapshotNode(ViewInfo info) {
            this.myViewInfo = info;
        }

        @Override
        @Nullable
        public TagSnapshot getTagSnapshot() {
            Object result = this.myViewInfo.getCookie();
            return result instanceof TagSnapshot ? (TagSnapshot)result : null;
        }

        @Override
        @NotNull
        public List<NlModel.TagSnapshotTreeNode> getChildren() {
            List<NlModel.TagSnapshotTreeNode> list = this.myViewInfo.getChildren().stream().map(ViewInfoTagSnapshotNode::new).collect(Collectors.toList());
            if (list == null) {
                ViewInfoTagSnapshotNode.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager$ViewInfoTagSnapshotNode", "getChildren"));
        }
    }

    private class AndroidPreviewProgressIndicator
    extends ProgressIndicatorBase {
        private final Object myLock = new Object();

        private AndroidPreviewProgressIndicator() {
        }

        public void start() {
            super.start();
            UIUtil.invokeLaterIfNeeded(() -> {
                Timer timer = UIUtil.createNamedTimer((String)"Android rendering progress timer", (int)0, event -> {
                    Object object = this.myLock;
                    synchronized (object) {
                        if (this.isRunning()) {
                            LayoutlibSceneManager.this.getDesignSurface().registerIndicator((ProgressIndicator)this);
                        }
                    }
                });
                timer.setRepeats(false);
                timer.start();
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.myLock;
            synchronized (object) {
                super.stop();
                ApplicationManager.getApplication().invokeLater(() -> LayoutlibSceneManager.this.getDesignSurface().unregisterIndicator((ProgressIndicator)this));
            }
        }
    }

    private class ConfigurationChangeListener
    implements ConfigurationListener {
        private ConfigurationChangeListener() {
        }

        @Override
        public boolean changed(int flags) {
            if ((flags & 2) != 0) {
                int newDpi = LayoutlibSceneManager.this.getModel().getConfiguration().getDensity().getDpiValue();
                if (LayoutlibSceneManager.this.myDpi != newDpi) {
                    LayoutlibSceneManager.this.update();
                }
            }
            return true;
        }
    }

    private class SelectionChangeListener
    implements SelectionListener {
        private SelectionChangeListener() {
        }

        @Override
        public void selectionChanged(@NotNull SelectionModel model, @NotNull List<NlComponent> selection) {
            SceneComponent root;
            if (model == null) {
                SelectionChangeListener.$$$reportNull$$$0(0);
            }
            if (selection == null) {
                SelectionChangeListener.$$$reportNull$$$0(1);
            }
            if ((root = LayoutlibSceneManager.this.getScene().getRoot()) != null) {
                this.clearChildTargets(root);
                if (!selection.isEmpty()) {
                    NlComponent primary = selection.get(0);
                    SceneComponent component2 = LayoutlibSceneManager.this.getScene().getSceneComponent(primary);
                    if (component2 != null) {
                        LayoutlibSceneManager.this.addTargets(component2);
                    } else {
                        LayoutlibSceneManager.this.addTargets(root);
                    }
                } else {
                    LayoutlibSceneManager.this.addTargets(root);
                }
            }
            LayoutlibSceneManager.this.getScene().needsRebuildList();
        }

        void clearChildTargets(SceneComponent component2) {
            component2.setTargetProvider(null, true);
            for (SceneComponent child : component2.getChildren()) {
                child.setTargetProvider(null, false);
                this.clearChildTargets(child);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selection";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager$SelectionChangeListener";
            objectArray[2] = "selectionChanged";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ModelChangeListener
    implements ModelListener {
        private ModelChangeListener() {
        }

        @Override
        public void modelDerivedDataChanged(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(0);
            }
            DesignSurface surface = LayoutlibSceneManager.this.getDesignSurface();
            LayoutlibSceneManager.this.render(LayoutlibSceneManager.getTriggerFromChangeType(model.getLastChangeType()));
        }

        @Override
        public void modelChanged(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(1);
            }
            LayoutlibSceneManager.this.requestModelUpdate();
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!Disposer.isDisposed((Disposable)LayoutlibSceneManager.this)) {
                    LayoutlibSceneManager.this.mySelectionChangeListener.selectionChanged(LayoutlibSceneManager.this.getDesignSurface().getSelectionModel(), (List<NlComponent>)LayoutlibSceneManager.this.getDesignSurface().getSelectionModel().getSelection());
                }
            });
        }

        @Override
        public void modelRendered(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(2);
            }
            UIUtil.invokeLaterIfNeeded(LayoutlibSceneManager.this::update);
        }

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(3);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (!Disposer.isDisposed((Disposable)LayoutlibSceneManager.this)) {
                    boolean previous = LayoutlibSceneManager.this.getScene().isAnimated();
                    LayoutlibSceneManager.this.getScene().setAnimated(animate);
                    LayoutlibSceneManager.this.update();
                    LayoutlibSceneManager.this.getScene().setAnimated(previous);
                }
            });
        }

        @Override
        public void modelActivated(@NotNull NlModel model) {
            ResourceNotificationManager manager;
            ResourceNotificationManager.ResourceVersion version;
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(4);
            }
            if (!(version = (manager = ResourceNotificationManager.getInstance(LayoutlibSceneManager.this.getModel().getProject())).getCurrentVersion(LayoutlibSceneManager.this.getModel().getFacet(), (PsiFile)LayoutlibSceneManager.this.getModel().getFile(), LayoutlibSceneManager.this.getModel().getConfiguration())).equals(LayoutlibSceneManager.this.myRenderedVersion)) {
                LayoutlibSceneManager.this.requestModelUpdate();
                model.updateTheme();
            }
        }

        @Override
        public void modelDeactivated(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(5);
            }
            if (LayoutlibSceneManager.this.myRenderingQueue != null) {
                LayoutlibSceneManager.this.myRenderingQueue.cancelAllUpdates();
            }
        }

        @Override
        public void modelLiveUpdate(@NotNull NlModel model, boolean animate) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(6);
            }
            LayoutlibSceneManager.this.layout(animate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "model";
            objectArray2[1] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager$ModelChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelDerivedDataChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelRendered";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChangedOnLayout";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelActivated";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelDeactivated";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelLiveUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

