/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.HashSet;
import java.util.Set;
import org.gradle.StartParameter;
import org.gradle.api.Incubating;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.SingleMessageLogger;

public class StartParameterInternal
extends StartParameter {
    private final Set<String> deprecations = new HashSet<String>();

    public StartParameter newInstance() {
        return this.prepareNewInstance(new StartParameterInternal());
    }

    public StartParameter newBuild() {
        return this.prepareNewBuild(new StartParameterInternal());
    }

    @Incubating
    public void addDeprecation(String deprecation) {
        this.deprecations.add(deprecation);
    }

    @Incubating
    public void checkDeprecation() {
        String suffix = SingleMessageLogger.getDeprecationMessage();
        for (String deprecation : this.deprecations) {
            DeprecationLogger.nagUserWith(String.format("%s %s.", deprecation, suffix));
        }
    }
}

