/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ModuleComponentSelectorSerializer
implements Serializer<ModuleComponentSelector> {
    @Override
    public ModuleComponentSelector read(Decoder decoder) throws IOException {
        String group = decoder.readString();
        String name = decoder.readString();
        VersionConstraint versionConstraint = this.readVersionConstraint(decoder);
        return DefaultModuleComponentSelector.newSelector(group, name, versionConstraint);
    }

    public VersionConstraint readVersionConstraint(Decoder decoder) throws IOException {
        String preferred = decoder.readString();
        int cpt = decoder.readSmallInt();
        ArrayList rejects = Lists.newArrayListWithCapacity((int)cpt);
        for (int i = 0; i < cpt; ++i) {
            rejects.add(decoder.readString());
        }
        return new DefaultImmutableVersionConstraint(preferred, rejects);
    }

    @Override
    public void write(Encoder encoder, ModuleComponentSelector value) throws IOException {
        encoder.writeString(value.getGroup());
        encoder.writeString(value.getModule());
        this.writeVersionConstraint(encoder, value.getVersionConstraint());
    }

    public void write(Encoder encoder, String group, String module, VersionConstraint version) throws IOException {
        encoder.writeString(group);
        encoder.writeString(module);
        this.writeVersionConstraint(encoder, version);
    }

    public void writeVersionConstraint(Encoder encoder, VersionConstraint cst) throws IOException {
        encoder.writeString(cst.getPreferredVersion());
        List<String> rejectedVersions = cst.getRejectedVersions();
        encoder.writeSmallInt(rejectedVersions.size());
        for (String rejectedVersion : rejectedVersions) {
            encoder.writeString(rejectedVersion);
        }
    }
}

