/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.DefaultLibraryComponentSelector;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class ComponentSelectorSerializer
extends AbstractSerializer<ComponentSelector> {
    @Override
    public ComponentSelector read(Decoder decoder) throws IOException {
        byte id = decoder.readByte();
        if (Implementation.BUILD.getId() == id) {
            return new DefaultProjectComponentSelector(decoder.readString(), decoder.readString());
        }
        if (Implementation.MODULE.getId() == id) {
            return DefaultModuleComponentSelector.newSelector(decoder.readString(), decoder.readString(), this.readVersionConstraint(decoder));
        }
        if (Implementation.LIBRARY.getId() == id) {
            return new DefaultLibraryComponentSelector(decoder.readString(), decoder.readNullableString(), decoder.readNullableString());
        }
        throw new IllegalArgumentException("Unable to find component selector with id: " + id);
    }

    ImmutableVersionConstraint readVersionConstraint(Decoder decoder) throws IOException {
        String prefers = decoder.readString();
        int rejectCount = decoder.readSmallInt();
        ArrayList rejects = Lists.newArrayListWithCapacity((int)rejectCount);
        for (int i = 0; i < rejectCount; ++i) {
            rejects.add(decoder.readString());
        }
        if (rejectCount > 1) {
            throw new UnsupportedOperationException("Multiple rejects are not yet supported");
        }
        return new DefaultImmutableVersionConstraint(prefers, rejects);
    }

    @Override
    public void write(Encoder encoder, ComponentSelector value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Provided component selector may not be null");
        }
        Implementation implementation = this.resolveImplementation(value);
        encoder.writeByte(implementation.getId());
        if (implementation == Implementation.MODULE) {
            ModuleComponentSelector moduleComponentSelector = (ModuleComponentSelector)value;
            encoder.writeString(moduleComponentSelector.getGroup());
            encoder.writeString(moduleComponentSelector.getModule());
            VersionConstraint versionConstraint = moduleComponentSelector.getVersionConstraint();
            this.writeVersionConstraint(encoder, versionConstraint);
        } else if (implementation == Implementation.BUILD) {
            ProjectComponentSelector projectComponentSelector = (ProjectComponentSelector)value;
            encoder.writeString(projectComponentSelector.getBuildName());
            encoder.writeString(projectComponentSelector.getProjectPath());
        } else if (implementation == Implementation.LIBRARY) {
            LibraryComponentSelector libraryComponentSelector = (LibraryComponentSelector)value;
            encoder.writeString(libraryComponentSelector.getProjectPath());
            encoder.writeNullableString(libraryComponentSelector.getLibraryName());
            encoder.writeNullableString(libraryComponentSelector.getVariant());
        } else {
            throw new IllegalStateException("Unsupported implementation type: " + (Object)((Object)implementation));
        }
    }

    private void writeVersionConstraint(Encoder encoder, VersionConstraint versionConstraint) throws IOException {
        encoder.writeString(versionConstraint.getPreferredVersion());
        List<String> rejectedVersions = versionConstraint.getRejectedVersions();
        encoder.writeSmallInt(rejectedVersions.size());
        for (String rejectedVersion : rejectedVersions) {
            encoder.writeString(rejectedVersion);
        }
    }

    private Implementation resolveImplementation(ComponentSelector value) {
        Implementation implementation;
        if (value instanceof ModuleComponentSelector) {
            implementation = Implementation.MODULE;
        } else if (value instanceof ProjectComponentSelector) {
            implementation = Implementation.BUILD;
        } else if (value instanceof LibraryComponentSelector) {
            implementation = Implementation.LIBRARY;
        } else {
            throw new IllegalArgumentException("Unsupported component selector class: " + value.getClass());
        }
        return implementation;
    }

    private static enum Implementation {
        MODULE(1),
        BUILD(2),
        LIBRARY(3),
        BINARY(4);

        private final byte id;

        private Implementation(byte id) {
            this.id = id;
        }

        byte getId() {
            return this.id;
        }
    }
}

