/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.api.internal.changedetection.state.isolation.Isolatable;
import org.gradle.api.internal.changedetection.state.isolation.IsolationException;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapValueSnapshot
implements ValueSnapshot,
Isolatable<Map> {
    private final ImmutableMap<ValueSnapshot, ValueSnapshot> entries;

    public MapValueSnapshot(ImmutableMap<ValueSnapshot, ValueSnapshot> entries) {
        this.entries = entries;
    }

    public ImmutableMap<ValueSnapshot, ValueSnapshot> getEntries() {
        return this.entries;
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher) {
        hasher.putString("Map");
        hasher.putInt(this.entries.size());
        for (Map.Entry entry : this.entries.entrySet()) {
            ((ValueSnapshot)entry.getKey()).appendToHasher(hasher);
            ((ValueSnapshot)entry.getValue()).appendToHasher(hasher);
        }
    }

    @Override
    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot newSnapshot = snapshotter.snapshot(value);
        if (this.equals(newSnapshot)) {
            return this;
        }
        return newSnapshot;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MapValueSnapshot other = (MapValueSnapshot)obj;
        return this.entries.equals(other.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    @Override
    public Map isolate() {
        LinkedHashMap map = new LinkedHashMap();
        for (Map.Entry entry : this.entries.entrySet()) {
            if (entry.getKey() instanceof Isolatable) {
                if (entry.getValue() instanceof Isolatable) {
                    map.put(((Isolatable)entry.getKey()).isolate(), ((Isolatable)entry.getValue()).isolate());
                    continue;
                }
                throw new IsolationException(entry.getValue());
            }
            throw new IsolationException(entry.getKey());
        }
        return map;
    }

    @Override
    @Nullable
    public <S> Isolatable<S> coerce(Class<S> type) {
        return null;
    }
}

