/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report;

import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.junit.result.TestFailure;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.internal.tasks.testing.report.ClassTestResults;
import org.gradle.api.internal.tasks.testing.report.PageRenderer;
import org.gradle.api.internal.tasks.testing.report.TestResult;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.html.SimpleHtmlWriter;
import org.gradle.reporting.CodePanelRenderer;
import org.gradle.util.GUtil;

class ClassPageRenderer
extends PageRenderer<ClassTestResults> {
    private final CodePanelRenderer codePanelRenderer = new CodePanelRenderer();
    private final TestResultsProvider resultsProvider;

    public ClassPageRenderer(TestResultsProvider provider) {
        this.resultsProvider = provider;
    }

    @Override
    protected void renderBreadcrumbs(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("div").attribute("class", "breadcrumbs").startElement("a").attribute("href", ((ClassTestResults)this.getResults()).getUrlTo(((ClassTestResults)this.getResults()).getParent().getParent())).characters("all").endElement().characters(" > ").startElement("a").attribute("href", ((ClassTestResults)this.getResults()).getUrlTo(((ClassTestResults)this.getResults()).getPackageResults())).characters(((ClassTestResults)this.getResults()).getPackageResults().getName()).endElement().characters(" > " + ((ClassTestResults)this.getResults()).getSimpleName()).endElement();
    }

    private void renderTests(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("table").startElement("thead").startElement("tr").startElement("th").characters("Test").endElement().startElement("th").characters("Duration").endElement().startElement("th").characters("Result").endElement().endElement().endElement();
        for (TestResult test : ((ClassTestResults)this.getResults()).getTestResults()) {
            htmlWriter.startElement("tr").startElement("td").attribute("class", test.getStatusClass()).characters(test.getName()).endElement().startElement("td").characters(test.getFormattedDuration()).endElement().startElement("td").attribute("class", test.getStatusClass()).characters(test.getFormattedResultType()).endElement().endElement();
        }
        htmlWriter.endElement();
    }

    @Override
    protected void renderFailures(SimpleHtmlWriter htmlWriter) throws IOException {
        for (TestResult test : ((ClassTestResults)this.getResults()).getFailures()) {
            htmlWriter.startElement("div").attribute("class", "test").startElement("a").attribute("name", test.getId().toString()).characters("").endElement().startElement("h3").attribute("class", test.getStatusClass()).characters(test.getName()).endElement();
            for (TestFailure failure : test.getFailures()) {
                String message = GUtil.isTrue(failure.getMessage()) && !failure.getStackTrace().contains(failure.getMessage()) ? failure.getMessage() + SystemProperties.getInstance().getLineSeparator() + SystemProperties.getInstance().getLineSeparator() + failure.getStackTrace() : failure.getStackTrace();
                this.codePanelRenderer.render(message, htmlWriter);
            }
            htmlWriter.endElement();
        }
    }

    @Override
    protected void registerTabs() {
        this.addFailuresTab();
        this.addTab("Tests", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

            @Override
            public void doExecute(SimpleHtmlWriter writer) throws IOException {
                ClassPageRenderer.this.renderTests(writer);
            }
        });
        final long classId = ((ClassTestResults)this.getModel()).getId();
        if (this.resultsProvider.hasOutput(classId, TestOutputEvent.Destination.StdOut)) {
            this.addTab("Standard output", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                @Override
                protected void doExecute(SimpleHtmlWriter htmlWriter) throws IOException {
                    htmlWriter.startElement("span").attribute("class", "code").startElement("pre").characters("");
                    ClassPageRenderer.this.resultsProvider.writeAllOutput(classId, TestOutputEvent.Destination.StdOut, htmlWriter);
                    htmlWriter.endElement().endElement();
                }
            });
        }
        if (this.resultsProvider.hasOutput(classId, TestOutputEvent.Destination.StdErr)) {
            this.addTab("Standard error", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                @Override
                protected void doExecute(SimpleHtmlWriter element) throws Exception {
                    element.startElement("span").attribute("class", "code").startElement("pre").characters("");
                    ClassPageRenderer.this.resultsProvider.writeAllOutput(classId, TestOutputEvent.Destination.StdErr, element);
                    element.endElement().endElement();
                }
            });
        }
    }
}

