/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.LanguageLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.ProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;

public class ScalaLibraryProjectInitDescriptor
extends LanguageLibraryProjectInitDescriptor {
    private final DocumentationRegistry documentationRegistry;

    public ScalaLibraryProjectInitDescriptor(TemplateOperationFactory templateOperationFactory, FileResolver fileResolver, TemplateLibraryVersionProvider libraryVersionProvider, ProjectInitDescriptor globalSettingsDescriptor, DocumentationRegistry documentationRegistry) {
        super("scala", templateOperationFactory, fileResolver, libraryVersionProvider, globalSettingsDescriptor);
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public void generate(BuildInitTestFramework testFramework) {
        this.globalSettingsDescriptor.generate(testFramework);
        String scalaVersion = this.libraryVersionProvider.getVersion("scala");
        String scalaLibraryVersion = this.libraryVersionProvider.getVersion("scala-library");
        String scalaTestVersion = this.libraryVersionProvider.getVersion("scalatest");
        String junitVersion = this.libraryVersionProvider.getVersion("junit");
        String scalaXmlVersion = this.libraryVersionProvider.getVersion("scala-xml");
        BuildScriptBuilder buildScriptBuilder = new BuildScriptBuilder(this.fileResolver.resolve("build.gradle")).fileComment("This generated file contains a sample Scala library project to get you started.").fileComment("For more details take a look at the Scala plugin chapter in the Gradle").fileComment("user guide available at " + this.documentationRegistry.getDocumentationFor("scala_plugin")).plugin("Apply the scala plugin to add support for Scala", "scala").compileDependency("Use Scala " + scalaVersion + " in our library project", "org.scala-lang:scala-library:" + scalaLibraryVersion).testCompileDependency("Use Scalatest for testing our library", "junit:junit:" + junitVersion, "org.scalatest:scalatest_" + scalaVersion + ":" + scalaTestVersion).testRuntimeDependency("Need scala-xml at test runtime", "org.scala-lang.modules:scala-xml_" + scalaVersion + ":" + scalaXmlVersion);
        buildScriptBuilder.create().generate();
        TemplateOperation scalaLibTemplateOperation = this.fromClazzTemplate("scalalibrary/Library.scala.template", "main");
        TemplateOperation scalaTestTemplateOperation = this.fromClazzTemplate("scalalibrary/LibrarySuite.scala.template", "test");
        this.whenNoSourcesAvailable(scalaLibTemplateOperation, scalaTestTemplateOperation).generate();
    }

    @Override
    public boolean supports(BuildInitTestFramework testFramework) {
        return false;
    }
}

