/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.configuration.BuildOperationScriptPlugin;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.scripts.ScriptingLanguages;
import org.gradle.scripts.ScriptingLanguage;

public class ScriptPluginFactorySelector
implements ScriptPluginFactory {
    private final ScriptPluginFactory defaultScriptPluginFactory;
    private final ScriptingLanguages scriptingLanguages;
    private final ProviderInstantiator providerInstantiator;
    private final BuildOperationExecutor buildOperationExecutor;

    public static ProviderInstantiator defaultProviderInstantiatorFor(final Instantiator instantiator) {
        return new ProviderInstantiator(){

            @Override
            public ScriptPluginFactory instantiate(String providerClassName) {
                Class<?> providerClass = this.loadProviderClass(providerClassName);
                return (ScriptPluginFactory)instantiator.newInstance(providerClass, new Object[0]);
            }

            private Class<?> loadProviderClass(String providerClassName) {
                try {
                    return this.getClass().getClassLoader().loadClass(providerClassName);
                }
                catch (ClassNotFoundException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
        };
    }

    public ScriptPluginFactorySelector(ScriptPluginFactory defaultScriptPluginFactory, ScriptingLanguages scriptingLanguages, ProviderInstantiator providerInstantiator, BuildOperationExecutor buildOperationExecutor) {
        this.defaultScriptPluginFactory = defaultScriptPluginFactory;
        this.scriptingLanguages = scriptingLanguages;
        this.providerInstantiator = providerInstantiator;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public ScriptPlugin create(ScriptSource scriptSource, ScriptHandler scriptHandler, ClassLoaderScope targetScope, ClassLoaderScope baseScope, boolean topLevelScript) {
        ScriptPlugin scriptPlugin = this.scriptPluginFactoryFor(scriptSource.getFileName()).create(scriptSource, scriptHandler, targetScope, baseScope, topLevelScript);
        return new BuildOperationScriptPlugin(scriptPlugin, this.buildOperationExecutor);
    }

    private ScriptPluginFactory scriptPluginFactoryFor(String fileName) {
        return fileName.endsWith(".gradle") ? this.defaultScriptPluginFactory : this.findScriptPluginFactoryFor(fileName);
    }

    private ScriptPluginFactory findScriptPluginFactoryFor(String fileName) {
        for (ScriptingLanguage scriptingLanguage : this.scriptingLanguages) {
            ScriptPluginFactory scriptPluginFactory;
            if (!fileName.endsWith(scriptingLanguage.getExtension()) || (scriptPluginFactory = this.scriptPluginFactoryFor(scriptingLanguage)) == null) continue;
            return scriptPluginFactory;
        }
        return this.defaultScriptPluginFactory;
    }

    private ScriptPluginFactory scriptPluginFactoryFor(ScriptingLanguage scriptingLanguage) {
        return this.providerInstantiator.instantiate(scriptingLanguage.getProvider());
    }

    public static interface ProviderInstantiator {
        public ScriptPluginFactory instantiate(String var1);
    }
}

