/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import groovy.lang.Closure;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionAdapter;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.execution.internal.ExecuteTaskBuildOperationDetails;
import org.gradle.api.execution.internal.ExecuteTaskBuildOperationResult;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.DefaultTaskExecutionContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskState;
import org.gradle.execution.TaskFailureHandler;
import org.gradle.execution.TaskGraphExecuter;
import org.gradle.execution.taskgraph.DefaultTaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.Factory;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.progress.BuildOperationCategory;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.progress.BuildOperationState;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskGraphExecuter
implements TaskGraphExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTaskGraphExecuter.class);
    private final TaskPlanExecutor taskPlanExecutor;
    private final Factory<? extends TaskExecuter> taskExecuter;
    private final ListenerBroadcast<TaskExecutionGraphListener> graphListeners;
    private final ListenerBroadcast<TaskExecutionListener> taskListeners;
    private final DefaultTaskExecutionPlan taskExecutionPlan;
    private final BuildOperationExecutor buildOperationExecutor;
    private TaskGraphState taskGraphState = TaskGraphState.EMPTY;
    private final Set<Task> requestedTasks = Sets.newTreeSet();
    private Spec<? super Task> filter = Specs.SATISFIES_ALL;

    public DefaultTaskGraphExecuter(ListenerManager listenerManager, TaskPlanExecutor taskPlanExecutor, Factory<? extends TaskExecuter> taskExecuter, BuildCancellationToken cancellationToken, BuildOperationExecutor buildOperationExecutor, WorkerLeaseService workerLeaseService, ResourceLockCoordinationService coordinationService, GradleInternal gradleInternal) {
        this.taskPlanExecutor = taskPlanExecutor;
        this.taskExecuter = taskExecuter;
        this.buildOperationExecutor = buildOperationExecutor;
        this.graphListeners = listenerManager.createAnonymousBroadcaster(TaskExecutionGraphListener.class);
        this.taskListeners = listenerManager.createAnonymousBroadcaster(TaskExecutionListener.class);
        this.taskExecutionPlan = new DefaultTaskExecutionPlan(cancellationToken, coordinationService, workerLeaseService, gradleInternal);
    }

    @Override
    public void useFailureHandler(TaskFailureHandler handler) {
        this.taskExecutionPlan.useFailureHandler(handler);
    }

    @Override
    public void useFilter(Spec<? super Task> filter) {
        this.filter = filter != null ? filter : Specs.SATISFIES_ALL;
        this.taskExecutionPlan.useFilter(this.filter);
        this.taskGraphState = TaskGraphState.DIRTY;
    }

    @Override
    public void addTasks(Iterable<? extends Task> tasks) {
        assert (tasks != null);
        Timer clock = Time.startTimer();
        LinkedHashSet<Task> taskSet = new LinkedHashSet<Task>();
        for (Task task : tasks) {
            taskSet.add(task);
            this.requestedTasks.add(task);
        }
        this.taskExecutionPlan.addToTaskGraph(taskSet);
        this.taskGraphState = TaskGraphState.DIRTY;
        LOGGER.debug("Timing: Creating the DAG took " + clock.getElapsed());
    }

    @Override
    public void populate() {
        this.ensurePopulated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Timer clock = Time.startTimer();
        this.ensurePopulated();
        this.graphListeners.getSource().graphPopulated(this);
        try {
            this.taskPlanExecutor.process(this.taskExecutionPlan, new EventFiringTaskWorker(this.taskExecuter.create(), this.buildOperationExecutor.getCurrentOperation()));
            LOGGER.debug("Timing: Executing the DAG took " + clock.getElapsed());
        }
        finally {
            this.taskExecutionPlan.clear();
        }
    }

    @Override
    public void addTaskExecutionGraphListener(TaskExecutionGraphListener listener) {
        this.graphListeners.add(listener);
    }

    @Override
    public void removeTaskExecutionGraphListener(TaskExecutionGraphListener listener) {
        this.graphListeners.remove(listener);
    }

    @Override
    public void whenReady(Closure closure) {
        this.graphListeners.add(new ClosureBackedMethodInvocationDispatch("graphPopulated", closure));
    }

    @Override
    public void whenReady(final Action<TaskExecutionGraph> action) {
        this.graphListeners.add(new TaskExecutionGraphListener(){

            public void graphPopulated(TaskExecutionGraph graph) {
                action.execute(graph);
            }
        });
    }

    @Override
    public void addTaskExecutionListener(TaskExecutionListener listener) {
        this.taskListeners.add(listener);
    }

    @Override
    public void removeTaskExecutionListener(TaskExecutionListener listener) {
        this.taskListeners.remove(listener);
    }

    @Override
    public void beforeTask(Closure closure) {
        this.taskListeners.add(new ClosureBackedMethodInvocationDispatch("beforeExecute", closure));
    }

    @Override
    public void beforeTask(final Action<Task> action) {
        this.taskListeners.add(new TaskExecutionAdapter(){

            public void beforeExecute(Task task) {
                action.execute(task);
            }
        });
    }

    @Override
    public void afterTask(Closure closure) {
        this.taskListeners.add(new ClosureBackedMethodInvocationDispatch("afterExecute", closure));
    }

    @Override
    public void afterTask(final Action<Task> action) {
        this.taskListeners.add(new TaskExecutionAdapter(){

            public void afterExecute(Task task, TaskState state) {
                action.execute(task);
            }
        });
    }

    @Override
    public boolean hasTask(Task task) {
        this.ensurePopulated();
        return this.taskExecutionPlan.getTasks().contains(task);
    }

    @Override
    public boolean hasTask(String path) {
        this.ensurePopulated();
        assert (path != null && path.length() > 0);
        for (Task task : this.taskExecutionPlan.getTasks()) {
            if (!task.getPath().equals(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Task> getAllTasks() {
        this.ensurePopulated();
        return this.taskExecutionPlan.getTasks();
    }

    private void ensurePopulated() {
        switch (this.taskGraphState) {
            case EMPTY: {
                throw new IllegalStateException("Task information is not available, as this task execution graph has not been populated.");
            }
            case DIRTY: {
                this.taskExecutionPlan.determineExecutionPlan();
                this.taskGraphState = TaskGraphState.POPULATED;
                return;
            }
        }
    }

    @Override
    public Set<Task> getRequestedTasks() {
        return this.requestedTasks;
    }

    @Override
    public Set<Task> getFilteredTasks() {
        return this.taskExecutionPlan.getFilteredTasks();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventFiringTaskWorker
    implements Action<TaskInternal> {
        private final TaskExecuter taskExecuter;
        private final BuildOperationState parentOperation;

        EventFiringTaskWorker(TaskExecuter taskExecuter, BuildOperationState parentOperation) {
            this.taskExecuter = taskExecuter;
            this.parentOperation = parentOperation;
        }

        @Override
        public void execute(final TaskInternal task) {
            DefaultTaskGraphExecuter.this.buildOperationExecutor.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext context) {
                    ((TaskExecutionListener)DefaultTaskGraphExecuter.this.taskListeners.getSource()).beforeExecute(task);
                    TaskStateInternal state = task.getState();
                    DefaultTaskExecutionContext ctx = new DefaultTaskExecutionContext();
                    EventFiringTaskWorker.this.taskExecuter.execute(task, state, ctx);
                    context.setResult(new ExecuteTaskBuildOperationResult(state, ctx));
                    ((TaskExecutionListener)DefaultTaskGraphExecuter.this.taskListeners.getSource()).afterExecute(task, state);
                    context.setStatus(state.getFailure() != null ? "FAILED" : state.getSkipMessage());
                    context.failed(state.getFailure());
                }

                public BuildOperationDescriptor.Builder description() {
                    ExecuteTaskBuildOperationDetails taskOperation = new ExecuteTaskBuildOperationDetails(task);
                    return BuildOperationDescriptor.displayName("Task " + task.getIdentityPath()).name(task.getIdentityPath().toString()).parent(EventFiringTaskWorker.this.parentOperation).operationType(BuildOperationCategory.TASK).details(taskOperation);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TaskGraphState {
        EMPTY,
        DIRTY,
        POPULATED;

    }
}

