/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.ide.visualstudio.VisualStudioExtension;
import org.gradle.ide.visualstudio.internal.VisualStudioExtensionInternal;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectRegistry;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.NativeBinarySpec;

public class VisualStudioProjectResolver {
    private final ProjectModelResolver projectModelResolver;

    public VisualStudioProjectResolver(ProjectModelResolver projectModelResolver) {
        this.projectModelResolver = projectModelResolver;
    }

    public VisualStudioProjectConfiguration lookupProjectConfiguration(NativeBinarySpec nativeBinary) {
        VisualStudioExtension visualStudioExtension = this.getComponentModel(nativeBinary).realize("visualStudio", VisualStudioExtension.class);
        VisualStudioProjectRegistry projectRegistry = ((VisualStudioExtensionInternal)visualStudioExtension).getProjectRegistry();
        return projectRegistry.getProjectConfiguration(nativeBinary);
    }

    private ModelRegistry getComponentModel(NativeBinarySpec nativeBinary) {
        String projectPath = nativeBinary.getComponent().getProjectPath();
        return this.projectModelResolver.resolveProjectModel(projectPath);
    }
}

