/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectLocalComponentProvider;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.ide.xcode.XcodeExtension;
import org.gradle.ide.xcode.XcodeProject;
import org.gradle.ide.xcode.internal.DefaultXcodeExtension;
import org.gradle.ide.xcode.internal.DefaultXcodeProject;
import org.gradle.ide.xcode.internal.XcodeTarget;
import org.gradle.ide.xcode.internal.xcodeproj.FileTypes;
import org.gradle.ide.xcode.internal.xcodeproj.GidGenerator;
import org.gradle.ide.xcode.internal.xcodeproj.PBXTarget;
import org.gradle.ide.xcode.tasks.GenerateSchemeFileTask;
import org.gradle.ide.xcode.tasks.GenerateWorkspaceSettingsFileTask;
import org.gradle.ide.xcode.tasks.GenerateXcodeProjectFileTask;
import org.gradle.ide.xcode.tasks.GenerateXcodeWorkspaceFileTask;
import org.gradle.initialization.ProjectPathRegistry;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.cpp.plugins.CppExecutablePlugin;
import org.gradle.language.cpp.plugins.CppLibraryPlugin;
import org.gradle.language.swift.SwiftComponent;
import org.gradle.language.swift.plugins.SwiftExecutablePlugin;
import org.gradle.language.swift.plugins.SwiftLibraryPlugin;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.plugins.XCTestConventionPlugin;
import org.gradle.plugins.ide.internal.IdePlugin;
import org.gradle.util.CollectionUtils;
import org.gradle.util.Path;

@Incubating
public class XcodePlugin
extends IdePlugin {
    private final GidGenerator gidGenerator;
    private final ObjectFactory objectFactory;
    private DefaultXcodeExtension xcode;

    @Inject
    public XcodePlugin(GidGenerator gidGenerator, ObjectFactory objectFactory) {
        this.gidGenerator = gidGenerator;
        this.objectFactory = objectFactory;
    }

    @Override
    protected String getLifecycleTaskName() {
        return "xcode";
    }

    @Override
    protected void onApply(Project project) {
        Task lifecycleTask = this.getLifecycleTask();
        lifecycleTask.setDescription("Generates XCode project files (pbxproj, xcworkspace, xcscheme)");
        this.xcode = project.getExtensions().create(XcodeExtension.class, "xcode", DefaultXcodeExtension.class, this.objectFactory);
        this.xcode.getProject().setLocationDir(project.file(project.getName() + ".xcodeproj"));
        if (XcodePlugin.isRoot(project)) {
            GenerateXcodeWorkspaceFileTask workspaceTask = this.createWorkspaceTask(project);
            this.addIncludedBuildToWorkspace(project, workspaceTask);
            lifecycleTask.dependsOn(workspaceTask);
        }
        GenerateXcodeProjectFileTask projectTask = this.createProjectTask(project);
        lifecycleTask.dependsOn(projectTask);
        projectTask.dependsOn(project.getTasks().withType(GenerateSchemeFileTask.class));
        project.getTasks().addRule("Xcode bridge tasks begin with _xcode. Do not call these directly.", new XcodeBridge(this.xcode.getProject(), project));
        this.configureForSwiftPlugin(project);
        this.configureForCppPlugin(project);
        this.includeBuildFilesInProject(project);
        this.configureXcodeCleanTask(project);
        this.registerXcodeProjectArtifact(project, projectTask);
    }

    private void includeBuildFilesInProject(Project project) {
        if (project.getBuildFile().exists()) {
            this.xcode.getProject().getGroups().getRoot().from(project.getBuildFile());
        }
    }

    private void configureXcodeCleanTask(Project project) {
        this.getCleanTask().setDescription("Cleans XCode project files (xcodeproj)");
        Delete cleanTask = project.getTasks().create("cleanXcodeProject", Delete.class);
        cleanTask.delete(this.xcode.getProject().getLocationDir());
        if (XcodePlugin.isRoot(project)) {
            cleanTask.delete(XcodePlugin.toXcodeWorkspacePackageDir(project));
        }
        this.getCleanTask().dependsOn(cleanTask);
    }

    private GenerateXcodeProjectFileTask createProjectTask(Project project) {
        File xcodeProjectPackageDir = this.xcode.getProject().getLocationDir();
        GenerateWorkspaceSettingsFileTask workspaceSettingsFileTask = project.getTasks().create("xcodeProjectWorkspaceSettings", GenerateWorkspaceSettingsFileTask.class);
        workspaceSettingsFileTask.setOutputFile(new File(xcodeProjectPackageDir, "project.xcworkspace/xcshareddata/WorkspaceSettings.xcsettings"));
        GenerateXcodeProjectFileTask projectFileTask = project.getTasks().create("xcodeProject", GenerateXcodeProjectFileTask.class);
        projectFileTask.dependsOn(workspaceSettingsFileTask);
        projectFileTask.setXcodeProject(this.xcode.getProject());
        projectFileTask.setOutputFile(new File(xcodeProjectPackageDir, "project.pbxproj"));
        return projectFileTask;
    }

    private GenerateXcodeWorkspaceFileTask createWorkspaceTask(Project project) {
        File xcodeWorkspacePackageDir = XcodePlugin.toXcodeWorkspacePackageDir(project);
        GenerateWorkspaceSettingsFileTask workspaceSettingsFileTask = project.getTasks().create("xcodeWorkspaceWorkspaceSettings", GenerateWorkspaceSettingsFileTask.class);
        workspaceSettingsFileTask.setOutputFile(new File(xcodeWorkspacePackageDir, "xcshareddata/WorkspaceSettings.xcsettings"));
        GenerateXcodeWorkspaceFileTask workspaceFileTask = project.getTasks().create("xcodeWorkspace", GenerateXcodeWorkspaceFileTask.class);
        workspaceFileTask.dependsOn(workspaceSettingsFileTask);
        workspaceFileTask.setOutputFile(new File(xcodeWorkspacePackageDir, "contents.xcworkspacedata"));
        return workspaceFileTask;
    }

    private String getBridgeTaskPath(Project project) {
        String projectPath = "";
        if (!XcodePlugin.isRoot(project)) {
            projectPath = project.getPath();
        }
        return projectPath + ":_xcode__${ACTION}_${PRODUCT_NAME}_${CONFIGURATION}";
    }

    private void configureForSwiftPlugin(final Project project) {
        project.getPlugins().withType(SwiftExecutablePlugin.class, new Action<SwiftExecutablePlugin>(){

            @Override
            public void execute(SwiftExecutablePlugin plugin) {
                XcodePlugin.this.configureXcodeForSwift(project, PBXTarget.ProductType.TOOL);
            }
        });
        project.getPlugins().withType(SwiftLibraryPlugin.class, new Action<SwiftLibraryPlugin>(){

            @Override
            public void execute(SwiftLibraryPlugin plugin) {
                XcodePlugin.this.configureXcodeForSwift(project, PBXTarget.ProductType.DYNAMIC_LIBRARY);
            }
        });
        project.getPlugins().withType(XCTestConventionPlugin.class, new Action<XCTestConventionPlugin>(){

            @Override
            public void execute(XCTestConventionPlugin plugin) {
                XcodePlugin.this.configureXcodeForXCTest(project, PBXTarget.ProductType.UNIT_TEST);
            }
        });
    }

    private void configureXcodeForXCTest(Project project, PBXTarget.ProductType productType) {
        SwiftXCTestSuite component = project.getExtensions().getByType(SwiftXCTestSuite.class);
        FileCollection sources = component.getSwiftSource();
        this.xcode.getProject().getGroups().getTests().from(sources);
        String targetName = (String)component.getModule().get() + " " + XcodePlugin.toString(productType);
        XcodeTarget target = this.newTarget(targetName, (String)component.getModule().get(), productType, XcodePlugin.toGradleCommand(project.getRootProject()), this.getBridgeTaskPath(project), component.getDevelopmentBinary().getInstallDirectory(), component.getDevelopmentBinary().getInstallDirectory(), sources);
        target.getCompileModules().from(component.getDevelopmentBinary().getCompileModules());
        this.xcode.getProject().addTarget(target);
    }

    private void configureXcodeForSwift(Project project, PBXTarget.ProductType productType) {
        SwiftComponent component = (SwiftComponent)project.getComponents().withType(SwiftComponent.class).getByName("main");
        FileCollection sources = component.getSwiftSource();
        this.xcode.getProject().getGroups().getSources().from(sources);
        AbstractLinkTask linkDebug = (AbstractLinkTask)project.getTasks().getByName("linkDebug");
        AbstractLinkTask linkRelease = (AbstractLinkTask)project.getTasks().getByName("linkRelease");
        String targetName = (String)component.getModule().get() + " " + XcodePlugin.toString(productType);
        XcodeTarget target = this.newTarget(targetName, (String)component.getModule().get(), productType, XcodePlugin.toGradleCommand(project.getRootProject()), this.getBridgeTaskPath(project), linkDebug.getBinaryFile(), linkRelease.getBinaryFile(), sources);
        target.getCompileModules().from(component.getDevelopmentBinary().getCompileModules());
        this.xcode.getProject().addTarget(target);
        XcodePlugin.createSchemeTask(project.getTasks(), targetName, this.xcode.getProject());
    }

    private void configureForCppPlugin(final Project project) {
        project.getPlugins().withType(CppExecutablePlugin.class, new Action<CppExecutablePlugin>(){

            @Override
            public void execute(CppExecutablePlugin plugin) {
                XcodePlugin.this.configureXcodeForCpp(project, PBXTarget.ProductType.TOOL);
            }
        });
        project.getPlugins().withType(CppLibraryPlugin.class, new Action<CppLibraryPlugin>(){

            @Override
            public void execute(CppLibraryPlugin plugin) {
                XcodePlugin.this.configureXcodeForCpp(project, PBXTarget.ProductType.DYNAMIC_LIBRARY);
            }
        });
    }

    private void configureXcodeForCpp(Project project, PBXTarget.ProductType productType) {
        CppComponent component = (CppComponent)project.getComponents().withType(CppComponent.class).getByName("main");
        FileCollection sources = component.getCppSource();
        this.xcode.getProject().getGroups().getSources().from(sources);
        FileTree headers = component.getHeaderFiles();
        this.xcode.getProject().getGroups().getHeaders().from(headers);
        AbstractLinkTask linkDebug = (AbstractLinkTask)project.getTasks().getByName("linkDebug");
        AbstractLinkTask linkRelease = (AbstractLinkTask)project.getTasks().getByName("linkRelease");
        String targetName = StringUtils.capitalize((String)project.getName());
        XcodeTarget target = this.newTarget(targetName + " " + XcodePlugin.toString(productType), targetName, productType, XcodePlugin.toGradleCommand(project.getRootProject()), this.getBridgeTaskPath(project), linkDebug.getBinaryFile(), linkRelease.getBinaryFile(), sources);
        target.getHeaderSearchPaths().from(component.getDevelopmentBinary().getCompileIncludePath());
        this.xcode.getProject().addTarget(target);
        XcodePlugin.createSchemeTask(project.getTasks(), targetName + " " + XcodePlugin.toString(productType), this.xcode.getProject());
    }

    private static GenerateSchemeFileTask createSchemeTask(TaskContainer tasks, String schemeName, DefaultXcodeProject xcodeProject) {
        String name = "xcodeScheme" + schemeName.replaceAll(" ", "");
        GenerateSchemeFileTask schemeFileTask = tasks.maybeCreate(name, GenerateSchemeFileTask.class);
        schemeFileTask.setXcodeProject(xcodeProject);
        schemeFileTask.setOutputFile(new File(xcodeProject.getLocationDir(), "xcshareddata/xcschemes/" + schemeName + ".xcscheme"));
        return schemeFileTask;
    }

    private static String toGradleCommand(Project project) {
        Gradle gradle = project.getGradle();
        Optional gradleWrapperPath = Optional.absent();
        if (project.file("gradlew").exists()) {
            gradleWrapperPath = Optional.of((Object)project.file("gradlew").getAbsolutePath());
        }
        if (gradle.getGradleHomeDir() != null) {
            if (gradleWrapperPath.isPresent() && gradle.getGradleHomeDir().getAbsolutePath().startsWith(gradle.getGradleUserHomeDir().getAbsolutePath())) {
                return (String)gradleWrapperPath.get();
            }
            return gradle.getGradleHomeDir().getAbsolutePath() + "/bin/gradle";
        }
        return (String)gradleWrapperPath.or((Object)"gradle");
    }

    private XcodeTarget newTarget(String name, String productName, PBXTarget.ProductType productType, String gradleCommand, String taskName, Provider<? extends FileSystemLocation> debugBinaryFile, Provider<? extends FileSystemLocation> releaseBinaryFile, FileCollection sources) {
        String id = this.gidGenerator.generateGid("PBXLegacyTarget", name.hashCode());
        XcodeTarget target = this.objectFactory.newInstance(XcodeTarget.class, name, id, debugBinaryFile, releaseBinaryFile);
        target.setTaskName(taskName);
        target.setGradleCommand(gradleCommand);
        target.setOutputFileType(XcodePlugin.toFileType(productType));
        target.setProductType(productType);
        target.setProductName(productName);
        target.getSources().setFrom(sources);
        return target;
    }

    private static File toXcodeWorkspacePackageDir(Project project) {
        return project.file(project.getName() + ".xcworkspace");
    }

    private static String toString(PBXTarget.ProductType productType) {
        if (PBXTarget.ProductType.TOOL.equals((Object)productType)) {
            return "Executable";
        }
        if (PBXTarget.ProductType.DYNAMIC_LIBRARY.equals((Object)productType)) {
            return "SharedLibrary";
        }
        if (PBXTarget.ProductType.UNIT_TEST.equals((Object)productType)) {
            return "XCTestBundle";
        }
        return "";
    }

    private static String toFileType(PBXTarget.ProductType productType) {
        if (PBXTarget.ProductType.TOOL.equals((Object)productType)) {
            return FileTypes.MACH_O_EXECUTABLE.identifier;
        }
        if (PBXTarget.ProductType.DYNAMIC_LIBRARY.equals((Object)productType)) {
            return FileTypes.MACH_O_DYNAMIC_LIBRARY.identifier;
        }
        return "compiled";
    }

    private static boolean isRoot(Project project) {
        return project.getParent() == null;
    }

    private static XcodeExtension xcodeModelFor(Project project) {
        return project.getExtensions().getByType(XcodeExtension.class);
    }

    private void registerXcodeProjectArtifact(Project project, GenerateXcodeProjectFileTask projectTask) {
        ProjectLocalComponentProvider projectComponentProvider = ((ProjectInternal)project).getServices().get(ProjectLocalComponentProvider.class);
        ProjectComponentIdentifier projectId = DefaultProjectComponentIdentifier.newProjectId(project);
        projectComponentProvider.registerAdditionalArtifact(projectId, XcodePlugin.createXcodeProjectArtifact(projectId, XcodePlugin.xcodeModelFor(project), projectTask));
    }

    private static LocalComponentArtifactMetadata createXcodeProjectArtifact(ProjectComponentIdentifier projectId, XcodeExtension xcode, Task projectTask) {
        XcodeProject xcodeProject = xcode.getProject();
        XcodeProjectArtifact publishArtifact = new XcodeProjectArtifact(xcodeProject, projectTask);
        return new PublishArtifactLocalArtifactMetadata(projectId, publishArtifact);
    }

    private void addIncludedBuildToWorkspace(Project project, GenerateXcodeWorkspaceFileTask workspaceTask) {
        final ServiceRegistry serviceRegistry = ((ProjectInternal)project).getServices();
        workspaceTask.dependsOn(new Callable<List<TaskDependency>>(){

            @Override
            public List<TaskDependency> call() throws Exception {
                return CollectionUtils.collect(XcodePlugin.allXcodeprojArtifactsInComposite(serviceRegistry), new Transformer<TaskDependency, LocalComponentArtifactMetadata>(){

                    @Override
                    public TaskDependency transform(LocalComponentArtifactMetadata metadata) {
                        return metadata.getBuildDependencies();
                    }
                });
            }
        });
        workspaceTask.setXcodeProjectLocations(project.files(new Callable<Iterable<File>>(){

            @Override
            public Iterable<File> call() throws Exception {
                return CollectionUtils.collect(XcodePlugin.allXcodeprojArtifactsInComposite(serviceRegistry), new Transformer<File, LocalComponentArtifactMetadata>(){

                    @Override
                    public File transform(LocalComponentArtifactMetadata metadata) {
                        return metadata.getFile();
                    }
                });
            }
        }));
    }

    private static List<LocalComponentArtifactMetadata> allXcodeprojArtifactsInComposite(ServiceRegistry serviceRegistry) {
        ArrayList artifactMetadata = Lists.newArrayList();
        ProjectPathRegistry projectPathRegistry = serviceRegistry.get(ProjectPathRegistry.class);
        LocalComponentRegistry localComponentRegistry = serviceRegistry.get(LocalComponentRegistry.class);
        for (Path projectPath : projectPathRegistry.getAllProjectPaths()) {
            ProjectComponentIdentifier projectId = projectPathRegistry.getProjectComponentIdentifier(projectPath);
            LocalComponentArtifactMetadata xcodeprojArtifact = localComponentRegistry.findAdditionalArtifact(projectId, "xcodeproj");
            if (xcodeprojArtifact == null) continue;
            artifactMetadata.add(xcodeprojArtifact);
        }
        return artifactMetadata;
    }

    private static class XcodeBridge
    implements Action<String> {
        private final DefaultXcodeProject xcodeProject;
        private final Project project;

        public XcodeBridge(DefaultXcodeProject xcodeProject, Project project) {
            this.xcodeProject = xcodeProject;
            this.project = project;
        }

        @Override
        public void execute(String taskName) {
            if (taskName.startsWith("_xcode")) {
                Task bridgeTask = this.project.getTasks().create(taskName);
                String action = System.getenv("ACTION");
                if (action.equals("clean")) {
                    bridgeTask.dependsOn("clean");
                } else if ("".equals(action) || "build".equals(action)) {
                    XcodeTarget target = this.findXcodeTarget();
                    if (target.isUnitTest()) {
                        this.bridgeTestExecution(bridgeTask, target);
                    } else {
                        this.bridgeProductBuild(bridgeTask, target);
                    }
                } else {
                    throw new GradleException("Unrecognized bridge action from Xcode '" + action + "'");
                }
            }
        }

        private XcodeTarget findXcodeTarget() {
            final String productName = System.getenv("PRODUCT_NAME");
            XcodeTarget target = CollectionUtils.findFirst(this.xcodeProject.getTargets(), new Spec<XcodeTarget>(){

                @Override
                public boolean isSatisfiedBy(XcodeTarget target) {
                    return target.getProductName().equals(productName);
                }
            });
            if (target == null) {
                throw new GradleException("Unknown Xcode target '" + productName + "', do you need to re-generate Xcode configuration?");
            }
            return target;
        }

        private void bridgeProductBuild(Task bridgeTask, XcodeTarget target) {
            String configuration = System.getenv("CONFIGURATION");
            if (configuration.equals("Debug")) {
                bridgeTask.dependsOn(target.getDebugOutputFile());
            } else {
                bridgeTask.dependsOn(target.getReleaseOutputFile());
            }
        }

        private void bridgeTestExecution(Task bridgeTask, final XcodeTarget target) {
            final String builtProductsPath = System.getenv("BUILT_PRODUCTS_DIR");
            Sync syncTask = this.project.getTasks().create("syncBundleToXcodeBuiltProductDir", Sync.class, new Action<Sync>(){

                @Override
                public void execute(Sync task) {
                    task.from(target.getDebugOutputFile());
                    task.into(builtProductsPath);
                }
            });
            bridgeTask.dependsOn(syncTask);
        }
    }

    private static class XcodeProjectArtifact
    extends DefaultPublishArtifact {
        private final DefaultXcodeProject xcodeProject;

        public XcodeProjectArtifact(XcodeProject xcodeProject, Object ... tasks) {
            super(null, "xcodeproj", "xcodeproj", null, null, null, tasks);
            this.xcodeProject = (DefaultXcodeProject)xcodeProject;
        }

        @Override
        public String getName() {
            String fileName = this.xcodeProject.getLocationDir().getName();
            return fileName.substring(0, fileName.length() - ".xcodeproj".length());
        }

        @Override
        public File getFile() {
            return this.xcodeProject.getLocationDir();
        }
    }
}

