/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.List;
import java.util.Set;
import org.gradle.initialization.GradleApiSpecProvider;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.service.DefaultServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GradleApiSpecAggregator {
    private final ClassLoader classLoader;

    public GradleApiSpecAggregator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public GradleApiSpecProvider.Spec aggregate() {
        List<Class<? extends GradleApiSpecProvider>> providers = this.providers();
        if (providers.isEmpty()) {
            return this.emptySpec();
        }
        if (providers.size() == 1) {
            return this.specFrom(providers.get(0));
        }
        return this.mergeSpecsOf(providers);
    }

    private GradleApiSpecProvider.SpecAdapter emptySpec() {
        return new GradleApiSpecProvider.SpecAdapter();
    }

    private GradleApiSpecProvider.Spec specFrom(Class<? extends GradleApiSpecProvider> provider) {
        return this.instantiate(provider).get();
    }

    private GradleApiSpecProvider.Spec mergeSpecsOf(List<Class<? extends GradleApiSpecProvider>> providers) {
        ImmutableSet.Builder exportedPackages = ImmutableSet.builder();
        ImmutableSet.Builder exportedResourcePrefixes = ImmutableSet.builder();
        for (Class<? extends GradleApiSpecProvider> provider : providers) {
            GradleApiSpecProvider.Spec spec = this.specFrom(provider);
            exportedPackages.addAll(spec.getExportedPackages());
            exportedResourcePrefixes.addAll(spec.getExportedResourcePrefixes());
        }
        return new DefaultSpec((ImmutableSet<String>)exportedPackages.build(), (ImmutableSet<String>)exportedResourcePrefixes.build());
    }

    private List<Class<? extends GradleApiSpecProvider>> providers() {
        return new DefaultServiceLocator(this.classLoader).implementationsOf(GradleApiSpecProvider.class);
    }

    private GradleApiSpecProvider instantiate(Class<? extends GradleApiSpecProvider> providerClass) {
        return DirectInstantiator.INSTANCE.newInstance(providerClass, new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultSpec
    implements GradleApiSpecProvider.Spec {
        private final ImmutableSet<String> exportedPackages;
        private final ImmutableSet<String> exportedResourcePrefixes;

        DefaultSpec(ImmutableSet<String> exportedPackages, ImmutableSet<String> exportedResourcePrefixes) {
            this.exportedPackages = exportedPackages;
            this.exportedResourcePrefixes = exportedResourcePrefixes;
        }

        @Override
        public Set<String> getExportedPackages() {
            return this.exportedPackages;
        }

        @Override
        public Set<String> getExportedResourcePrefixes() {
            return this.exportedResourcePrefixes;
        }
    }
}

