/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.tasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.changedetection.changes.IncrementalTaskInputsInternal;
import org.gradle.api.internal.changedetection.state.FileSystemSnapshotter;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.cache.PersistentStateCache;
import org.gradle.internal.impldep.com.google.common.base.Charsets;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.CompilationStateCacheFactory;
import org.gradle.language.nativeplatform.internal.incremental.DefaultHeaderDependenciesCollector;
import org.gradle.language.nativeplatform.internal.incremental.DefaultSourceIncludesParser;
import org.gradle.language.nativeplatform.internal.incremental.DefaultSourceIncludesResolver;
import org.gradle.language.nativeplatform.internal.incremental.HeaderDependenciesCollector;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilation;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompileFilesFactory;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompileProcessor;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.CSourceParser;

@NonNullApi
@Incubating
public class Depend
extends DefaultTask {
    private final ConfigurableFileCollection includes;
    private final ConfigurableFileCollection source;
    private final HeaderDependenciesCollector headerDependenciesCollector;
    private ImmutableList<String> includePaths;
    private Property<Boolean> importsAreIncludes;
    private final RegularFileProperty headerDependenciesFile;
    private CSourceParser sourceParser;
    private final FileSystemSnapshotter fileSystemSnapshotter;
    private final CompilationStateCacheFactory compilationStateCacheFactory;

    @Inject
    public Depend(FileSystemSnapshotter fileSystemSnapshotter, CompilationStateCacheFactory compilationStateCacheFactory, DirectoryFileTreeFactory directoryFileTreeFactory, CSourceParser sourceParser) {
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        this.compilationStateCacheFactory = compilationStateCacheFactory;
        this.includes = this.getProject().files(new Object[0]);
        this.source = this.getProject().files(new Object[0]);
        this.sourceParser = sourceParser;
        this.headerDependenciesFile = this.newOutputFile();
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.importsAreIncludes = objectFactory.property(Boolean.class);
        this.headerDependenciesCollector = new DefaultHeaderDependenciesCollector(directoryFileTreeFactory);
        this.dependsOn(this.includes);
    }

    @TaskAction
    public void detectHeaders(IncrementalTaskInputs incrementalTaskInputs) throws IOException {
        IncrementalTaskInputsInternal inputs = (IncrementalTaskInputsInternal)incrementalTaskInputs;
        ImmutableList includeRoots = ImmutableList.copyOf((Iterable)this.includes);
        PersistentStateCache<CompilationState> compileStateCache = this.compilationStateCacheFactory.create(this.getPath());
        IncrementalCompileProcessor incrementalCompileProcessor = this.createIncrementalCompileProcessor((List<File>)includeRoots, compileStateCache);
        IncrementalCompilation incrementalCompilation = incrementalCompileProcessor.processSourceFiles(this.source.getFiles());
        ImmutableSortedSet<File> headerDependencies = this.headerDependenciesCollector.collectHeaderDependencies(this.getPath(), (List<File>)includeRoots, incrementalCompilation);
        ImmutableSortedSet<File> existingHeaderDependencies = this.headerDependenciesCollector.collectExistingHeaderDependencies(this.getPath(), (List<File>)includeRoots, incrementalCompilation);
        compileStateCache.set(incrementalCompilation.getFinalState());
        inputs.newInputs((Collection<File>)headerDependencies);
        this.writeHeaderDependenciesFile(existingHeaderDependencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeaderDependenciesFile(ImmutableSortedSet<File> headerDependencies) throws IOException {
        File outputFile = this.getHeaderDependenciesFile().getAsFile().get();
        BufferedWriter outputStreamWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), Charsets.UTF_8));
        try {
            for (File header : headerDependencies) {
                outputStreamWriter.write(header.getAbsolutePath());
                outputStreamWriter.newLine();
            }
        }
        finally {
            IOUtils.closeQuietly((Writer)outputStreamWriter);
        }
    }

    private IncrementalCompileProcessor createIncrementalCompileProcessor(List<File> includeRoots, PersistentStateCache<CompilationState> compileStateCache) {
        DefaultSourceIncludesParser sourceIncludesParser = new DefaultSourceIncludesParser(this.sourceParser, this.importsAreIncludes.getOrElse(false));
        DefaultSourceIncludesResolver dependencyParser = new DefaultSourceIncludesResolver(includeRoots);
        IncrementalCompileFilesFactory incrementalCompileFilesFactory = new IncrementalCompileFilesFactory(sourceIncludesParser, dependencyParser, this.fileSystemSnapshotter);
        return new IncrementalCompileProcessor(compileStateCache, incrementalCompileFilesFactory);
    }

    @Input
    protected Collection<String> getIncludePaths() {
        if (this.includePaths == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            Set<File> roots = this.includes.getFiles();
            for (File root : roots) {
                builder.add((Object)root.getAbsolutePath());
            }
            this.includePaths = builder.build();
        }
        return this.includePaths;
    }

    @Internal(value="tracked through getIncludePaths()")
    public ConfigurableFileCollection getIncludes() {
        return this.includes;
    }

    public void includes(Object includeRoots) {
        this.includes.from(includeRoots);
    }

    @InputFiles
    @SkipWhenEmpty
    public ConfigurableFileCollection getSource() {
        return this.source;
    }

    public void source(Object sourceFiles) {
        this.source.from(sourceFiles);
    }

    @OutputFile
    public RegularFileProperty getHeaderDependenciesFile() {
        return this.headerDependenciesFile;
    }

    @Input
    public Property<Boolean> getImportsAreIncludes() {
        return this.importsAreIncludes;
    }
}

