/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.scala.tasks;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.compile.AnnotationProcessorDetector;
import org.gradle.api.internal.tasks.compile.CompilerForkUtils;
import org.gradle.api.internal.tasks.scala.DefaultScalaJavaJointCompileSpec;
import org.gradle.api.internal.tasks.scala.DefaultScalaJavaJointCompileSpecFactory;
import org.gradle.api.internal.tasks.scala.ScalaCompileSpec;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.scala.tasks.BaseScalaCompileOptions;

@Incubating
public abstract class AbstractScalaCompile
extends AbstractCompile {
    protected static final Logger LOGGER = Logging.getLogger(AbstractScalaCompile.class);
    private final BaseScalaCompileOptions scalaCompileOptions;
    private final CompileOptions compileOptions;

    protected AbstractScalaCompile(BaseScalaCompileOptions scalaCompileOptions) {
        CompileOptions compileOptions;
        this.compileOptions = compileOptions = this.getServices().get(ObjectFactory.class).newInstance(CompileOptions.class, new Object[0]);
        this.scalaCompileOptions = scalaCompileOptions;
        CompilerForkUtils.doNotCacheIfForkingViaExecutable(compileOptions, this.getOutputs());
    }

    @Nested
    public BaseScalaCompileOptions getScalaCompileOptions() {
        return this.scalaCompileOptions;
    }

    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    protected abstract Compiler<ScalaJavaJointCompileSpec> getCompiler(ScalaJavaJointCompileSpec var1);

    @Override
    @TaskAction
    protected void compile() {
        ScalaJavaJointCompileSpec spec = this.createSpec();
        this.configureIncrementalCompilation(spec);
        this.getCompiler(spec).execute(spec);
    }

    protected ScalaJavaJointCompileSpec createSpec() {
        DefaultScalaJavaJointCompileSpec spec = (DefaultScalaJavaJointCompileSpec)new DefaultScalaJavaJointCompileSpecFactory(this.compileOptions).create();
        spec.setSource(this.getSource());
        spec.setDestinationDir(this.getDestinationDir());
        spec.setWorkingDir(this.getProject().getProjectDir());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath((List<File>)ImmutableList.copyOf((Iterable)this.getClasspath()));
        spec.setSourceCompatibility(this.getSourceCompatibility());
        spec.setTargetCompatibility(this.getTargetCompatibility());
        spec.setCompileOptions(this.getOptions());
        spec.setScalaCompileOptions(this.scalaCompileOptions);
        spec.setAnnotationProcessorPath((List<File>)ImmutableList.copyOf((Iterable)this.getEffectiveAnnotationProcessorPath()));
        return spec;
    }

    protected void configureIncrementalCompilation(ScalaCompileSpec spec) {
        Map<File, File> globalAnalysisMap = this.createOrGetGlobalAnalysisMap();
        HashMap<File, File> filteredMap = this.filterForClasspath(globalAnalysisMap, spec.getCompileClasspath());
        spec.setAnalysisMap(filteredMap);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Analysis file: {}", this.scalaCompileOptions.getIncrementalOptions().getAnalysisFile());
            LOGGER.debug("Published code: {}", this.scalaCompileOptions.getIncrementalOptions().getPublishedCode());
            LOGGER.debug("Analysis map: {}", filteredMap);
        }
    }

    protected Map<File, File> createOrGetGlobalAnalysisMap() {
        Map<File, File> analysisMap;
        ExtraPropertiesExtension extraProperties = this.getProject().getRootProject().getExtensions().getExtraProperties();
        if (extraProperties.has("scalaCompileAnalysisMap")) {
            analysisMap = (Map)extraProperties.get("scalaCompileAnalysisMap");
        } else {
            analysisMap = Maps.newHashMap();
            for (Project project : this.getProject().getRootProject().getAllprojects()) {
                for (AbstractScalaCompile task : project.getTasks().withType(AbstractScalaCompile.class)) {
                    File publishedCode = task.getScalaCompileOptions().getIncrementalOptions().getPublishedCode();
                    File analysisFile = task.getScalaCompileOptions().getIncrementalOptions().getAnalysisFile();
                    analysisMap.put(publishedCode, analysisFile);
                }
            }
            extraProperties.set("scalaCompileAnalysisMap", Collections.unmodifiableMap(analysisMap));
        }
        return analysisMap;
    }

    protected HashMap<File, File> filterForClasspath(Map<File, File> analysisMap, Iterable<File> classpath) {
        final HashSet classpathLookup = Sets.newHashSet(classpath);
        return Maps.newHashMap((Map)Maps.filterEntries(analysisMap, (Predicate)new Predicate<Map.Entry<File, File>>(){

            public boolean apply(Map.Entry<File, File> entry) {
                return classpathLookup.contains(entry.getKey());
            }
        }));
    }

    @Incubating
    @Classpath
    public FileCollection getEffectiveAnnotationProcessorPath() {
        AnnotationProcessorDetector annotationProcessorDetector = this.getServices().get(AnnotationProcessorDetector.class);
        return annotationProcessorDetector.getEffectiveAnnotationProcessorClasspath(this.compileOptions, this.getClasspath());
    }
}

