/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.report.unbound;

import java.io.PrintWriter;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.net.jcip.annotations.NotThreadSafe;
import org.gradle.model.internal.report.unbound.UnboundRule;
import org.gradle.model.internal.report.unbound.UnboundRuleInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class UnboundRulesReporter {
    private final PrintWriter writer;
    private final String prefix;
    private static final String INDENT = "  ";

    public UnboundRulesReporter(PrintWriter writer, String prefix) {
        this.writer = writer;
        this.prefix = prefix;
    }

    public void reportOn(Iterable<? extends UnboundRule> rules) {
        for (UnboundRule unboundRule : rules) {
            this.writer.print(this.prefix);
            this.writer.println(unboundRule.getDescriptor());
            if (unboundRule.getMutableInputs().size() > 0) {
                this.heading("subject:");
                this.reportInputs(unboundRule.getMutableInputs());
            }
            if (unboundRule.getImmutableInputs().size() > 0) {
                this.heading("inputs:");
                this.reportInputs(unboundRule.getImmutableInputs());
            }
            this.writer.println();
        }
        this.writer.println("[*] - indicates that a model item could not be found for the path or type.");
    }

    private void reportInputs(Iterable<? extends UnboundRuleInput> inputs) {
        for (UnboundRuleInput unboundRuleInput : inputs) {
            this.writer.print(this.indent(2));
            this.writer.write("- ");
            this.writer.write(unboundRuleInput.getPath() == null ? "<no path>" : unboundRuleInput.getPath());
            this.writer.write(" ");
            this.writer.write(unboundRuleInput.getType() == null ? "<untyped>" : unboundRuleInput.getType());
            if (unboundRuleInput.getDescription() != null) {
                this.writer.write(" ");
                this.writer.write("(");
                this.writer.write(unboundRuleInput.getDescription());
                this.writer.write(")");
            }
            if (!unboundRuleInput.isBound()) {
                this.writer.write(" ");
                this.writer.write("[*]");
            }
            this.writer.println();
            if (unboundRuleInput.getPath() == null && unboundRuleInput.getScope() != null) {
                this.writer.write(this.indent(4));
                this.writer.write("scope: ");
                this.writer.println(unboundRuleInput.getScope());
            }
            if (unboundRuleInput.getSuggestedPaths().size() <= 0) continue;
            this.writer.write(this.indent(4));
            this.writer.write("suggestions: ");
            this.writer.println(Joiner.on((String)", ").join(unboundRuleInput.getSuggestedPaths()));
        }
    }

    private void heading(String heading) {
        this.writer.print(this.indent(1));
        this.writer.println(heading);
    }

    private String indent(int times) {
        StringBuffer buff = new StringBuffer(this.prefix);
        for (int i = 0; i < times; ++i) {
            buff.append(INDENT);
        }
        return buff.toString();
    }
}

