/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.tasks;

import java.io.File;
import org.gradle.api.Incubating;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.nativeplatform.test.xctest.internal.XCTestTestExecutionSpec;
import org.gradle.nativeplatform.test.xctest.internal.XcTestExecuter;

@Incubating
public class XcTest
extends AbstractTestTask {
    private final DirectoryProperty workingDirectory = this.getProject().getLayout().directoryProperty();
    private final DirectoryProperty testInstallDirectory = this.newInputDirectory();
    private final RegularFileProperty runScriptFile = this.newInputFile();

    @Override
    protected XCTestTestExecutionSpec createTestExecutionSpec() {
        return new XCTestTestExecutionSpec(this.workingDirectory.getAsFile().get(), this.runScriptFile.getAsFile().get(), this.getPath());
    }

    @InputDirectory
    public DirectoryProperty getTestInstallDirectory() {
        return this.testInstallDirectory;
    }

    @Internal(value="Covered by getRunScript")
    public RegularFileProperty getRunScriptFile() {
        return this.runScriptFile;
    }

    @Internal
    public DirectoryProperty getWorkingDirectory() {
        return this.workingDirectory;
    }

    protected TestExecuter<XCTestTestExecutionSpec> createTestExecuter() {
        return this.getProject().getObjects().newInstance(XcTestExecuter.class, new Object[0]);
    }

    @SkipWhenEmpty
    @Optional
    @InputFile
    protected File getRunScript() {
        RegularFile runScript = (RegularFile)this.getRunScriptFile().get();
        File runScriptFile = runScript.getAsFile();
        if (!runScriptFile.exists()) {
            return null;
        }
        return runScriptFile;
    }
}

