/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.base.CharMatcher;
import org.gradle.plugin.internal.InvalidPluginIdException;
import org.gradle.plugin.use.PluginId;

public class DefaultPluginId
implements PluginId {
    public static final String SEPARATOR = ".";
    public static final String ID_SEPARATOR_ON_START_OR_END = "cannot begin or end with '.'";
    public static final String DOUBLE_SEPARATOR = "cannot contain '..'";
    public static final String PLUGIN_ID_VALID_CHARS_DESCRIPTION = "ASCII alphanumeric characters, '.', '_' and '-'";
    public static final CharMatcher INVALID_PLUGIN_ID_CHAR_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)".-_")).negate();
    private final String value;

    public DefaultPluginId(String value) {
        this.value = value;
    }

    public static PluginId of(String value) throws InvalidPluginIdException {
        DefaultPluginId.validate(value);
        return new DefaultPluginId(value);
    }

    public static PluginId unvalidated(String value) {
        return new DefaultPluginId(value);
    }

    public static void validate(String value) throws InvalidPluginIdException {
        if (value.startsWith(SEPARATOR) || value.endsWith(SEPARATOR)) {
            throw new InvalidPluginIdException(value, ID_SEPARATOR_ON_START_OR_END);
        }
        if (value.contains("..")) {
            throw new InvalidPluginIdException(value, DOUBLE_SEPARATOR);
        }
        int invalidCharIndex = INVALID_PLUGIN_ID_CHAR_MATCHER.indexIn((CharSequence)value);
        if (invalidCharIndex >= 0) {
            char invalidChar = value.charAt(invalidCharIndex);
            throw new InvalidPluginIdException(value, DefaultPluginId.invalidPluginIdCharMessage(invalidChar));
        }
    }

    public static String invalidPluginIdCharMessage(char invalidChar) {
        return "Plugin id contains invalid char '" + invalidChar + "' (only " + PLUGIN_ID_VALID_CHARS_DESCRIPTION + " characters are valid)";
    }

    private boolean isQualified() {
        return this.value.contains(SEPARATOR);
    }

    public PluginId withNamespace(String namespace) {
        if (this.isQualified()) {
            throw new IllegalArgumentException(this + " is already qualified");
        }
        return new DefaultPluginId(namespace + SEPARATOR + this.value);
    }

    @Nullable
    public String getNamespace() {
        return this.isQualified() ? this.value.substring(0, this.value.lastIndexOf(SEPARATOR)) : null;
    }

    public String getName() {
        return this.isQualified() ? this.value.substring(this.value.lastIndexOf(SEPARATOR) + 1) : this.value;
    }

    public String toString() {
        return this.value;
    }

    public String getId() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPluginId pluginId = (DefaultPluginId)o;
        return this.value.equals(pluginId.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

