/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ear;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.file.collections.MapFileTree;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.plugins.ear.descriptor.DeploymentDescriptor;
import org.gradle.plugins.ear.descriptor.internal.DefaultDeploymentDescriptor;
import org.gradle.plugins.ear.descriptor.internal.DefaultEarModule;
import org.gradle.plugins.ear.descriptor.internal.DefaultEarWebModule;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

public class Ear
extends Jar {
    public static final String EAR_EXTENSION = "ear";
    private String libDirName;
    private DeploymentDescriptor deploymentDescriptor;
    private CopySpec lib;

    public Ear() {
        this.setExtension(EAR_EXTENSION);
        this.setMetadataCharset("UTF-8");
        this.lib = this.getRootSpec().addChildBeforeSpec(this.getMainSpec()).into(new Callable<String>(){

            @Override
            public String call() {
                return GUtil.elvis(Ear.this.getLibDirName(), "lib");
            }
        });
        this.getMainSpec().appendCachingSafeCopyAction((Action<? super FileCopyDetails>)new Action<FileCopyDetails>(){

            @Override
            public void execute(FileCopyDetails details) {
                this.checkIfShouldGenerateDeploymentDescriptor(details);
                this.recordTopLevelModules(details);
            }

            private void recordTopLevelModules(FileCopyDetails details) {
                DeploymentDescriptor deploymentDescriptor = Ear.this.getDeploymentDescriptor();
                if (deploymentDescriptor != null && details.getPath().lastIndexOf("/") <= 0) {
                    DefaultEarModule module = details.getPath().toLowerCase().endsWith(".war") ? new DefaultEarWebModule(details.getPath(), details.getPath().substring(0, details.getPath().lastIndexOf("."))) : new DefaultEarModule(details.getPath());
                    if (!deploymentDescriptor.getModules().contains(module)) {
                        deploymentDescriptor.getModules().add(module);
                    }
                }
            }

            private void checkIfShouldGenerateDeploymentDescriptor(FileCopyDetails details) {
                String descriptorPath;
                DeploymentDescriptor deploymentDescriptor = Ear.this.getDeploymentDescriptor();
                String string = descriptorPath = deploymentDescriptor != null ? "META-INF/" + deploymentDescriptor.getFileName() : null;
                if (details.getPath().equalsIgnoreCase(descriptorPath)) {
                    Ear.this.setDeploymentDescriptor(null);
                    details.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
                }
            }
        });
        CopySpecInternal metaInf = (CopySpecInternal)this.getMainSpec().addChild().into("META-INF");
        metaInf.addChild().from(new Callable<FileTreeAdapter>(){

            @Override
            public FileTreeAdapter call() {
                final DeploymentDescriptor descriptor = Ear.this.getDeploymentDescriptor();
                if (descriptor != null) {
                    MapFileTree descriptorSource = new MapFileTree(Ear.this.getTemporaryDirFactory(), (Chmod)Ear.this.getFileSystem(), Ear.this.getDirectoryFileTreeFactory());
                    if (descriptor.getLibraryDirectory() == null) {
                        descriptor.setLibraryDirectory(Ear.this.getLibDirName());
                    }
                    descriptorSource.add(descriptor.getFileName(), new Action<OutputStream>(){

                        @Override
                        public void execute(OutputStream outputStream) {
                            descriptor.writeTo(new OutputStreamWriter(outputStream));
                        }
                    });
                    return new FileTreeAdapter(descriptorSource);
                }
                return null;
            }
        });
    }

    @Incubating
    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    public Ear deploymentDescriptor(@DelegatesTo(value=DeploymentDescriptor.class, strategy=1) Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.forceDeploymentDescriptor());
        return this;
    }

    public Ear deploymentDescriptor(Action<? super DeploymentDescriptor> configureAction) {
        configureAction.execute(this.forceDeploymentDescriptor());
        return this;
    }

    private DeploymentDescriptor forceDeploymentDescriptor() {
        if (this.deploymentDescriptor == null) {
            this.deploymentDescriptor = this.getObjectFactory().newInstance(DefaultDeploymentDescriptor.class, this.getFileResolver(), this.getObjectFactory());
        }
        return this.deploymentDescriptor;
    }

    @Internal
    public CopySpec getLib() {
        return ((CopySpecInternal)this.lib).addChild();
    }

    public CopySpec lib(@DelegatesTo(value=CopySpec.class, strategy=1) Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.getLib());
    }

    public CopySpec lib(Action<? super CopySpec> configureAction) {
        CopySpec copySpec = this.getLib();
        configureAction.execute(copySpec);
        return copySpec;
    }

    @Optional
    @Input
    public String getLibDirName() {
        return this.libDirName;
    }

    public void setLibDirName(String libDirName) {
        this.libDirName = libDirName;
    }

    @Internal
    public DeploymentDescriptor getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptor(DeploymentDescriptor deploymentDescriptor) {
        this.deploymentDescriptor = deploymentDescriptor;
    }
}

