/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.AbstractLayout;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class FormScalingUtil {
    private static final boolean DEBUG = false;
    private static final Logger LOG = Logger.getInstance(FormScalingUtil.class);
    private static final String SCALE_FACTOR_KEY = "hidpi.scale.factor";
    private final Stack<String> myStack = new Stack();
    private final Class myClazz;
    private final float myScaleFactor;
    private int myScaledValueCount = 0;

    public FormScalingUtil(Class clazz) {
        this(clazz, JBUI.scale((float)1.0f));
    }

    public FormScalingUtil(Class clazz, float scaleFactor) {
        this.myClazz = clazz;
        this.myScaleFactor = scaleFactor;
    }

    public static void scaleComponentTree(Class clazz, JComponent root) {
        new FormScalingUtil(clazz).scaleComponentTree(root);
    }

    public void scaleComponentTree(JComponent root) {
        if (this.myScaleFactor == 1.0f) {
            return;
        }
        this.scaleComponentTreeWorker(root);
        root.putClientProperty(SCALE_FACTOR_KEY, new Float(this.myScaleFactor));
    }

    protected boolean skipComponent(Component c) {
        JComponent jComponent;
        if (c instanceof JComponent && (jComponent = (JComponent)c).getClientProperty(SCALE_FACTOR_KEY) != null) {
            return true;
        }
        return c instanceof ComponentWithBrowseButton && c.isPreferredSizeSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scaleComponentTreeWorker(Component c) {
        if (this.skipComponent(c)) {
            return;
        }
        this.scaleComponent(c);
        if (c instanceof Container) {
            Container container = (Container)c;
            for (Component child : container.getComponents()) {
                this.scaleComponentTreeWorker(child);
            }
        }
    }

    private void scaleComponent(Component c) {
        float minFontSize;
        float fontSize;
        JComponent component;
        Border scaledBorder;
        JSlider slider;
        JTable table;
        Dimension size;
        if (c instanceof Container) {
            Container container = (Container)c;
            this.scaleLayoutManager(container.getLayout());
        }
        if (c instanceof JTable && (size = (table = (JTable)c).getPreferredScrollableViewportSize()) != null) {
            table.setPreferredScrollableViewportSize(this.scale(size, "preferredScrollableViewportSize"));
        }
        if (c instanceof JSlider && !(slider = (JSlider)c).isPreferredSizeSet()) {
            slider.setPreferredSize(slider.getPreferredSize());
        }
        if (c instanceof JBLabel) {
            JBLabel label = (JBLabel)c;
            label.setIconTextGap(this.scale(label.getIconTextGap(), "IconTextGap"));
        }
        if (c instanceof JComponent && (scaledBorder = this.getScaledBorder(component = (JComponent)c, component.getBorder())) != null) {
            component.setBorder(scaledBorder);
        }
        if (c.isFontSet() && (fontSize = c.getFont().getSize2D()) <= (minFontSize = 9.0f * this.myScaleFactor)) {
            c.setFont(c.getFont().deriveFont(this.scale(fontSize, "FontSize")));
        }
        this.scaleMinimumSize(c);
        this.scaleMaximumSize(c);
        this.scalePreferredSize(c);
        if (c.getParent() != null && c.getParent().getLayout() != null && c.getParent().getLayout() instanceof AbstractLayout) {
            AbstractLayout abstractLayout = (AbstractLayout)c.getParent().getLayout();
            GridConstraints constraint = abstractLayout.getConstraintsForComponent(c);
            constraint.myPreferredSize.width = this.scale(constraint.myPreferredSize.width, "constraint.myPreferredSize.width");
            constraint.myPreferredSize.height = this.scale(constraint.myPreferredSize.height, "constraint.myPreferredSize.height");
            constraint.myMinimumSize.width = this.scale(constraint.myMinimumSize.width, "constraint.myMinimumSize.width");
            constraint.myMinimumSize.height = this.scale(constraint.myMinimumSize.height, "constraint.myMinimumSize.height");
            constraint.myMaximumSize.width = this.scale(constraint.myMaximumSize.width, "constraint.myMaximumSize.width");
            constraint.myMaximumSize.height = this.scale(constraint.myMaximumSize.height, "constraint.myMaximumSize.height");
        }
    }

    private void scaleMinimumSize(Component c) {
        if (c.isMinimumSizeSet()) {
            c.setMinimumSize(this.scale(c.getMinimumSize(), "MinimumSize"));
        }
    }

    private void scaleMaximumSize(Component c) {
        if (c.isMaximumSizeSet()) {
            c.setMaximumSize(this.scale(c.getMaximumSize(), "MaximumSize"));
        }
    }

    private void scalePreferredSize(Component c) {
        if (c.isPreferredSizeSet()) {
            c.setPreferredSize(this.scale(c.getPreferredSize(), "PreferredSize"));
        }
    }

    private void scaleLayoutManager(LayoutManager layout) {
        if (layout instanceof AbstractLayout) {
            AbstractLayout abstractLayout = (AbstractLayout)layout;
            abstractLayout.setVGap(this.scale(abstractLayout.getVGap(), "VGap"));
            abstractLayout.setHGap(this.scale(abstractLayout.getHGap(), "VGap"));
            abstractLayout.setMargin(this.scale(abstractLayout.getMargin(), "Margin"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Border getScaledBorder(Component c, Border border) {
        if (border == null) {
            return null;
        }
        if (border.getClass() == EmptyBorder.class) {
            return new EmptyBorder(this.scale(border.getBorderInsets(c), "EmptyBorder"));
        }
        if (border instanceof TitledBorder) {
            TitledBorder titledBorder = (TitledBorder)border;
            Border innerBorder = this.getScaledBorder(c, titledBorder.getBorder());
            if (innerBorder != null) {
                titledBorder.setBorder(innerBorder);
            }
        }
        return border;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension scale(Dimension dimension, String propertyName) {
        Dimension dimension2 = new Dimension(this.scale(dimension.width, "width"), this.scale(dimension.height, "height"));
        return dimension2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Insets scale(Insets insets, String propertyName) {
        Insets insets2 = new Insets(this.scale(insets.top, "top"), this.scale(insets.left, "left"), this.scale(insets.right, "right"), this.scale(insets.bottom, "bottom"));
        return insets2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int scale(int value, String propertyName) {
        int n = this.scale(value);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float scale(float value, String propertyName) {
        float f = this.scale(value);
        return f;
    }

    private float scale(float value) {
        return this.scale((int)value);
    }

    private int scale(int value) {
        if (value <= 0) {
            return value;
        }
        long result = (long)(this.myScaleFactor * (float)value);
        if (result >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        this.logScale(value, (int)result);
        ++this.myScaledValueCount;
        return (int)result;
    }

    private void logScale(int value, int scaledValue) {
    }

    private static String getComponentName(Component c) {
        String name = c.getName();
        if (name == null) {
            name = c.getClass().getSimpleName();
        }
        return name;
    }

    private String buildStackString() {
        StringBuilder sb = new StringBuilder();
        for (String text : this.myStack) {
            if (sb.length() > 0) {
                sb.append(" > ");
            }
            sb.append(text);
        }
        return sb.toString();
    }
}

