/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.index;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.ws.index.WSIndexEntry;
import com.intellij.ws.index.WSTextRange;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileBasedWSIndex
extends FileBasedIndexExtension<String, WSIndexEntry> {
    private static final int VERSION = 5;
    @NonNls
    public static final String WS_TYPE = "Web service";
    @NonNls
    public static final String JAXB_TYPE = "JAXB mapped type";
    @NonNls
    public static final String WS_METHOD = "Web service method";
    @NonNls
    public static final String WS_PARAMETER_TYPE = "Web service parameter type";
    @NonNls
    public static final String WS_PARAMETER_PROPERTY_TYPE = "Web service parameter property";
    @NonNls
    public static final String JAXB_PROPERTY_TYPE = "JAXB mapped property";
    private long modificationStamp = 0L;
    public static final ID<String, WSIndexEntry> WS_INDEX = ID.create((String)"FileBasedWSIndex");
    @NonNls
    public static final String ANY_NAME = "*";
    private final DataExternalizer<WSIndexEntry> myValueExternalizer = new DataExternalizer<WSIndexEntry>(){

        public void save(@NotNull DataOutput out, WSIndexEntry value) throws IOException {
            if (out == null) {
                2.$$$reportNull$$$0(0);
            }
            if (value != null) {
                value.write(out);
            }
        }

        @Nullable
        public WSIndexEntry read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                2.$$$reportNull$$$0(1);
            }
            try {
                return new WSIndexEntry(in);
            }
            catch (IOException ex) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ws/index/FileBasedWSIndex$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public ID<String, WSIndexEntry> getName() {
        ID<String, WSIndexEntry> iD = WS_INDEX;
        if (iD == null) {
            FileBasedWSIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    public static boolean hasEntriesFor(PsiClass cls) {
        return cls != null && FileBasedWSIndex.getWsEntries(cls).length > 0;
    }

    @NotNull
    public DataIndexer<String, WSIndexEntry, FileContent> getIndexer() {
        DataIndexer<String, WSIndexEntry, FileContent> dataIndexer = new DataIndexer<String, WSIndexEntry, FileContent>(){

            @NotNull
            public Map<String, WSIndexEntry> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                HashMap<String, WSIndexEntry> map = new HashMap<String, WSIndexEntry>();
                try {
                    WSIndexEntry entry = new WSIndexEntry(inputData);
                    for (String candidate : entry.myCandidates) {
                        map.put(candidate, entry);
                    }
                    entry.myCandidates.clear();
                    if (map.size() > 0) {
                        FileBasedWSIndex.this.modificationStamp++;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                HashMap<String, WSIndexEntry> hashMap = map;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(1);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ws/index/FileBasedWSIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ws/index/FileBasedWSIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            FileBasedWSIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            FileBasedWSIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<WSIndexEntry> getValueExternalizer() {
        DataExternalizer<WSIndexEntry> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            FileBasedWSIndex.$$$reportNull$$$0(3);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.XML}){

            public boolean acceptInput(@NotNull VirtualFile vf) {
                if (vf == null) {
                    3.$$$reportNull$$$0(0);
                }
                return FileBasedWSIndex.isAcceptableFile(vf);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vf", "com/intellij/ws/index/FileBasedWSIndex$3", "acceptInput"));
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            FileBasedWSIndex.$$$reportNull$$$0(4);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 5;
    }

    static boolean isAcceptableFile(VirtualFile vf) {
        if (!(vf.getFileSystem() instanceof LocalFileSystem)) {
            return false;
        }
        String extension = vf.getExtension();
        boolean wsdd = "wsdd".equals(extension);
        boolean wsdl = "wsdl".equals(extension);
        boolean jaxb = "xsd".equals(extension);
        boolean xfireServices = FileBasedWSIndex.isXFireWs(vf);
        boolean jaxwsServices = FileBasedWSIndex.isSunJaxWs(vf);
        boolean jaxrpc = FileBasedWSIndex.isJaxRpc(vf);
        boolean jaxrpc2 = FileBasedWSIndex.isJaxRpc2(vf);
        boolean cxf = FileBasedWSIndex.isCxf(vf);
        return wsdd || wsdl || jaxb || xfireServices || jaxwsServices || jaxrpc || jaxrpc2 || cxf;
    }

    static boolean isCxf(VirtualFile vf) {
        return FileBasedWSIndex.isFileLike("cxf-servlet.xml", vf);
    }

    static boolean isJaxRpc2(VirtualFile vf) {
        return FileBasedWSIndex.isFileLike("jaxrpc-ri-runtime.xml", vf);
    }

    private static boolean isFileLike(String pattern, VirtualFile vf) {
        boolean b = pattern.equals(vf.getName());
        if (!b && ApplicationManager.getApplication().isUnitTestMode()) {
            int ind = pattern.lastIndexOf(46);
            String name = vf.getName();
            int ind2 = name.lastIndexOf(46);
            b = name.regionMatches(0, pattern, 0, ind) && name.regionMatches(ind2 + 1, pattern, ind + 1, pattern.length() - ind - 1);
        }
        return b;
    }

    static boolean isJaxRpc(VirtualFile vf) {
        return FileBasedWSIndex.isFileLike("jax-rpc.xml", vf);
    }

    static boolean isSunJaxWs(VirtualFile vf) {
        return FileBasedWSIndex.isFileLike("sun-jaxws.xml", vf);
    }

    static boolean isXFireWs(VirtualFile vf) {
        return FileBasedWSIndex.isFileLike("services.xml", vf);
    }

    @Nullable
    public static String getKey(PsiMember c) {
        PsiClass containingClass = c.getContainingClass();
        return c instanceof PsiClass ? ((PsiClass)c).getQualifiedName() : (containingClass == null ? null : containingClass.getQualifiedName() + "." + c.getName());
    }

    public static WSIndexEntry[] getEntries(Module module, String key) {
        if (module == null) {
            return WSIndexEntry.EMPTY;
        }
        GlobalSearchScope scope = module.getModuleContentScope();
        List entries = FileBasedIndex.getInstance().getValues(WS_INDEX, (Object)key, scope);
        for (WSIndexEntry entry : entries) {
            if (entry.isResolved(module.getProject())) continue;
            entry.resolve(module.getProject());
        }
        return entries.isEmpty() ? WSIndexEntry.EMPTY : entries.toArray(WSIndexEntry.EMPTY);
    }

    @NotNull
    public static WSIndexEntry[] getWsEntries(@NotNull Collection<WSIndexEntry> entries, PsiMember c) {
        if (entries == null) {
            FileBasedWSIndex.$$$reportNull$$$0(5);
        }
        String qname = FileBasedWSIndex.getKey(c);
        PsiModifierList modifierList = c.getModifierList();
        String anyqname = modifierList != null ? (modifierList.hasModifierProperty("public") ? FileBasedWSIndex.getAnyKey(c) : null) : null;
        List<WSIndexEntry> result = null;
        boolean fileLevel = c.getParent() instanceof PsiFile;
        THashSet depedentModules = null;
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)c.getProject()).getFileIndex();
        if (fileLevel) {
            VirtualFile vf = c.getContainingFile().getVirtualFile();
            if (vf == null) {
                if (WSIndexEntry.EMPTY == null) {
                    FileBasedWSIndex.$$$reportNull$$$0(6);
                }
                return WSIndexEntry.EMPTY;
            }
            Module moduleForFile = index.getModuleForFile(vf);
            if (moduleForFile != null) {
                depedentModules = new THashSet();
                depedentModules.add(moduleForFile);
                Object[] modules = ModuleRootManager.getInstance((Module)moduleForFile).getDependencies();
                ContainerUtil.addAll((Collection)depedentModules, (Object[])modules);
            }
        }
        for (WSIndexEntry entry : entries) {
            if (fileLevel) {
                VirtualFile file = entry.getFile();
                if (depedentModules != null && (file == null || !depedentModules.contains(index.getModuleForFile(file)))) continue;
            }
            result = FileBasedWSIndex.addEntry(entry, qname, result);
            if (anyqname == null) continue;
            result = FileBasedWSIndex.addEntry(entry, anyqname, result);
        }
        WSIndexEntry[] wSIndexEntryArray = result != null ? result.toArray(WSIndexEntry.EMPTY) : WSIndexEntry.EMPTY;
        if (wSIndexEntryArray == null) {
            FileBasedWSIndex.$$$reportNull$$$0(7);
        }
        return wSIndexEntryArray;
    }

    private static List<WSIndexEntry> addEntry(WSIndexEntry entry, String qname, List<WSIndexEntry> result) {
        if (entry.mySymbols.contains(qname)) {
            WSTextRange range = entry.myLinks.get(qname);
            if (result == null) {
                result = new LinkedList<WSIndexEntry>();
            }
            if (range != null) {
                result.add(entry);
            }
        }
        return result;
    }

    @NotNull
    public static WSIndexEntry[] getWsEntries(@NotNull PsiClass c) {
        if (c == null) {
            FileBasedWSIndex.$$$reportNull$$$0(8);
        }
        WSIndexEntry[] wSIndexEntryArray = (WSIndexEntry[])CachedValuesManager.getCachedValue((PsiElement)c, () -> {
            if (c == null) {
                FileBasedWSIndex.$$$reportNull$$$0(10);
            }
            String key = c.getName();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)c);
            THashSet entries = new THashSet();
            if (module != null && key != null) {
                GlobalSearchScope scope = module.getModuleContentScope();
                List values = FileBasedIndex.getInstance().getValues(WS_INDEX, (Object)key, scope);
                while (values.remove(null)) {
                }
                for (WSIndexEntry entry : values) {
                    if (!entry.isResolved(module.getProject())) {
                        entry.resolve(c.getProject());
                    }
                    if (!entry.mySymbols.contains(c.getQualifiedName())) continue;
                    entries.add(entry);
                }
            }
            WSIndexEntry[] res = entries.isEmpty() ? WSIndexEntry.EMPTY : entries.toArray(WSIndexEntry.EMPTY);
            return CachedValueProvider.Result.create((Object)res, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
        if (wSIndexEntryArray == null) {
            FileBasedWSIndex.$$$reportNull$$$0(9);
        }
        return wSIndexEntryArray;
    }

    @Nullable
    static String getAnyKey(PsiMember member) {
        PsiClass aClass;
        PsiClass psiClass = aClass = member instanceof PsiMethod ? member.getContainingClass() : null;
        if (aClass != null) {
            return aClass.getQualifiedName() + "." + ANY_NAME;
        }
        return null;
    }

    public long getModificationStamp() {
        return this.modificationStamp;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/index/FileBasedWSIndex";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/index/FileBasedWSIndex";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getWsEntries";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getWsEntries";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getWsEntries$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

