/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.wsdl.converters;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.ws.wsdl.WsdlDomUtils;
import com.intellij.ws.wsdl.converters.WsdlDomReference;
import com.intellij.ws.wsdl.model.Binding;
import com.intellij.ws.wsdl.model.Binding_operation;
import com.intellij.ws.wsdl.model.Definitions;
import com.intellij.ws.wsdl.model.Message;
import com.intellij.ws.wsdl.model.Operation;
import com.intellij.ws.wsdl.model.Param;
import com.intellij.ws.wsdl.model.Part;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WsdlPartsDomReference
extends PsiReferenceBase<PsiElement> {
    private final String myName;

    public WsdlPartsDomReference(XmlAttributeValue element, TextRange range, String name) {
        super((PsiElement)element, range, true);
        this.myName = name;
    }

    public PsiElement resolve() {
        Message message = this.resolveMessage();
        if (message != null) {
            for (Part part : message.getParts()) {
                if (!this.myName.equals(part.getName().getValue())) continue;
                return part.getName().getXmlAttributeValue();
            }
        }
        return null;
    }

    @Nullable
    private Message resolveMessage() {
        XmlAttributeValue element = (XmlAttributeValue)this.getElement();
        XmlTag soapTag = (XmlTag)element.getParent().getParent();
        DomElement domElement = DomUtil.getDomElement((PsiElement)soapTag);
        if (domElement != null) {
            XmlAttributeValue attrValue;
            XmlTag parentTag = soapTag.getParentTag();
            boolean isInput = parentTag != null && "input".equals(parentTag.getLocalName());
            boolean isOutput = parentTag != null && "output".equals(parentTag.getLocalName());
            Binding_operation op = (Binding_operation)domElement.getParentOfType(Binding_operation.class, true);
            Definitions definitions = (Definitions)domElement.getParentOfType(Definitions.class, true);
            Binding binding = (Binding)domElement.getParentOfType(Binding.class, true);
            if (op != null && binding != null && definitions != null && (isInput || isOutput) && (attrValue = op.getName().getXmlAttributeValue()) != null) {
                for (PsiReference reference : attrValue.getReferences()) {
                    DomElement tag;
                    if (!(reference instanceof WsdlDomReference)) continue;
                    PsiElement xmlElement = reference.resolve();
                    if (!(xmlElement instanceof XmlAttributeValue) || !((tag = DomUtil.getDomElement((PsiElement)xmlElement.getParent().getParent())) instanceof Operation)) break;
                    Operation operation = (Operation)tag;
                    Param param = isInput ? operation.getInput() : operation.getOutput();
                    return WsdlDomUtils.findMessage((String)param.getMessage().getValue(), definitions);
                }
            }
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<String> exclude = new ArrayList<String>();
        for (String s : StringUtil.split((String)StringUtil.unquoteString((String)this.getElement().getText()), (String)" ")) {
            s = s.contains(":") ? s.substring(0, s.indexOf(":")) : s;
            if ("IntellijIdeaRulezzz ".equals(s)) continue;
            exclude.add(s);
        }
        Message message = this.resolveMessage();
        if (message != null) {
            ArrayList<String> variants = new ArrayList<String>();
            for (Part part : message.getParts()) {
                String value = (String)part.getName().getValue();
                if (exclude.contains(value)) continue;
                variants.add(value);
            }
            Object[] objectArray = ArrayUtil.toStringArray(variants);
            if (objectArray == null) {
                WsdlPartsDomReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }
        if (EMPTY_ARRAY == null) {
            WsdlPartsDomReference.$$$reportNull$$$0(1);
        }
        return EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/wsdl/converters/WsdlPartsDomReference", "getVariants"));
    }
}

