/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.jaxb;

import com.intellij.history.LocalHistory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.WsJavaExternalProcessHandler;
import com.intellij.ws.engines.ExternalEngine;
import com.intellij.ws.utils.BaseWSFromFileAction;
import com.intellij.ws.utils.CommonWsUtils;
import com.intellij.ws.utils.DeploymentTimeCheckProcessor;
import com.intellij.ws.utils.ExternalProcessHandler;
import com.intellij.ws.utils.InvokeExternalCodeUtil;
import com.intellij.ws.utils.LibUtils;
import com.intellij.ws.utils.WSInvokeExternalCodeUtil;
import com.intellij.ws.xml.jaxb.GenerateJAXBSchemasFromJavaDialog;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class GenerateJAXBSchemasFromJavaAction
extends BaseWSFromFileAction {
    public void actionPerformed(AnActionEvent anActionEvent) {
        DataContext dataContext = anActionEvent.getDataContext();
        Project project = (Project)dataContext.getData(DataConstants.PROJECT);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiJavaFile psiFile = file instanceof PsiJavaFile ? (PsiJavaFile)file : null;
        PsiClass classFromDataContext = psiFile != null ? (PsiClass)ArrayUtil.getFirstElement((Object[])psiFile.getClasses()) : null;
        this.doAction(project, classFromDataContext, null);
    }

    private void doAction(Project project, PsiClass classFromDataContext, GenerateJAXBSchemasFromJavaDialog previousDialog) {
        GenerateJAXBSchemasFromJavaDialog dialog = new GenerateJAXBSchemasFromJavaDialog(project, classFromDataContext, previousDialog);
        if (dialog.showAndGet()) {
            this.doAction(project, dialog);
        }
    }

    private void doAction(Project project, GenerateJAXBSchemasFromJavaDialog dialog) {
        LocalHistory.getInstance().putSystemLabel(project, WSBundle.message("generate.jaxb.schemas.from.java.lvcs.title", new Object[0]));
        final LinkedList<String> parameters = new LinkedList<String>();
        PsiFile file = dialog.getCurrentClass().getContainingFile();
        Module moduleForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(file.getVirtualFile());
        parameters.add("-cp");
        parameters.add(InvokeExternalCodeUtil.buildClasspathForModule((Module)moduleForFile));
        parameters.add("-d");
        String outputPath = file.getContainingDirectory().getVirtualFile().getPath();
        parameters.add(outputPath);
        PsiClass currentClass = dialog.getCurrentClass();
        if (dialog.toIncludeTypesOfMethods()) {
            new DeploymentTimeCheckProcessor(){

                @Override
                public void processMethod(PsiMethod method, String problem, List<String> nonelementaryTypes) {
                    parameters.addAll(nonelementaryTypes);
                }
            }.processClassMethods(dialog.getSelectedMethods());
        }
        parameters.add(currentClass.getQualifiedName());
        ExternalEngine engine = WebServicesPluginSettings.getInstance().getEngineManager().getExternalEngineByName("JAXB 2");
        Consumer atFailure = e -> {
            String message = e.getMessage();
            if (message != null && StringUtil.containsIgnoreCase((String)message, (String)"warning:")) {
                return;
            }
            Messages.showErrorDialog((Project)project, (String)message, (String)"Schema gen error");
            e.printStackTrace();
        };
        String basePath = engine.getBasePath();
        WsJavaExternalProcessHandler processHandler = new WsJavaExternalProcessHandler("JXC", basePath != null ? "com.sun.tools.jxc.SchemaGeneratorFacade" : "com.sun.tools.internal.jxc.SchemaGenerator", LibUtils.getLibUrlsForToolRunning(engine, moduleForFile), ArrayUtil.toStringArray(parameters), moduleForFile, true);
        WSInvokeExternalCodeUtil.addEndorsedJarDirectory(processHandler, engine, moduleForFile);
        InvokeExternalCodeUtil.invokeExternalProcess2((ExternalProcessHandler)processHandler, (Project)project, () -> {
            CommonWsUtils.doFileSystemRefresh();
            File tempFile = new File(outputPath + File.separator + "schema1.xsd");
            if (tempFile.exists()) {
                VirtualFile virtualFile = (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempFile));
                FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile), true);
            } else {
                atFailure.consume((Object)new InvokeExternalCodeUtil.ExternalCodeException("schema1.xsd is missing"));
            }
        }, (Consumer)atFailure, () -> true, () -> this.doAction(project, null, dialog));
    }
}

