/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.browse;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssSourcePreview
implements ComponentWithActions,
Disposable {
    private Editor myViewer = CssSourcePreview.createEditor();
    private CssDeclaration myDeclaration;
    private final ActionGroup myActions = this.initActions();
    private CssDeclaration myNavigateToElement;

    public ActionGroup getToolbarActions() {
        return this.myActions;
    }

    public JComponent getSearchComponent() {
        return null;
    }

    public String getToolbarPlace() {
        return "unknown";
    }

    public JComponent getToolbarContextComponent() {
        return null;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myViewer.getComponent();
        if (jComponent == null) {
            CssSourcePreview.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    public boolean isContentBuiltIn() {
        return false;
    }

    @Nullable
    public static Icon getIcon() {
        return CssFileType.INSTANCE.getIcon();
    }

    private ActionGroup initActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(new AnAction(CssBundle.message((String)"css.browser.actions.navigate.to.style.source", (Object[])new Object[0]), CssBundle.message((String)"css.browser.actions.navigate.to.style.source.description", (Object[])new Object[0]), AllIcons.Actions.Preview){

            public void actionPerformed(AnActionEvent e) {
                if (CssSourcePreview.this.myNavigateToElement != null && CssSourcePreview.this.myNavigateToElement.isValid()) {
                    CssSourcePreview.this.myNavigateToElement.navigate(true);
                }
            }
        });
        return group;
    }

    private static Editor createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Editor viewer = editorFactory.createViewer(editorFactory.createDocument((CharSequence)""));
        ((EditorEx)viewer).setHighlighter((EditorHighlighter)new LexerEditorHighlighter((SyntaxHighlighter)new CssHighlighter(), viewer.getColorsScheme()));
        ((EditorEx)viewer).setEmbeddedIntoDialogWrapper(true);
        ((EditorEx)viewer).setCaretVisible(false);
        EditorSettings editorSettings = viewer.getSettings();
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setAdditionalColumnsCount(0);
        editorSettings.setAdditionalLinesCount(1);
        return viewer;
    }

    public void setDeclaration(@Nullable CssDeclaration declaration) {
        this.myDeclaration = declaration;
        if (declaration != null) {
            final PsiElement[] element = new PsiElement[]{PsiTreeUtil.getParentOfType((PsiElement)declaration, CssRuleset.class)};
            if (element[0] == null) {
                element[0] = PsiTreeUtil.getParentOfType((PsiElement)declaration, XmlAttribute.class);
            }
            if (element[0] != null) {
                new WriteCommandAction(declaration.getProject(), new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        CssSourcePreview.this.myViewer.getDocument().setText((CharSequence)element[0].getText());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/browse/CssSourcePreview$2", "run"));
                    }
                }.executeSilently();
            }
            this.myNavigateToElement = declaration;
        }
    }

    public void dispose() {
        if (this.myViewer != null) {
            EditorFactory.getInstance().releaseEditor(this.myViewer);
            this.myViewer = null;
        }
        this.myDeclaration = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/browse/CssSourcePreview", "getComponent"));
    }
}

