/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.impl.CssApplyRuleImpl;
import com.intellij.psi.css.impl.CssAtRuleImpl;
import com.intellij.psi.css.impl.CssAttributeRSideImpl;
import com.intellij.psi.css.impl.CssBlockImpl;
import com.intellij.psi.css.impl.CssCharsetImpl;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssExpressionImpl;
import com.intellij.psi.css.impl.CssFunctionImpl;
import com.intellij.psi.css.impl.CssImportListImpl;
import com.intellij.psi.css.impl.CssKeyframesRuleImpl;
import com.intellij.psi.css.impl.CssKeyframesSelectorImpl;
import com.intellij.psi.css.impl.CssLazyStylesheet;
import com.intellij.psi.css.impl.CssLineNamesImpl;
import com.intellij.psi.css.impl.CssMediaExpressionImpl;
import com.intellij.psi.css.impl.CssMediaFeatureImpl;
import com.intellij.psi.css.impl.CssMediaQueryImpl;
import com.intellij.psi.css.impl.CssMediumListImpl;
import com.intellij.psi.css.impl.CssNamespaceImpl;
import com.intellij.psi.css.impl.CssNamespaceListImpl;
import com.intellij.psi.css.impl.CssOperationImpl;
import com.intellij.psi.css.impl.CssPageRuleImpl;
import com.intellij.psi.css.impl.CssSelectorSuffixListImpl;
import com.intellij.psi.css.impl.CssStringImpl;
import com.intellij.psi.css.impl.CssSupportsConditionImpl;
import com.intellij.psi.css.impl.CssSupportsConditionListImpl;
import com.intellij.psi.css.impl.CssTermImpl;
import com.intellij.psi.css.impl.CssTermListImpl;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.CssUriImpl;
import com.intellij.psi.css.impl.CssValueDeclarationImpl;
import com.intellij.psi.css.impl.CssValueImportedAliasImpl;
import com.intellij.psi.css.impl.CssValueRuleImpl;
import com.intellij.psi.css.impl.stubs.base.CssStubElementType;
import com.intellij.psi.css.impl.util.CssStylesheetLazyElementType;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.annotations.NotNull;

public class CssTreeElementFactory
extends ASTFactory {
    private final DefaultASTFactory myDefaultASTFactory = (DefaultASTFactory)ServiceManager.getService(DefaultASTFactory.class);

    protected boolean isComment(IElementType type) {
        return type == CssElementTypes.CSS_COMMENT;
    }

    @NotNull
    public LeafElement createLeaf(@NotNull IElementType type, @NotNull CharSequence text) {
        if (type == null) {
            CssTreeElementFactory.$$$reportNull$$$0(0);
        }
        if (text == null) {
            CssTreeElementFactory.$$$reportNull$$$0(1);
        }
        if (this.isComment(type)) {
            LeafElement leafElement = this.myDefaultASTFactory.createComment(type, text);
            if (leafElement == null) {
                CssTreeElementFactory.$$$reportNull$$$0(2);
            }
            return leafElement;
        }
        CssTokenImpl cssTokenImpl = new CssTokenImpl(type, text);
        if (cssTokenImpl == null) {
            CssTreeElementFactory.$$$reportNull$$$0(3);
        }
        return cssTokenImpl;
    }

    @NotNull
    public CompositeElement createComposite(@NotNull IElementType type) {
        if (type == null) {
            CssTreeElementFactory.$$$reportNull$$$0(4);
        }
        CompositeElement compositeElement = CssTreeElementFactory.createCssComposite(type);
        if (compositeElement == null) {
            CssTreeElementFactory.$$$reportNull$$$0(5);
        }
        return compositeElement;
    }

    public LazyParseableElement createLazy(@NotNull ILazyParseableElementType type, CharSequence text) {
        if (type == null) {
            CssTreeElementFactory.$$$reportNull$$$0(6);
        }
        if (type instanceof IFileElementType) {
            return new FileElement((IElementType)type, text);
        }
        if (type instanceof CssStylesheetLazyElementType) {
            return new CssLazyStylesheet(text);
        }
        if (type == CssElementTypes.CSS_PAGE_BLOCK || type == CssElementTypes.CSS_DECLARATION_BLOCK) {
            return new CssBlockImpl(text);
        }
        return super.createLazy(type, text);
    }

    private static CompositeElement createCssComposite(IElementType type) {
        CssElementImpl element;
        if (type == CssElementTypes.CSS_NAMESPACE) {
            element = new CssNamespaceImpl();
        } else if (type == CssElementTypes.CSS_KEYFRAMES_SELECTOR) {
            element = new CssKeyframesSelectorImpl();
        } else if (type == CssElementTypes.CSS_TERM_LIST) {
            element = new CssTermListImpl();
        } else if (type == CssElementTypes.CSS_TERM) {
            element = new CssTermImpl();
        } else if (type == CssElementTypes.CSS_LINE_NAMES) {
            element = new CssLineNamesImpl();
        } else if (type == CssElementTypes.CSS_SELECTOR_SUFFIX_LIST) {
            element = new CssSelectorSuffixListImpl();
        } else if (type == CssElementTypes.CSS_EXPRESSION) {
            element = new CssExpressionImpl();
        } else if (type == CssElementTypes.CSS_IMPORT_LIST) {
            element = new CssImportListImpl();
        } else if (type == CssElementTypes.CSS_URI) {
            element = new CssUriImpl();
        } else if (type == CssElementTypes.CSS_STRING) {
            element = new CssStringImpl();
        } else if (type == CssElementTypes.CSS_MEDIUM_LIST) {
            element = new CssMediumListImpl();
        } else if (type == CssElementTypes.CSS_MEDIA_QUERY) {
            element = new CssMediaQueryImpl();
        } else if (type == CssElementTypes.CSS_ATTRIBUTE_RSIDE) {
            element = new CssAttributeRSideImpl();
        } else if (type == CssElementTypes.CSS_FUNCTION) {
            element = new CssFunctionImpl();
        } else if (type == CssElementTypes.CSS_CHARSET) {
            element = new CssCharsetImpl();
        } else if (type == CssElementTypes.CSS_KEYFRAMES_RULE) {
            element = new CssKeyframesRuleImpl();
        } else if (type == CssElementTypes.CSS_PAGE) {
            element = new CssPageRuleImpl();
        } else if (type == CssElementTypes.CSS_SUPPORTS_CONDITION) {
            element = new CssSupportsConditionImpl();
        } else if (type == CssElementTypes.CSS_SUPPORTS_CONDITION_UNKNOWN_LIST || type == CssElementTypes.CSS_SUPPORTS_CONDITION_AND_LIST || type == CssElementTypes.CSS_SUPPORTS_CONDITION_OR_LIST) {
            element = new CssSupportsConditionListImpl(type);
        } else if (type == CssElementTypes.CSS_NAMESPACE_LIST) {
            element = new CssNamespaceListImpl();
        } else if (type == CssElementTypes.CSS_BINARY_OPERATION || type == CssElementTypes.CSS_UNARY_OPERATION) {
            element = new CssOperationImpl(type);
        } else if (type == CssElementTypes.CSS_FONTFACE) {
            element = new CssAtRuleImpl(CssContextType.FONTFACE, type);
        } else if (type == CssElementTypes.CSS_SUPPORTS) {
            element = new CssAtRuleImpl(CssContextType.SUPPORTS, type);
        } else if (type == CssElementTypes.CSS_VIEWPORT) {
            element = new CssAtRuleImpl(CssContextType.VIEWPORT, type);
        } else if (type == CssElementTypes.CSS_PAGE_MARGIN_RULE) {
            element = new CssAtRuleImpl(CssContextType.PAGE_MARGIN, type);
        } else if (type == CssElementTypes.CSS_COUNTER_STYLE_RULE) {
            element = new CssAtRuleImpl(CssContextType.COUNTER_STYLE, type);
        } else if (type == CssElementTypes.CSS_SCOPE_RULE || type == CssElementTypes.CSS_REGION_RULE || type == CssElementTypes.CSS_DOCUMENT_RULE) {
            element = new CssAtRuleImpl(CssContextType.NONAME, type);
        } else if (type == CssElementTypes.CSS_APPLY) {
            element = new CssApplyRuleImpl();
        } else if (type == CssElementTypes.CSS_BAD_AT_RULE) {
            element = new CssAtRuleImpl(CssContextType.UNKNOWN, type);
        } else if (type == CssElementTypes.CSS_MEDIA_EXPRESSION) {
            element = new CssMediaExpressionImpl();
        } else if (type == CssElementTypes.CSS_MEDIA_FEATURE) {
            element = new CssMediaFeatureImpl();
        } else if (type == CssElementTypes.CSS_NUMBER_TERM || type == CssElementTypes.CSS_EXPRESSION_PARAMETER || type == CssElementTypes.CSS_MEDIA_EXPRESSION_LIST) {
            element = new CssElementImpl(type);
        } else if (type == CssElementTypes.CSS_VALUE_RULE) {
            element = new CssValueRuleImpl();
        } else if (type == CssElementTypes.CSS_VALUE_IMPORTED_ALIAS) {
            element = new CssValueImportedAliasImpl();
        } else if (type == CssElementTypes.CSS_VALUE_DECLARATION) {
            element = new CssValueDeclarationImpl();
        } else if (type == CssElementTypes.CSS_VALUE_IMPORT || type == CssElementTypes.CSS_VALUE_IMPORTED_ALIAS_LIST || type == CssElementTypes.CSS_VALUE_VALUE) {
            element = new CssElementImpl(type);
        } else {
            if (type instanceof CssStubElementType) {
                return new CompositeElement(type);
            }
            throw new RuntimeException("Wrong type: " + type);
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssTreeElementFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssTreeElementFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeaf";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createComposite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLeaf";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createComposite";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLazy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

