/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.handler;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class CssPropertyNameInsertHandler
implements InsertHandler<LookupElement> {
    private final boolean myAddDeclarationTerminator;
    private final String myDelimiter;

    public CssPropertyNameInsertHandler(@NotNull String delimiter, boolean declarationTerminator) {
        if (delimiter == null) {
            CssPropertyNameInsertHandler.$$$reportNull$$$0(0);
        }
        this.myAddDeclarationTerminator = declarationTerminator;
        this.myDelimiter = delimiter;
    }

    public void handleInsert(InsertionContext context, LookupElement item) {
        context.setAddCompletionChar(false);
        PsiElement elementAtCaret = context.getFile().findElementAt(context.getStartOffset());
        if (elementAtCaret == null) {
            return;
        }
        PsiElement nextVisibleSibling = PsiTreeUtil.nextVisibleLeaf((PsiElement)elementAtCaret);
        PsiElement prevVisibleSibling = PsiTreeUtil.prevLeaf((PsiElement)elementAtCaret, (boolean)true);
        if (nextVisibleSibling == null || !nextVisibleSibling.getText().equals(":")) {
            Editor editor = context.getEditor();
            int offset = editor.getCaretModel().getOffset();
            Document document = editor.getDocument();
            if (!(document.getTextLength() < offset || prevVisibleSibling != null && prevVisibleSibling.getText().equals(":"))) {
                CodeStyleSettings globalSettings = CodeStyleSettingsManager.getSettings((Project)context.getProject());
                CssCodeStyleSettings settings = (CssCodeStyleSettings)globalSettings.getCustomSettings(CssCodeStyleSettings.class);
                String elementTerminator = settings.SPACE_AFTER_COLON ? this.myDelimiter + " " : this.myDelimiter;
                String declarationsTerminator = this.myAddDeclarationTerminator ? CssPsiUtil.getDeclarationsTerminatorFromContext((PsiElement)elementAtCaret) : "";
                int lineNumber = document.getLineNumber(offset);
                boolean isLastStatementInLine = nextVisibleSibling == null || document.getLineEndOffset(lineNumber) < nextVisibleSibling.getTextRange().getStartOffset();
                document.insertString(offset, (CharSequence)elementTerminator);
                if (isLastStatementInLine) {
                    document.insertString(offset + elementTerminator.length(), (CharSequence)declarationsTerminator);
                }
                editor.getCaretModel().moveToOffset(offset + elementTerminator.length());
                AutoPopupController.getInstance((Project)context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
            } else if (document.getTextLength() >= offset) {
                document.insertString(offset, (CharSequence)" ");
                editor.getCaretModel().moveToOffset(offset + 1);
                AutoPopupController.getInstance((Project)context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delimiter", "com/intellij/psi/css/impl/util/completion/handler/CssPropertyNameInsertHandler", "<init>"));
    }
}

