/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import java.awt.Color;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CssConvertColorToRgbInspection
extends CssBaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"css.inspections.convert.color.to.rgb", (Object[])new Object[0]);
        if (string == null) {
            CssConvertColorToRgbInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("CssConvertColorToRgbInspection" == null) {
            CssConvertColorToRgbInspection.$$$reportNull$$$0(1);
        }
        return "CssConvertColorToRgbInspection";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssConvertColorToRgbInspection.$$$reportNull$$$0(2);
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssTerm(CssTerm _term) {
                super.visitCssTerm(_term);
                if (CssTermTypes.COLOR == _term.getTermType() && !CssConvertColorToRgbInspection.isColorFunction((PsiElement)_term)) {
                    holder.registerProblem((PsiElement)_term, CssBundle.message((String)"css.convert.color.value.to.rgb", (Object[])new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new ConvertToRGBFix()});
                }
            }
        };
        if (cssElementVisitor == null) {
            CssConvertColorToRgbInspection.$$$reportNull$$$0(3);
        }
        return cssElementVisitor;
    }

    private static boolean isColorFunction(PsiElement element) {
        if (element instanceof CssTerm && CssTermTypes.COLOR == ((CssTerm)element).getTermType()) {
            ColorDeclarationType type = ColorDeclarationType.fromColorTerm(element);
            return type == ColorDeclarationType.RGB || type == ColorDeclarationType.RGBA;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/CssConvertColorToRgbInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/CssConvertColorToRgbInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConvertToRGBFix
    implements LocalQuickFix {
        private ConvertToRGBFix() {
        }

        @NotNull
        public String getName() {
            String string = CssBundle.message((String)"css.convert.color.value.to.rgb", (Object[])new Object[0]);
            if (string == null) {
                ConvertToRGBFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CssBundle.message((String)"css.convert.color.to.rgb.family", (Object[])new Object[0]);
            if (string == null) {
                ConvertToRGBFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                ConvertToRGBFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ConvertToRGBFix.$$$reportNull$$$0(3);
            }
            if (!((element = descriptor.getPsiElement()) instanceof CssTerm)) {
                return;
            }
            final CssTerm term = (CssTerm)element;
            PsiFile psiFile = term.getContainingFile();
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            new WriteCommandAction(project, new PsiFile[]{psiFile}){

                protected void run(@NotNull Result result) {
                    Color color;
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((color = CssPsiColorUtil.getColor((PsiElement)term)) != null) {
                        Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)term);
                        term.replace((PsiElement)CssElementFactory.getInstance((Project)project).createTerm(CssPsiColorUtil.toRgbColor(color), language));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/inspections/CssConvertColorToRgbInspection$ConvertToRGBFix$1", "run"));
                }
            }.execute();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/CssConvertColorToRgbInspection$ConvertToRGBFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/CssConvertColorToRgbInspection$ConvertToRGBFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

