/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.model;

import com.intellij.guice.model.GuiceInjectorManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectionPointDescriptor {
    private final PsiModifierListOwner myOwner;

    public InjectionPointDescriptor(PsiModifierListOwner owner) {
        this.myOwner = owner;
    }

    @Nullable
    public PsiType getType() {
        if (this.myOwner instanceof PsiField) {
            return ((PsiField)this.myOwner).getType();
        }
        if (this.myOwner instanceof PsiParameter) {
            return ((PsiParameter)this.myOwner).getType();
        }
        return null;
    }

    public Set<PsiAnnotation> getBindingAnnotations() {
        return GuiceInjectorManager.getBindingAnnotations(this.myOwner);
    }

    @NotNull
    public PsiModifierListOwner getOwner() {
        PsiModifierListOwner psiModifierListOwner = this.myOwner;
        if (psiModifierListOwner == null) {
            InjectionPointDescriptor.$$$reportNull$$$0(0);
        }
        return psiModifierListOwner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InjectionPointDescriptor)) {
            return false;
        }
        InjectionPointDescriptor that = (InjectionPointDescriptor)o;
        return !(this.myOwner != null ? !this.myOwner.equals(that.myOwner) : that.myOwner != null);
    }

    public int hashCode() {
        return this.myOwner != null ? this.myOwner.hashCode() : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/InjectionPointDescriptor", "getOwner"));
    }
}

