/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.hibernate.HibernateMessages;
import com.intellij.hibernate.facet.HibernateFacet;
import com.intellij.hibernate.facet.HibernateFacetConfiguration;
import com.intellij.hibernate.model.HibernateDescriptorsConstants;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.persistence.facet.PersistenceFacetType;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.descriptors.ConfigFileMetaDataRegistry;
import com.intellij.util.indexing.FileContent;
import icons.HibernateCoreIcons;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateFacetType
extends PersistenceFacetType<HibernateFacet, HibernateFacetConfiguration> {
    HibernateFacetType() {
        super(HibernateFacet.ID, "hibernate", HibernateMessages.message("hibernate.facet.type.presentable.name", new Object[0]));
    }

    public static HibernateFacetType getInstance() {
        return (HibernateFacetType)HibernateFacetType.findInstance(HibernateFacetType.class);
    }

    public HibernateFacetConfiguration createDefaultConfiguration() {
        ConfigFileFactory factory = ConfigFileFactory.getInstance();
        ConfigFileMetaDataRegistry metadataRegistry = factory.createMetaDataRegistry();
        metadataRegistry.registerMetaData(new ConfigFileMetaData[]{HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA});
        return new HibernateFacetConfiguration(factory.createConfigFileInfoSet((ConfigFileMetaDataProvider)metadataRegistry));
    }

    public HibernateFacet createFacet(@NotNull Module module, String name, @NotNull HibernateFacetConfiguration configuration, @Nullable Facet underlyingFacet) {
        if (module == null) {
            HibernateFacetType.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            HibernateFacetType.$$$reportNull$$$0(1);
        }
        return new HibernateFacet((FacetType<HibernateFacet, HibernateFacetConfiguration>)this, module, name, configuration, underlyingFacet);
    }

    public boolean isSuitableModuleType(ModuleType moduleType) {
        return moduleType instanceof JavaModuleType;
    }

    @Nullable
    public Icon getIcon() {
        return HibernateCoreIcons.AddHibernateSupport;
    }

    public String getHelpTopic() {
        return "IntelliJ.IDEA.Procedures.Java.EE.Development.Managing.Facets.Facet.Specific.Settings.Hibernate";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
        }
        objectArray[1] = "com/intellij/hibernate/facet/HibernateFacetType";
        objectArray[2] = "createFacet";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class HibernateFrameworkDetector
    extends FacetBasedFrameworkDetector<HibernateFacet, HibernateFacetConfiguration> {
        public HibernateFrameworkDetector() {
            super("hibernate");
        }

        @NotNull
        public FacetType<HibernateFacet, HibernateFacetConfiguration> getFacetType() {
            HibernateFacetType hibernateFacetType = HibernateFacetType.getInstance();
            if (hibernateFacetType == null) {
                HibernateFrameworkDetector.$$$reportNull$$$0(0);
            }
            return hibernateFacetType;
        }

        protected HibernateFacetConfiguration createConfiguration(Collection<VirtualFile> files) {
            HibernateFacetConfiguration configuration = (HibernateFacetConfiguration)this.getFacetType().createDefaultConfiguration();
            for (VirtualFile file : files) {
                configuration.getDescriptorsConfiguration().addConfigFile(HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA, file.getUrl());
            }
            return configuration;
        }

        @NotNull
        public FileType getFileType() {
            LanguageFileType languageFileType = StdFileTypes.XML;
            if (languageFileType == null) {
                HibernateFrameworkDetector.$$$reportNull$$$0(1);
            }
            return languageFileType;
        }

        @NotNull
        public ElementPattern<FileContent> createSuitableFilePattern() {
            FileContentPattern fileContentPattern = FileContentPattern.fileContent().xmlWithRootTag("hibernate-configuration");
            if (fileContentPattern == null) {
                HibernateFrameworkDetector.$$$reportNull$$$0(2);
            }
            return fileContentPattern;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/hibernate/facet/HibernateFacetType$HibernateFrameworkDetector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFacetType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSuitableFilePattern";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

