/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.annotators;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.struts2.StrutsBundle;
import com.intellij.struts2.StrutsIcons;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.facet.StrutsFacet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlTagUtil;
import icons.Struts2Icons;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspActionAnnotator
extends LineMarkerProviderDescriptor {
    @NonNls
    private static final String ACTION_ATTRIBUTE_NAME = "action";
    @NonNls
    private static final String[] TAGS_WITH_ACTION_ATTRIBUTE = new String[]{"action", "form", "reset", "submit", "url"};

    public String getId() {
        return "JspActionAnnotator";
    }

    @NotNull
    public String getName() {
        if ("Action (JSP)" == null) {
            JspActionAnnotator.$$$reportNull$$$0(0);
        }
        return "Action (JSP)";
    }

    @Nullable
    public Icon getIcon() {
        return Struts2Icons.Action;
    }

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            JspActionAnnotator.$$$reportNull$$$0(1);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> psiElements, @NotNull Collection<LineMarkerInfo> lineMarkerInfos) {
        if (psiElements == null) {
            JspActionAnnotator.$$$reportNull$$$0(2);
        }
        if (lineMarkerInfos == null) {
            JspActionAnnotator.$$$reportNull$$$0(3);
        }
        if (psiElements.isEmpty()) {
            return;
        }
        for (PsiElement element : psiElements) {
            JspActionAnnotator.annotate(element, lineMarkerInfos);
        }
    }

    private static void annotate(@NotNull PsiElement element, @NotNull Collection<LineMarkerInfo> lineMarkerInfos) {
        String actionPath;
        if (element == null) {
            JspActionAnnotator.$$$reportNull$$$0(4);
        }
        if (lineMarkerInfos == null) {
            JspActionAnnotator.$$$reportNull$$$0(5);
        }
        if (!(element instanceof XmlTag)) {
            return;
        }
        XmlTag xmlTag = (XmlTag)element;
        String tagName = xmlTag.getLocalName();
        if (Arrays.binarySearch(TAGS_WITH_ACTION_ATTRIBUTE, tagName) < 0) {
            return;
        }
        if (!Comparing.equal((String)xmlTag.getNamespace(), (String)"/struts-tags")) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        if (StrutsFacet.getInstance(module) == null) {
            return;
        }
        String string = actionPath = Comparing.equal((String)tagName, (String)ACTION_ATTRIBUTE_NAME) ? xmlTag.getAttributeValue("name") : xmlTag.getAttributeValue(ACTION_ATTRIBUTE_NAME);
        if (actionPath == null) {
            return;
        }
        StrutsModel strutsModel = StrutsManager.getInstance(element.getProject()).getCombinedModel(module);
        if (strutsModel == null) {
            return;
        }
        String namespace = xmlTag.getAttributeValue("namespace");
        final List<Action> actions = strutsModel.findActionsByName(actionPath, namespace);
        if (actions.isEmpty()) {
            return;
        }
        NavigationGutterIconBuilder gutterIconBuilder = NavigationGutterIconBuilder.create((Icon)StrutsIcons.ACTION_CLASS).setAlignment(GutterIconRenderer.Alignment.LEFT).setTooltipText(StrutsBundle.message("annotators.jsp.goto.action.method", new Object[0])).setEmptyPopupText(StrutsBundle.message("annotators.jsp.goto.action.method.not.found", new Object[0])).setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends PsiElement>>(){

            @NotNull
            protected Collection<PsiMethod> compute() {
                List list = ContainerUtil.mapNotNull((Collection)actions, Action::searchActionMethod);
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/annotators/JspActionAnnotator$1", "compute"));
            }
        });
        XmlToken identifier = XmlTagUtil.getStartTagNameElement((XmlTag)xmlTag);
        if (identifier != null) {
            lineMarkerInfos.add((LineMarkerInfo)gutterIconBuilder.createLineMarkerInfo((PsiElement)identifier));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/struts2/annotators/JspActionAnnotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElements";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineMarkerInfos";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/struts2/annotators/JspActionAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

