/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.ExecutionNodeProgressAnimator;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.SkippedResult;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionNode
extends CachingSimpleNode {
    private final List<ExecutionNode> k = ContainerUtil.newSmartList();
    private long f;
    private long c;
    @Nullable
    private String e;
    @Nullable
    private String h;
    @Nullable
    private String b;
    @Nullable
    private EventResult g;
    private boolean i;
    @Nullable
    private Navigatable j;
    @Nullable
    private NullableLazyValue<Icon> a;
    private final AtomicInteger d = new AtomicInteger();
    private final AtomicInteger l = new AtomicInteger();

    public ExecutionNode(Project project2, ExecutionNode executionNode) {
        super(project2, (NodeDescriptor)executionNode);
    }

    protected SimpleNode[] buildChildren() {
        return this.k.size() == 0 ? NO_CHILDREN : (SimpleNode[])ContainerUtil.toArray(this.k, (Object[])new ExecutionNode[this.k.size()]);
    }

    protected void update(PresentationData presentationData) {
        this.setIcon(this.b());
        presentationData.setPresentableText(this.myName);
        presentationData.setIcon(this.getIcon());
        if (this.e != null) {
            presentationData.addText(this.e + ": ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        String string = this.a();
        if (this.e != null || string != null) {
            presentationData.addText(this.myName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (string != null) {
            presentationData.addText("  " + string, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (this.h != null) {
            presentationData.setTooltip(this.h);
        }
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String string) {
        this.myName = string;
    }

    @Nullable
    public String getTitle() {
        return this.e;
    }

    public void setTitle(@Nullable String string) {
        this.e = string;
    }

    @Nullable
    public String getTooltip() {
        return this.h;
    }

    public void setTooltip(@Nullable String string) {
        this.h = string;
    }

    @Nullable
    public String getHint() {
        return this.b;
    }

    public void setHint(@Nullable String string) {
        this.b = string;
    }

    public void add(ExecutionNode executionNode) {
        this.k.add(executionNode);
        this.cleanUpCache();
    }

    public void add(int n2, ExecutionNode executionNode) {
        this.k.add(n2, executionNode);
        this.cleanUpCache();
    }

    void removeChildren() {
        this.k.clear();
        this.cleanUpCache();
    }

    @Nullable
    public String getDuration() {
        if (this.f == this.c) {
            return null;
        }
        if (this.isRunning()) {
            long l2 = this.f == 0L ? 0L : System.currentTimeMillis() - this.f;
            String string = StringUtil.formatDuration((long)l2);
            int n2 = string.indexOf("s ");
            if (n2 != -1) {
                string = string.substring(0, n2 + 1);
            }
            return "Running for " + string;
        }
        return this.isSkipped() ? null : StringUtil.formatDuration((long)(this.c - this.f));
    }

    public long getStartTime() {
        return this.f;
    }

    public void setStartTime(long l2) {
        this.f = l2;
    }

    public long getEndTime() {
        return this.c;
    }

    public void setEndTime(long l2) {
        this.c = l2;
    }

    public boolean isFailed() {
        return this.g instanceof FailureResult;
    }

    public boolean isSkipped() {
        return this.g instanceof SkippedResult;
    }

    public boolean isRunning() {
        return this.c <= 0L && !this.isSkipped() && !this.isFailed();
    }

    public void setResult(@Nullable EventResult eventResult) {
        this.g = eventResult;
    }

    @Nullable
    public EventResult getResult() {
        return this.g;
    }

    public boolean isAutoExpandNode() {
        return this.i;
    }

    public void setAutoExpandNode(boolean bl2) {
        this.i = bl2;
    }

    public void setNavigatable(@Nullable Navigatable navigatable) {
        this.j = navigatable;
    }

    @NotNull
    public List<Navigatable> getNavigatables() {
        if (this.j != null) {
            List<Navigatable> list2 = Collections.singletonList(this.j);
            if (list2 == null) {
                ExecutionNode.a(0);
            }
            return list2;
        }
        if (this.g == null) {
            List<Navigatable> list3 = Collections.emptyList();
            if (list3 == null) {
                ExecutionNode.a(1);
            }
            return list3;
        }
        if (this.g instanceof FailureResult) {
            SmartList smartList = new SmartList();
            for (Failure failure : ((FailureResult)this.g).getFailures()) {
                ContainerUtil.addIfNotNull((Collection)smartList, (Object)failure.getNavigatable());
            }
            SmartList smartList2 = smartList;
            if (smartList2 == null) {
                ExecutionNode.a(2);
            }
            return smartList2;
        }
        List<Navigatable> list4 = Collections.emptyList();
        if (list4 == null) {
            ExecutionNode.a(3);
        }
        return list4;
    }

    public void setIconProvider(final Supplier<Icon> supplier) {
        this.a = new NullableLazyValue<Icon>(){

            @Nullable
            protected Icon compute() {
                return (Icon)supplier.get();
            }
        };
    }

    public void reportChildMessageKind(MessageEvent.Kind kind) {
        if (kind == MessageEvent.Kind.ERROR) {
            this.d.incrementAndGet();
        } else if (kind == MessageEvent.Kind.WARNING) {
            this.l.incrementAndGet();
        }
    }

    private String a() {
        String string = this.b;
        int n2 = this.l.get();
        int n3 = this.d.get();
        if (n2 > 0 || n3 > 0) {
            if (string == null) {
                string = "";
            }
            string = string + (this.getParent() == null ? (this.isRunning() ? "   " : "   with ") : " (");
            if (n3 > 0) {
                string = string + n3 + " " + StringUtil.pluralize((String)"error", (int)n3);
                if (n2 > 0) {
                    string = string + ", ";
                }
            }
            if (n2 > 0) {
                string = string + n2 + " " + StringUtil.pluralize((String)"warning", (int)n2);
            }
            if (this.getParent() != null) {
                string = string + ")";
            }
        }
        return string;
    }

    private Icon b() {
        if (this.a != null) {
            return (Icon)this.a.getValue();
        }
        if (this.g instanceof MessageEventResult) {
            return ExecutionNode.a(((MessageEventResult)this.g).getKind());
        }
        return this.isRunning() ? ExecutionNodeProgressAnimator.getCurrentFrame() : (this.isFailed() ? AllIcons.Process.State.RedExcl : (this.isSkipped() ? AllIcons.Process.State.YellowStr : AllIcons.Process.State.GreenOK));
    }

    private static Icon a(MessageEvent.Kind kind) {
        switch (kind) {
            case ERROR: {
                return AllIcons.General.Error;
            }
            case WARNING: {
                return AllIcons.General.Warning;
            }
            case INFO: {
                return AllIcons.General.Information;
            }
            case STATISTICS: {
                return AllIcons.General.Mdot_empty;
            }
            case SIMPLE: {
                return AllIcons.General.Mdot_empty;
            }
        }
        return AllIcons.General.Mdot_empty;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/build/ExecutionNode", "getNavigatables"));
    }
}

