/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.ExecutionNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class ExecutionNodeProgressAnimator
implements Runnable,
Disposable {
    private static final int a = 8;
    private static final int g = 1200;
    private static final int f = 150;
    public static final Icon[] FRAMES = new Icon[8];
    private long d = -1L;
    private Alarm e;
    private final List<ExecutionNode> b = new SmartList();
    private BuildTreeConsoleView c;

    public ExecutionNodeProgressAnimator(BuildTreeConsoleView buildTreeConsoleView) {
        Disposer.register((Disposable)buildTreeConsoleView, (Disposable)this);
        this.e = new Alarm();
        this.c = buildTreeConsoleView;
    }

    public static int getCurrentFrameIndex() {
        return (int)(System.currentTimeMillis() % 1200L / 150L);
    }

    public static Icon getCurrentFrame() {
        return FRAMES[ExecutionNodeProgressAnimator.getCurrentFrameIndex()];
    }

    @Override
    public void run() {
        long l2;
        if (!this.b.isEmpty() && (l2 = System.currentTimeMillis()) - this.d >= 150L) {
            this.c();
            this.d = l2;
        }
        this.a();
    }

    public void addNode(@Nullable ExecutionNode executionNode) {
        this.b.add(executionNode);
    }

    public void startMovie() {
        this.a();
    }

    public void stopMovie() {
        this.c();
        for (ExecutionNode executionNode : this.b) {
            executionNode.setIconProvider(() -> AllIcons.Process.State.YellowStr);
            executionNode.setEndTime(System.currentTimeMillis());
        }
        this.b.clear();
        this.b();
    }

    public void dispose() {
        this.c = null;
        this.b.clear();
        this.b();
    }

    private void b() {
        if (this.e != null) {
            this.e.cancelAllRequests();
            this.e = null;
        }
    }

    private void c() {
        if (this.c == null || this.c.isDisposed()) {
            return;
        }
        Iterator<ExecutionNode> iterator = this.b.iterator();
        while (iterator.hasNext()) {
            ExecutionNode executionNode = iterator.next();
            this.c.scheduleUpdate(executionNode);
            if (executionNode.isRunning()) continue;
            iterator.remove();
        }
    }

    private void a() {
        if (this.e == null) {
            return;
        }
        this.e.cancelAllRequests();
        this.e.addRequest((Runnable)this, 150);
    }

    static {
        ExecutionNodeProgressAnimator.FRAMES[0] = AllIcons.Process.State.GreyProgr_1;
        ExecutionNodeProgressAnimator.FRAMES[1] = AllIcons.Process.State.GreyProgr_2;
        ExecutionNodeProgressAnimator.FRAMES[2] = AllIcons.Process.State.GreyProgr_3;
        ExecutionNodeProgressAnimator.FRAMES[3] = AllIcons.Process.State.GreyProgr_4;
        ExecutionNodeProgressAnimator.FRAMES[4] = AllIcons.Process.State.GreyProgr_5;
        ExecutionNodeProgressAnimator.FRAMES[5] = AllIcons.Process.State.GreyProgr_6;
        ExecutionNodeProgressAnimator.FRAMES[6] = AllIcons.Process.State.GreyProgr_7;
        ExecutionNodeProgressAnimator.FRAMES[7] = AllIcons.Process.State.GreyProgr_8;
    }
}

