/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ProjectTopics;
import com.intellij.codeEditor.JavaEditorFileSwapper;
import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.LibrarySourceRootDetectorUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.GuiUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttachSourcesNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final ExtensionPointName<AttachSourcesProvider> a = new ExtensionPointName("com.intellij.attachSourcesProvider");
    private static final Key<EditorNotificationPanel> b = Key.create((String)"add sources to class");
    private final Project c;

    public AttachSourcesNotificationProvider(Project project2, final EditorNotifications editorNotifications) {
        this.c = project2;
        this.c.getMessageBus().connect((Disposable)project2).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent moduleRootEvent) {
                editorNotifications.updateAllNotifications();
            }
        });
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = b;
        if (key == null) {
            AttachSourcesNotificationProvider.a(0);
        }
        return key;
    }

    /*
     * WARNING - void declaration
     */
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile virtualFile, @NotNull FileEditor fileEditor) {
        if (virtualFile == null) {
            AttachSourcesNotificationProvider.a(1);
        }
        if (fileEditor == null) {
            AttachSourcesNotificationProvider.a(2);
        }
        if (virtualFile.getFileType() != JavaClassFileType.INSTANCE) {
            return null;
        }
        EditorNotificationPanel editorNotificationPanel = new EditorNotificationPanel();
        String string = ProjectBundle.message((String)"class.file.decompiled.text", (Object[])new Object[0]);
        String string2 = AttachSourcesNotificationProvider.b(virtualFile);
        if (string2 != null) {
            string = string + ", " + string2;
        }
        editorNotificationPanel.setText(string);
        VirtualFile virtualFile2 = JavaEditorFileSwapper.findSourceFile((Project)this.c, (VirtualFile)virtualFile);
        if (virtualFile2 == null) {
            List<LibraryOrderEntry> list2 = this.c(virtualFile);
            if (list2 != null) {
                void var11_14;
                void var13_18;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                PsiFile psiFile = PsiManager.getInstance((Project)this.c).findFile(virtualFile);
                boolean bl2 = false;
                AttachSourcesProvider[] object = (AttachSourcesProvider[])Extensions.getExtensions(a);
                int n2 = object.length;
                boolean bl3 = false;
                while (var13_18 < n2) {
                    AttachSourcesProvider attachSourcesProvider = object[var13_18];
                    for (AttachSourcesProvider.AttachSourcesAction attachSourcesAction3 : attachSourcesProvider.getActions(list2, psiFile)) {
                        if (bl2) {
                            if (attachSourcesAction3 instanceof AttachSourcesProvider.LightAttachSourcesAction) {
                                continue;
                            }
                        } else if (!(attachSourcesAction3 instanceof AttachSourcesProvider.LightAttachSourcesAction)) {
                            arrayList.clear();
                            bl2 = true;
                        }
                        arrayList.add(attachSourcesAction3);
                    }
                    ++var13_18;
                }
                Collections.sort(arrayList, (attachSourcesAction, attachSourcesAction2) -> attachSourcesAction.getName().compareToIgnoreCase(attachSourcesAction2.getName()));
                if (AttachSourcesNotificationProvider.a(virtualFile) != null) {
                    AttachJarAsSourcesAction attachJarAsSourcesAction = new AttachJarAsSourcesAction(virtualFile);
                } else {
                    ChooseAndAttachSourcesAction chooseAndAttachSourcesAction = new ChooseAndAttachSourcesAction(this.c, (JComponent)editorNotificationPanel);
                }
                arrayList.add(var11_14);
                for (AttachSourcesProvider.AttachSourcesAction attachSourcesAction4 : arrayList) {
                    editorNotificationPanel.createActionLabel(GuiUtils.getTextWithoutMnemonicEscaping((String)attachSourcesAction4.getName()), () -> {
                        List<LibraryOrderEntry> list3;
                        if (virtualFile == null) {
                            AttachSourcesNotificationProvider.a(3);
                        }
                        if (!Comparing.equal((Object)list2, list3 = this.c(virtualFile))) {
                            Messages.showErrorDialog((Project)this.c, (String)("Can't find library for " + virtualFile.getName()), (String)"Error");
                            return;
                        }
                        editorNotificationPanel.setText(attachSourcesAction4.getBusyText());
                        attachSourcesAction4.perform(list3);
                    });
                }
            }
        } else {
            editorNotificationPanel.createActionLabel(ProjectBundle.message((String)"class.file.open.source.action", (Object[])new Object[0]), () -> {
                OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(this.c, virtualFile2);
                FileEditorManager.getInstance((Project)this.c).openTextEditor(openFileDescriptor, true);
            });
        }
        return editorNotificationPanel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String b(VirtualFile virtualFile) {
        try {
            byte[] byArray = virtualFile.contentsToByteArray(false);
            if (byArray.length <= 8) return null;
            try (DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));){
                if (dataInputStream.readInt() != -889275714) return null;
                int n2 = dataInputStream.readUnsignedShort();
                int n3 = dataInputStream.readUnsignedShort();
                StringBuilder stringBuilder = new StringBuilder().append("bytecode version: ").append(n3).append('.').append(n2);
                JavaSdkVersion javaSdkVersion = ClsParsingUtil.getJdkVersionByBytecode((int)n3);
                if (javaSdkVersion != null) {
                    stringBuilder.append(" (Java ").append(javaSdkVersion.getDescription()).append(')');
                }
                String string = stringBuilder.toString();
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private List<LibraryOrderEntry> c(VirtualFile virtualFile) {
        List list2 = null;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.c);
        for (OrderEntry orderEntry : projectFileIndex.getOrderEntriesForFile(virtualFile)) {
            if (!(orderEntry instanceof LibraryOrderEntry)) continue;
            if (list2 == null) {
                list2 = ContainerUtil.newSmartList();
            }
            list2.add((LibraryOrderEntry)orderEntry);
        }
        return list2;
    }

    @Nullable
    private static VirtualFile a(VirtualFile virtualFile) {
        String string = virtualFile.getName();
        int n2 = string.indexOf(36);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        if ((n2 = string.indexOf(46)) != -1) {
            string = string.substring(0, n2);
        }
        return virtualFile.getParent().findChild(string + ".java");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createNotificationPanel$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChooseAndAttachSourcesAction
    implements AttachSourcesProvider.AttachSourcesAction {
        private final Project a;
        private final JComponent b;

        public ChooseAndAttachSourcesAction(Project project2, JComponent jComponent) {
            this.a = project2;
            this.b = jComponent;
        }

        public String getName() {
            return ProjectBundle.message((String)"module.libraries.choose.sources.button", (Object[])new Object[0]);
        }

        public String getBusyText() {
            return ProjectBundle.message((String)"library.attach.sources.action.busy.text", (Object[])new Object[0]);
        }

        public ActionCallback perform(List<LibraryOrderEntry> list2) {
            FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createMultipleJavaPathDescriptor();
            fileChooserDescriptor.setTitle(ProjectBundle.message((String)"library.attach.sources.action", (Object[])new Object[0]));
            fileChooserDescriptor.setDescription(ProjectBundle.message((String)"library.attach.sources.description", (Object[])new Object[0]));
            Library library = list2.get(0).getLibrary();
            VirtualFile[] virtualFileArray = library != null ? library.getFiles(OrderRootType.CLASSES) : VirtualFile.EMPTY_ARRAY;
            VirtualFile[] virtualFileArray2 = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)this.a, virtualFileArray.length == 0 ? null : VfsUtil.getLocalFile((VirtualFile)virtualFileArray[0]));
            if (virtualFileArray2.length == 0) {
                return ActionCallback.REJECTED;
            }
            final VirtualFile[] virtualFileArray3 = LibrarySourceRootDetectorUtil.scanAndSelectDetectedJavaSourceRoots(this.b, virtualFileArray2);
            if (virtualFileArray3.length == 0) {
                return ActionCallback.REJECTED;
            }
            final HashMap<Library, LibraryOrderEntry> hashMap = new HashMap<Library, LibraryOrderEntry>();
            for (Object object : list2) {
                hashMap.put(object.getLibrary(), (LibraryOrderEntry)object);
            }
            if (hashMap.size() == 1) {
                ChooseAndAttachSourcesAction.b(library, virtualFileArray3);
            } else {
                Object object;
                hashMap.put(null, null);
                String string = ProjectBundle.message((String)"library.choose.one.to.attach", (Object[])new Object[0]);
                object = ContainerUtil.newArrayList(hashMap.values());
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<LibraryOrderEntry>(string, (List)object){

                    public ListSeparator getSeparatorAbove(LibraryOrderEntry libraryOrderEntry) {
                        return libraryOrderEntry == null ? new ListSeparator() : null;
                    }

                    @NotNull
                    public String getTextFor(LibraryOrderEntry libraryOrderEntry) {
                        String string = libraryOrderEntry == null ? "All" : libraryOrderEntry.getPresentableName() + " (" + libraryOrderEntry.getOwnerModule().getName() + ")";
                        if (string == null) {
                            1.a(0);
                        }
                        return string;
                    }

                    public PopupStep onChosen(LibraryOrderEntry libraryOrderEntry, boolean bl2) {
                        if (libraryOrderEntry != null) {
                            ChooseAndAttachSourcesAction.b(libraryOrderEntry.getLibrary(), virtualFileArray3);
                        } else {
                            for (Library library : hashMap.keySet()) {
                                if (library == null) continue;
                                ChooseAndAttachSourcesAction.b(library, virtualFileArray3);
                            }
                        }
                        return FINAL_CHOICE;
                    }

                    private static /* synthetic */ void a(int n2) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider$ChooseAndAttachSourcesAction$1", "getTextFor"));
                    }
                }).showCenteredInCurrentWindow(this.a);
            }
            return ActionCallback.DONE;
        }

        private static void b(Library library, VirtualFile[] virtualFileArray) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                Library.ModifiableModel modifiableModel = library.getModifiableModel();
                for (VirtualFile virtualFile : virtualFileArray) {
                    modifiableModel.addRoot(virtualFile, OrderRootType.SOURCES);
                }
                modifiableModel.commit();
            });
        }
    }

    private static class AttachJarAsSourcesAction
    implements AttachSourcesProvider.AttachSourcesAction {
        private final VirtualFile a;

        public AttachJarAsSourcesAction(VirtualFile virtualFile) {
            this.a = virtualFile;
        }

        public String getName() {
            return ProjectBundle.message((String)"module.libraries.attach.sources.button", (Object[])new Object[0]);
        }

        public String getBusyText() {
            return ProjectBundle.message((String)"library.attach.sources.action.busy.text", (Object[])new Object[0]);
        }

        public ActionCallback perform(List<LibraryOrderEntry> list2) {
            final ArrayList<Library.ModifiableModel> arrayList = new ArrayList<Library.ModifiableModel>();
            for (LibraryOrderEntry libraryOrderEntry : list2) {
                VirtualFile virtualFile;
                Library library = libraryOrderEntry.getLibrary();
                if (library == null || (virtualFile = this.a(library)) == null) continue;
                Library.ModifiableModel modifiableModel = library.getModifiableModel();
                modifiableModel.addRoot(virtualFile, OrderRootType.SOURCES);
                arrayList.add(modifiableModel);
            }
            if (arrayList.isEmpty()) {
                return ActionCallback.REJECTED;
            }
            new WriteAction(){

                protected void run(@NotNull Result result2) {
                    if (result2 == null) {
                        1.a(0);
                    }
                    for (Library.ModifiableModel modifiableModel : arrayList) {
                        modifiableModel.commit();
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider$AttachJarAsSourcesAction$1", "run"));
                }
            }.execute();
            return ActionCallback.DONE;
        }

        @Nullable
        private VirtualFile a(Library library) {
            for (VirtualFile virtualFile : library.getFiles(OrderRootType.CLASSES)) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)this.a, (boolean)true)) continue;
                return virtualFile;
            }
            return null;
        }
    }
}

