/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;

public abstract class CompileActionBase
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent anActionEvent) {
        DataContext dataContext = anActionEvent.getDataContext();
        Project project2 = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        Editor editor = (Editor)anActionEvent.getData(CommonDataKeys.EDITOR);
        PsiFile psiFile = (PsiFile)anActionEvent.getData(CommonDataKeys.PSI_FILE);
        if (psiFile != null && editor != null && !DumbService.getInstance((Project)project2).isDumb()) {
            DaemonCodeAnalyzer.getInstance((Project)project2).autoImportReferenceAtCursor(editor, psiFile);
        }
        this.doAction(dataContext, project2);
    }

    protected abstract void doAction(DataContext var1, Project var2);

    public void update(AnActionEvent anActionEvent) {
        super.update(anActionEvent);
        Project project2 = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            anActionEvent.getPresentation().setEnabled(false);
        } else {
            anActionEvent.getPresentation().setEnabled(!CompilerManager.getInstance((Project)project2).isCompilationActive());
        }
    }
}

