/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Comment;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationOptionsImpl;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.LibraryDefinitionsGeneratorFactory;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.taskdefs.Path;
import com.intellij.compiler.ant.taskdefs.PathElement;
import com.intellij.compiler.ant.taskdefs.PathRef;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ModuleChunkClasspath
extends Path {
    public ModuleChunkClasspath(final ModuleChunk moduleChunk, final GenerationOptions generationOptions, final boolean bl2, final boolean bl3) {
        super(ModuleChunkClasspath.a(moduleChunk, bl2, bl3));
        final OrderedSet orderedSet = new OrderedSet();
        final String string = BuildProperties.getModuleChunkBasedirProperty((ModuleChunk)moduleChunk);
        Module[] moduleArray = moduleChunk.getModules();
        final HashSet hashSet = new HashSet();
        final HashSet hashSet2 = new HashSet();
        for (Module module2 : moduleArray) {
            new Object(){

                public void processModule(Module module2, int n2, boolean bl22) {
                    if (hashSet2.contains(module2)) {
                        return;
                    }
                    if (!(n2 <= 1 || bl22 || generationOptions.inlineRuntimeClasspath && bl2)) {
                        return;
                    }
                    hashSet2.add(module2);
                    ProjectEx projectEx = (ProjectEx)moduleChunk.getProject();
                    File file = BuildProperties.getProjectBaseDir((Project)projectEx);
                    OrderEnumerator orderEnumerator = ModuleRootManager.getInstance((Module)module2).orderEntries();
                    if (bl2) {
                        orderEnumerator = orderEnumerator.runtimeOnly();
                    } else {
                        orderEnumerator = orderEnumerator.compileOnly();
                        if (!bl3 && (n2 == 0 || moduleChunk.contains(module2))) {
                            orderEnumerator = orderEnumerator.withoutModuleSourceEntries();
                        }
                    }
                    if (!bl3) {
                        orderEnumerator = orderEnumerator.productionOnly();
                    }
                    orderEnumerator.forEach(orderEntry -> {
                        if (!orderEntry.isValid()) {
                            return true;
                        }
                        if (!(bl2 || orderEntry instanceof ModuleOrderEntry || orderEntry instanceof ModuleSourceOrderEntry)) {
                            boolean bl4;
                            boolean bl5 = bl4 = orderEntry instanceof ExportableOrderEntry && ((ExportableOrderEntry)orderEntry).isExported();
                            if (n2 > 0 && !bl4) {
                                return true;
                            }
                        }
                        if (orderEntry instanceof JdkOrderEntry) {
                            if (generationOptions2.forceTargetJdk && !bl2) {
                                orderedSet.add((Object)new PathRefItem(BuildProperties.propertyRef((String)BuildProperties.getModuleChunkJdkClasspathProperty((String)moduleChunk.getName()))));
                            }
                        } else if (orderEntry instanceof ModuleOrderEntry) {
                            ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                            Module module3 = moduleOrderEntry.getModule();
                            if (!moduleChunk.contains(module3)) {
                                if (bl2 && !generationOptions2.inlineRuntimeClasspath) {
                                    ModuleChunk moduleChunk2 = generationOptions.getChunkByModule(module3);
                                    if (!hashSet.contains(moduleChunk2)) {
                                        hashSet.add(moduleChunk2);
                                        String string2 = bl3 ? BuildProperties.getTestRuntimeClasspathProperty((String)moduleChunk2.getName()) : BuildProperties.getRuntimeClasspathProperty((String)moduleChunk2.getName());
                                        orderedSet.add((Object)new PathRefItem(string2));
                                    }
                                } else {
                                    this.processModule(module3, n2 + 1, moduleOrderEntry.isExported());
                                }
                            }
                        } else if (orderEntry instanceof LibraryOrderEntry) {
                            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
                            String string3 = libraryOrderEntry.getLibraryName();
                            if (((LibraryOrderEntry)orderEntry).isModuleLevel()) {
                                CompositeGenerator compositeGenerator = new CompositeGenerator();
                                compositeGenerator.setHasLeadingNewline(false);
                                LibraryDefinitionsGeneratorFactory.genLibraryContent(projectEx, generationOptions, libraryOrderEntry.getLibrary(), file, compositeGenerator);
                                orderedSet.add((Object)new GeneratorItem(string3, (Generator)compositeGenerator));
                            } else {
                                orderedSet.add((Object)new PathRefItem(BuildProperties.getLibraryPathId((String)string3)));
                            }
                        } else if (orderEntry instanceof ModuleSourceOrderEntry) {
                            for (String string4 : ModuleChunkClasspath.a(module2, (GenerationOptionsImpl)generationOptions, bl2, bl3, n2 == 0)) {
                                String string5 = generationOptions.getPropertyRefForUrl(string4 = StringUtil.trimEnd((String)string4, (String)"!/"));
                                if (string5 != null) {
                                    orderedSet.add((Object)new PathElementItem(string5));
                                    continue;
                                }
                                String string6 = VirtualFileManager.extractPath((String)string4);
                                orderedSet.add((Object)new PathElementItem(GenerationUtils.toRelativePath((String)string6, (File)moduleChunk.getBaseDir(), (String)string, (GenerationOptions)generationOptions)));
                            }
                        } else {
                            orderedSet.add((Object)new GeneratorItem(orderEntry.getClass().getName(), new Comment("Unknown OrderEntryType: " + orderEntry.getClass().getName())));
                        }
                        return true;
                    });
                }
            }.processModule(module2, 0, false);
        }
        for (ClasspathItem classpathItem : orderedSet) {
            this.add(classpathItem.toGenerator());
        }
    }

    private static String a(ModuleChunk moduleChunk, boolean bl2, boolean bl3) {
        if (bl3) {
            return bl2 ? BuildProperties.getTestRuntimeClasspathProperty((String)moduleChunk.getName()) : BuildProperties.getTestClasspathProperty((String)moduleChunk.getName());
        }
        return bl2 ? BuildProperties.getRuntimeClasspathProperty((String)moduleChunk.getName()) : BuildProperties.getClasspathProperty((String)moduleChunk.getName());
    }

    private static String[] a(Module module2, GenerationOptionsImpl generationOptionsImpl, boolean bl2, boolean bl3, boolean bl4) {
        CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module2);
        if (compilerModuleExtension == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (!bl2) {
            if (bl3) {
                return compilerModuleExtension.getOutputRootUrls(!bl4);
            }
            return bl4 ? ArrayUtil.EMPTY_STRING_ARRAY : compilerModuleExtension.getOutputRootUrls(false);
        }
        Set<String> set = generationOptionsImpl.getAllJdkUrls();
        OrderedSet orderedSet = new OrderedSet();
        ContainerUtil.addAll((Collection)orderedSet, (Object[])compilerModuleExtension.getOutputRootUrls(bl3));
        orderedSet.removeAll(set);
        return ArrayUtil.toStringArray((Collection)orderedSet);
    }

    private static class PathRefItem
    extends ClasspathItem {
        public PathRefItem(String string) {
            super(string);
        }

        @Override
        public Generator toGenerator() {
            return new PathRef(this.myValue);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PathRefItem)) {
                return false;
            }
            PathRefItem pathRefItem = (PathRefItem)object;
            return this.myValue.equals(pathRefItem.myValue);
        }

        public int hashCode() {
            return this.myValue.hashCode();
        }
    }

    private static class PathElementItem
    extends ClasspathItem {
        public PathElementItem(String string) {
            super(string);
        }

        @Override
        public Generator toGenerator() {
            return new PathElement(this.myValue);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PathElementItem)) {
                return false;
            }
            PathElementItem pathElementItem = (PathElementItem)object;
            return this.myValue.equals(pathElementItem.myValue);
        }

        public int hashCode() {
            return this.myValue.hashCode();
        }
    }

    private static class GeneratorItem
    extends ClasspathItem {
        final Generator myGenerator;

        public GeneratorItem(String string, Generator generator) {
            super(string);
            this.myGenerator = generator;
        }

        @Override
        public Generator toGenerator() {
            return this.myGenerator;
        }
    }

    private static abstract class ClasspathItem {
        protected final String myValue;

        public ClasspathItem(String string) {
            this.myValue = string;
        }

        public abstract Generator toGenerator();
    }
}

