/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.FileProcessingCompilerStateCache;
import com.intellij.compiler.impl.GenericCompilerRunner;
import com.intellij.compiler.impl.generic.GenericCompilerCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityStateFactory;
import com.intellij.openapi.compiler.generic.GenericCompiler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompilerCacheManager
implements Disposable {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.compiler.impl.CompilerCacheManager");
    private final Map<Compiler, Object> d = new HashMap<Compiler, Object>();
    private final Map<GenericCompiler<?, ?, ?>, GenericCompilerCache<?, ?, ?>> e = new HashMap();
    private final List<Disposable> c = new ArrayList<Disposable>();
    private final File f;
    private final Project b;

    public CompilerCacheManager(Project project2) {
        this.b = project2;
        this.f = CompilerPaths.getCacheStoreDirectory((Project)project2);
    }

    public static CompilerCacheManager getInstance(Project project2) {
        return (CompilerCacheManager)project2.getComponent(CompilerCacheManager.class);
    }

    public void dispose() {
        this.flushCaches();
    }

    private File a(Compiler compiler) {
        File file = new File(this.f, CompilerCacheManager.getCompilerIdString(compiler));
        file.mkdirs();
        return file;
    }

    synchronized <Key, SourceState, OutputState> GenericCompilerCache<Key, SourceState, OutputState> getGenericCompilerCache(GenericCompiler<Key, SourceState, OutputState> genericCompiler) throws IOException {
        GenericCompilerCache<Object, Object, Object> genericCompilerCache = this.e.get(genericCompiler);
        if (genericCompilerCache == null) {
            GenericCompilerCache genericCompilerCache2 = new GenericCompilerCache(genericCompiler, GenericCompilerRunner.getGenericCompilerCacheDir(this.b, genericCompiler));
            this.e.put(genericCompiler, genericCompilerCache2);
            this.c.add(() -> {
                if (a.isDebugEnabled()) {
                    a.debug("Closing cache for feneric compiler " + genericCompiler.getId());
                }
                genericCompilerCache2.close();
            });
            genericCompilerCache = genericCompilerCache2;
        }
        return genericCompilerCache;
    }

    synchronized FileProcessingCompilerStateCache getFileProcessingCompilerCache(FileProcessingCompiler fileProcessingCompiler) throws IOException {
        Object object = this.d.get(fileProcessingCompiler);
        if (object == null) {
            File file = this.a((Compiler)fileProcessingCompiler);
            FileProcessingCompilerStateCache fileProcessingCompilerStateCache = new FileProcessingCompilerStateCache(file, (ValidityStateFactory)fileProcessingCompiler);
            this.d.put((Compiler)fileProcessingCompiler, fileProcessingCompilerStateCache);
            this.c.add(() -> {
                if (a.isDebugEnabled()) {
                    a.debug("Closing cache for compiler " + fileProcessingCompiler.getDescription() + "; cache root dir: " + file);
                }
                fileProcessingCompilerStateCache.close();
            });
            object = fileProcessingCompilerStateCache;
        } else {
            a.assertTrue(object instanceof FileProcessingCompilerStateCache);
        }
        return (FileProcessingCompilerStateCache)object;
    }

    public static String getCompilerIdString(Compiler compiler) {
        String string = compiler.getDescription();
        return string.replaceAll("\\s+", "_").replaceAll("[\\.\\?]", "_").toLowerCase();
    }

    synchronized void flushCaches() {
        for (Disposable disposable : this.c) {
            try {
                Disposer.dispose((Disposable)disposable);
            }
            catch (Throwable throwable) {
                a.info(throwable);
            }
        }
        this.c.clear();
        this.e.clear();
        this.d.clear();
    }

    public void clearCaches(CompileContext compileContext) {
        this.flushCaches();
        File[] fileArray = this.f.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                boolean bl2 = FileUtil.delete((File)file);
                if (bl2) continue;
                compileContext.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"compiler.error.failed.to.delete", (Object[])new Object[]{file.getPath()}), null, -1, -1);
            }
        }
    }
}

