/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.StateCache;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.ValidityStateFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class FileProcessingCompilerStateCache {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.compiler.impl.FileProcessingCompilerStateCache");
    private final StateCache<MyState> b;

    public FileProcessingCompilerStateCache(File file, final ValidityStateFactory validityStateFactory) throws IOException {
        this.b = new StateCache<MyState>(new File(file, "timestamps")){

            @Override
            public MyState read(DataInput dataInput) throws IOException {
                return new MyState(dataInput.readLong(), validityStateFactory.createValidityState(dataInput));
            }

            @Override
            public void write(MyState myState, DataOutput dataOutput) throws IOException {
                dataOutput.writeLong(myState.getTimestamp());
                ValidityState validityState = myState.getExtState();
                if (validityState != null) {
                    validityState.save(dataOutput);
                }
            }
        };
    }

    public void update(VirtualFile virtualFile, ValidityState validityState) throws IOException {
        if (virtualFile.isValid()) {
            this.b.update(virtualFile.getUrl(), new MyState(virtualFile.getTimeStamp(), validityState));
        }
    }

    public void remove(String string) throws IOException {
        this.b.remove(string);
    }

    public long getTimestamp(String string) throws IOException {
        MyState myState;
        Serializable serializable = this.b.getState(string);
        if (serializable != null) {
            a.assertTrue(serializable instanceof MyState);
        }
        return (myState = (MyState)serializable) != null ? myState.getTimestamp() : -1L;
    }

    public ValidityState getExtState(String string) throws IOException {
        MyState myState = this.b.getState(string);
        return myState != null ? myState.getExtState() : null;
    }

    public void force() {
        this.b.force();
    }

    public Collection<String> getUrls() throws IOException {
        return this.b.getUrls();
    }

    public boolean wipe() {
        return this.b.wipe();
    }

    public void close() {
        try {
            this.b.close();
        }
        catch (IOException iOException) {
            a.info((Throwable)iOException);
        }
    }

    private static class MyState
    implements Serializable {
        private final long a;
        private final ValidityState b;

        public MyState(long l2, @Nullable ValidityState validityState) {
            this.a = l2;
            this.b = validityState;
        }

        public long getTimestamp() {
            return this.a;
        }

        @Nullable
        public ValidityState getExtState() {
            return this.b;
        }
    }
}

